/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.assigner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import moea.commons.Entity;
import moea.commons.Population;
import moea.commons.comparator.ComparatorFitness;
import moea.commons.comparator.ComparatorPareto;
import moea.commons.comparator.ComparatorSigmas;
import moea.moga.genome.Chromosome;

public class AssignerSpea2 {
    protected int K;

    public AssignerSpea2(int K) {
        this.K = K;
    }

    public void assignFitness(Population<Chromosome> pop) {
        int compare;
        int j;
        Chromosome indI;
        int popSize = pop.size();
        int[] strength = new int[popSize];
        int[] raw = new int[popSize];
        double[] density = new double[popSize];
        ComparatorPareto comparator = ComparatorPareto.getInstance();
        int i = 0;
        while (i < popSize) {
            strength[i] = 0;
            raw[i] = 0;
            density[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < popSize) {
            indI = (Chromosome)pop.get(i);
            j = 0;
            while (j < popSize) {
                if (i != j && (compare = comparator.compare(indI, (Entity)pop.get(j))) == -1) {
                    int n = i;
                    strength[n] = strength[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < popSize) {
            indI = (Chromosome)pop.get(i);
            j = 0;
            while (j < popSize) {
                if (i != j && (compare = comparator.compare(indI, (Entity)pop.get(j))) == 1) {
                    int n = i;
                    raw[n] = raw[n] + strength[j];
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < popSize) {
            double sigma = this.calculateSigma(i, pop);
            density[i] = 1.0 / (sigma + 2.0);
            double fitness = (double)raw[i] + density[i];
            ((Chromosome)pop.get(i)).setProperty("fitness", fitness);
            ++i;
        }
    }

    public Population<Chromosome> reduceByFitness(Population<Chromosome> pop) {
        Population<Chromosome> result = new Population<Chromosome>();
        int i = 0;
        while (i < pop.size()) {
            Chromosome indI = (Chromosome)pop.get(i);
            if (indI.getProperty("fitness").doubleValue() < 1.0) {
                result.add(indI);
            }
            ++i;
        }
        return result;
    }

    public void expand(Population<Chromosome> pop, Population<Chromosome> all, int nElems) {
        int i = 0;
        int count = 0;
        int allSize = all.size();
        Collections.sort(all, ComparatorFitness.getInstance());
        i = 0;
        while (i < allSize) {
            Chromosome indI = (Chromosome)all.get(i);
            if (indI.getProperty("fitness").doubleValue() >= 1.0) {
                pop.add(indI);
                if (++count == nElems) break;
            }
            ++i;
        }
    }

    public Population<Chromosome> reduce(Population<Chromosome> pop, int maxSize) {
        ArrayList<ArrayList<Double>> allSigmas = new ArrayList<ArrayList<Double>>();
        ComparatorSigmas comparator = ComparatorSigmas.getInstance();
        HashSet<Integer> erased = new HashSet<Integer>();
        int toErase = pop.size() - maxSize;
        int i = 0;
        while (i < pop.size()) {
            allSigmas.add(this.calculateSigmas(i, pop));
            ++i;
        }
        while (erased.size() < toErase) {
            int min = 0;
            while (erased.contains(min)) {
                ++min;
            }
            i = 0;
            while (i < pop.size()) {
                if (i != min && !erased.contains(i) && comparator.compare((ArrayList)allSigmas.get(i), (ArrayList)allSigmas.get(min)) == -1) {
                    min = i;
                }
                ++i;
            }
            erased.add(min);
        }
        Population<Chromosome> result = new Population<Chromosome>();
        i = 0;
        while (i < pop.size()) {
            if (!erased.contains(i)) {
                result.add((Chromosome)pop.get(i));
            }
            ++i;
        }
        return result;
    }

    private double calculateSigma(int i, Population<Chromosome> pop) {
        return this.calculateSigmas(i, pop).get(this.K);
    }

    private ArrayList<Double> calculateSigmas(int i, Population<Chromosome> pop) {
        int popSize = pop.size();
        ArrayList<Double> distancesToI = new ArrayList<Double>();
        Chromosome indI = (Chromosome)pop.get(i);
        int j = 0;
        while (j < popSize) {
            double distance = indI.getObjectiveVector().euclideanDistance(((Chromosome)pop.get(j)).getObjectiveVector());
            distancesToI.add(distance);
            ++j;
        }
        Collections.sort(distancesToI);
        return distancesToI;
    }
}

