/*
 * Decompiled with CFR 0.152.
 */
package moea.mopso.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import moea.commons.Entity;
import moea.commons.Population;
import moea.commons.comparator.ComparatorEuclidean;
import moea.commons.comparator.ComparatorFitness;
import moea.commons.comparator.ComparatorPareto;
import moea.commons.comparator.ComparatorSigmas;
import moea.mopso.algorithms.MOPSO;
import moea.mopso.society.Particle;

public class SPSO
extends MOPSO {
    protected Population<Particle> pop2 = new Population();
    protected int pop2SizeMax = this.popSizeMax;
    protected int K = (int)Math.sqrt(this.popSizeMax + this.pop2SizeMax);

    public SPSO(String name, Population<Particle> popIni, int maxT) {
        super(name, popIni, maxT);
    }

    @Override
    public void step() {
        this.pop2 = this.getPopulation();
        Collections.sort(this.pop2, ComparatorEuclidean.getInstance());
        this.pop = new Population();
        for (Particle pTemp : this.pop2) {
            this.pop.add(pTemp.clone());
        }
        Particle p = null;
        int i = 0;
        while (i < this.pop.size()) {
            p = (Particle)this.pop.get(i);
            p.updatePosition();
            p.updateVelocity();
            p.applyConstraints();
            p.mutate(1.0 / (double)Particle.getM());
            p.updatePBest();
            p.updateGBest((Particle)this.pop2.get(0));
            ++i;
        }
        ++this.t;
    }

    @Override
    public Population<Particle> getPopulation() {
        Population<Particle> pop12 = new Population<Particle>();
        pop12.add(this.pop);
        pop12.add(this.pop2);
        this.assignFitness(pop12);
        Population<Particle> pop12Reduced = this.reduceByFitness(pop12);
        if (pop12Reduced.size() < this.pop2SizeMax) {
            this.expand(pop12Reduced, pop12, this.pop2SizeMax - pop12Reduced.size());
        } else if (pop12Reduced.size() > this.pop2SizeMax) {
            pop12Reduced = this.reduce(pop12Reduced, this.pop2SizeMax);
        }
        return pop12Reduced;
    }

    public void assignFitness(Population<Particle> pop) {
        int compare;
        int j;
        Particle indI;
        int popSize = pop.size();
        int[] strength = new int[popSize];
        int[] raw = new int[popSize];
        double[] density = new double[popSize];
        ComparatorPareto comparator = ComparatorPareto.getInstance();
        int i = 0;
        while (i < popSize) {
            strength[i] = 0;
            raw[i] = 0;
            density[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < popSize) {
            indI = (Particle)pop.get(i);
            j = 0;
            while (j < popSize) {
                if (i != j && (compare = comparator.compare(indI, (Entity)pop.get(j))) == -1) {
                    int n = i;
                    strength[n] = strength[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < popSize) {
            indI = (Particle)pop.get(i);
            j = 0;
            while (j < popSize) {
                if (i != j && (compare = comparator.compare(indI, (Entity)pop.get(j))) == 1) {
                    int n = i;
                    raw[n] = raw[n] + strength[j];
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < popSize) {
            double sigma = this.calculateSigma(i, pop);
            density[i] = 1.0 / (sigma + 2.0);
            double fitness = (double)raw[i] + density[i];
            ((Particle)pop.get(i)).setProperty("fitness", fitness);
            ++i;
        }
    }

    public Population<Particle> reduceByFitness(Population<Particle> pop) {
        Population<Particle> result = new Population<Particle>();
        int i = 0;
        while (i < pop.size()) {
            Particle indI = (Particle)pop.get(i);
            if (indI.getProperty("fitness").doubleValue() < 1.0) {
                result.add(indI);
            }
            ++i;
        }
        return result;
    }

    public void expand(Population<Particle> pop, Population<Particle> all, int nElems) {
        int i = 0;
        int count = 0;
        int allSize = all.size();
        Collections.sort(all, ComparatorFitness.getInstance());
        i = 0;
        while (i < allSize) {
            Particle indI = (Particle)all.get(i);
            if (indI.getProperty("fitness").doubleValue() >= 1.0) {
                pop.add(indI);
                if (++count == nElems) break;
            }
            ++i;
        }
    }

    public Population<Particle> reduce(Population<Particle> pop, int maxSize) {
        ArrayList<ArrayList<Double>> allSigmas = new ArrayList<ArrayList<Double>>();
        ComparatorSigmas comparator = ComparatorSigmas.getInstance();
        HashSet<Integer> erased = new HashSet<Integer>();
        int toErase = pop.size() - maxSize;
        int i = 0;
        while (i < pop.size()) {
            allSigmas.add(this.calculateSigmas(i, pop));
            ++i;
        }
        while (erased.size() < toErase) {
            int min = 0;
            while (erased.contains(min)) {
                ++min;
            }
            i = 0;
            while (i < pop.size()) {
                if (i != min && !erased.contains(i) && comparator.compare((ArrayList)allSigmas.get(i), (ArrayList)allSigmas.get(min)) == -1) {
                    min = i;
                }
                ++i;
            }
            erased.add(min);
        }
        Population<Particle> result = new Population<Particle>();
        i = 0;
        while (i < pop.size()) {
            if (!erased.contains(i)) {
                result.add((Particle)pop.get(i));
            }
            ++i;
        }
        return result;
    }

    private double calculateSigma(int i, Population<Particle> pop) {
        return this.calculateSigmas(i, pop).get(this.K);
    }

    private ArrayList<Double> calculateSigmas(int i, Population<Particle> pop) {
        int popSize = pop.size();
        ArrayList<Double> distancesToI = new ArrayList<Double>();
        Particle indI = (Particle)pop.get(i);
        int j = 0;
        while (j < popSize) {
            double distance = indI.getObjectiveVector().euclideanDistance(((Particle)pop.get(j)).getObjectiveVector());
            distancesToI.add(distance);
            ++j;
        }
        Collections.sort(distancesToI);
        return distancesToI;
    }
}

