/*
 * Decompiled with CFR 0.152.
 */
package moea.mopso.society;

import moea.commons.Individual;
import moea.commons.comparator.ComparatorPareto;

public abstract class Particle
extends Individual {
    protected double w;
    protected double c1;
    protected double c2;
    protected double[] v;
    protected Particle pBest;
    protected Particle gBest;

    public abstract Particle clone();

    public Particle(double w, double c1, double c2) {
        this.w = w;
        this.c1 = c1;
        this.c2 = c2;
        this.v = new double[M];
        int j = 0;
        while (j < M) {
            this.v[j] = 0.0;
            ++j;
        }
        this.pBest = null;
        this.gBest = null;
    }

    public Particle() {
        this(0.55, 1.25, 1.25);
    }

    public Particle(Particle src) {
        super(src);
        this.w = src.w;
        this.c1 = src.c1;
        this.c2 = src.c2;
        this.v = new double[M];
        int j = 0;
        while (j < M) {
            this.v[j] = src.v[j];
            ++j;
        }
        this.pBest = src.pBest;
        this.gBest = src.gBest;
    }

    public void mutate(double p) {
        int j = 0;
        while (j < M) {
            if (Math.random() <= p) {
                this.x[j] = xL[j] + Math.random() * (xU[j] - xL[j]);
            }
            ++j;
        }
        super.invalidateScores();
    }

    public void applyConstraints() {
        int j = 0;
        while (j < M) {
            if (this.x[j] < xL[j]) {
                this.x[j] = xL[j];
                this.v[j] = -this.v[j];
            }
            if (this.x[j] > xU[j]) {
                this.x[j] = xU[j];
                this.v[j] = -this.v[j];
            }
            ++j;
        }
        super.invalidateScores();
    }

    public void updatePosition() {
        int j = 0;
        while (j < M) {
            int n = j;
            this.x[n] = this.x[n] + this.v[j];
            ++j;
        }
        super.invalidateScores();
    }

    public void updateVelocity() {
        int j = 0;
        while (j < M) {
            double r1 = Math.random();
            double r2 = Math.random();
            this.v[j] = this.w * this.v[j];
            if (this.pBest != null) {
                int n = j;
                this.v[n] = this.v[n] + this.c1 * r1 * (this.pBest.x[j] - this.x[j]);
            }
            if (this.gBest != null) {
                int n = j;
                this.v[n] = this.v[n] + this.c2 * r2 * (this.gBest.x[j] - this.x[j]);
            }
            ++j;
        }
    }

    public void updatePBest() {
        ComparatorPareto comparator = ComparatorPareto.getInstance();
        if (this.pBest == null || comparator.compare(this, this.pBest) == -1) {
            this.pBest = this.clone();
        }
    }

    public void updateGBest(Particle best) {
        this.gBest = best == null ? null : best.clone();
    }

    public void setW(double w) {
        this.w = w;
    }

    public void setC1(double c1) {
        this.c1 = c1;
    }

    public void setC2(double c2) {
        this.c2 = c2;
    }

    public double getW() {
        return this.w;
    }

    public double getC1() {
        return this.c1;
    }

    public double getC2() {
        return this.c2;
    }

    public Particle getPBest() {
        return this.pBest;
    }
}

