/*
 * Decompiled with CFR 0.152.
 */
package simView;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import simView.ComponentView;
import simView.ComponentViewUtil;
import simView.DragViewListener;
import simView.PortBox;
import simView.SimView;
import simView.ViewableAtomic;
import simView.ViewableComponent;
import util.HtmlUtil;
import util.StringUtil;

public class AtomicView
extends JPanel
implements ComponentView {
    private static final long serialVersionUID = 1L;
    protected Map nameToPortBox = new HashMap();
    protected ViewableAtomic atomic;
    protected CompBox compBox;
    protected JPanel inportsPanel;
    protected JPanel outportsPanel;
    protected SimView.ModelView modelView;

    public AtomicView(ViewableAtomic atomic_, SimView.ModelView modelView_) {
        this.atomic = atomic_;
        this.modelView = modelView_;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        JPanel panel = this.inportsPanel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        this.add(panel);
        ComponentViewUtil.createPortBoxes(panel, this.atomic.getInportNames(), true, true, this.nameToPortBox, this.atomic, this.modelView, null);
        this.compBox = new CompBox();
        this.add(this.compBox);
        panel = this.outportsPanel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        this.add(panel);
        ComponentViewUtil.createPortBoxes(panel, this.atomic.getOutportNames(), false, false, this.nameToPortBox, this.atomic, this.modelView, null);
    }

    public void phaseChanged() {
        this.repaint();
    }

    public void sigmaChanged() {
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.compBox.getPreferredSize();
        size.width += this.inportsPanel.getPreferredSize().width + this.outportsPanel.getPreferredSize().width;
        return size;
    }

    protected void updateTooltip() {
        StringBuffer text = new StringBuffer();
        text.append(HtmlUtil.yellowTooltipHeader);
        text.append(StringUtil.replaceAll(this.atomic.getTooltipText(), "\n", "<br>"));
        text.append("</font></body></html>");
        this.compBox.setToolTipText(text.toString());
    }

    @Override
    public Point getPortLocation(String portName) {
        return ComponentViewUtil.getPortLocation(this, portName, this.nameToPortBox);
    }

    @Override
    public void injectAll() {
        ComponentViewUtil.injectAll(this);
    }

    @Override
    public Point getPreferredLocation() {
        return this.atomic.getPreferredLocation();
    }

    @Override
    public ViewableComponent getViewableComponent() {
        return this.atomic;
    }

    public ViewableAtomic getAtomic() {
        return this.atomic;
    }

    protected class CompBox
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected Font nameFont = new Font("SansSerif", 1, 12);
        protected FontMetrics nameFontMetrics = this.getFontMetrics(this.nameFont);
        protected Font phaseFont = new Font("SansSerif", 1, 14);
        protected FontMetrics phaseFontMetrics = this.getFontMetrics(this.phaseFont);
        protected int nameWidth;

        public CompBox() {
            this.nameWidth = this.nameFontMetrics.stringWidth(AtomicView.this.atomic.getName());
            this.setToolTipText("");
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    AtomicView.this.updateTooltip();
                }
            });
            DragViewListener listener = new DragViewListener(AtomicView.this, AtomicView.this.modelView);
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = new Dimension();
            size.width = Math.max(this.nameWidth + 10, 100);
            size.height = Math.max((this.phaseFontMetrics.getAscent() + 2) * 3, Math.max(AtomicView.this.atomic.getNumInports(), AtomicView.this.atomic.getNumOutports()) * PortBox.nameFontAscent * 3 / 2);
            return size;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(AtomicView.this.atomic.getBackgroundColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            g.setFont(this.nameFont);
            g.drawString(AtomicView.this.atomic.getName(), this.getWidth() / 2 - this.nameWidth / 2, this.nameFontMetrics.getAscent() + 2);
            g.setColor(Color.blue);
            g.setFont(this.phaseFont);
            String phase = AtomicView.this.atomic.getFormattedPhase();
            if (phase == null) {
                phase = "no phase";
            }
            g.drawString(phase, this.getWidth() / 2 - this.phaseFontMetrics.stringWidth(phase) / 2, this.getHeight() / 2 + this.phaseFontMetrics.getAscent() / 2 - 1);
            g.setColor(Color.black);
            g.setFont(this.nameFont);
            String sigma = "\u03c3 = " + AtomicView.this.atomic.getFormattedSigma();
            g.drawString(sigma, this.getWidth() / 2 - this.nameFontMetrics.stringWidth(sigma) / 2, this.getHeight() - 4);
        }
    }
}

