/*
 * Decompiled with CFR 0.152.
 */
package simView;

import genDevs.modeling.content;
import genDevs.modeling.message;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import simView.ComponentView;
import simView.DragViewListener;
import simView.PortBox;
import simView.SimView;
import simView.TestInput;
import simView.ViewableComponent;
import util.ComponentUtil;
import util.NumericStringComparator;
import util.PointUtil;

public class ComponentViewUtil {
    public static void createPortBoxes(JPanel portsPanel, List names, boolean in, boolean extendLeft, Map nameToPortBox, ViewableComponent component, SimView.ModelView modelView, DragViewListener dragViewListener) {
        TreeSet sortedNames = new TreeSet(new NumericStringComparator());
        sortedNames.addAll(names);
        for (String name : sortedNames) {
            PortBox box = new PortBox(name, in, extendLeft, component, modelView);
            portsPanel.add(box);
            box.setAlignmentX(extendLeft ? 1.0f : 0.0f);
            nameToPortBox.put(name, box);
            if (dragViewListener == null) continue;
            box.addMouseListener(dragViewListener);
            box.addMouseMotionListener(dragViewListener);
        }
    }

    public static Point getPortLocation(ComponentView view, String portName, Map nameToPortBox) {
        PortBox box = (PortBox)nameToPortBox.get(portName);
        if (box == null) {
            return new Point();
        }
        Point location = ComponentUtil.getLocationRelativeToAncestor(box, (JComponent)((Object)view));
        PointUtil.translate(location, box.getPinLocation());
        return location;
    }

    public static void injectAll(ComponentView view) {
        message m = new message();
        ViewableComponent component = view.getViewableComponent();
        Iterator i = component.getInportNames().iterator();
        while (i.hasNext()) {
            List inputs = component.getTestInputs((String)i.next());
            if (inputs == null) continue;
            for (TestInput input : inputs) {
                m.add(new content(input.portName, input.value));
            }
        }
        component.getSimulator().simInject(0.0, m);
    }
}

