/*
 * Decompiled with CFR 0.152.
 */
package simView;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import simView.AtomicView;
import simView.ComponentView;
import simView.ComponentViewUtil;
import simView.DragViewListener;
import simView.PortBox;
import simView.SimView;
import simView.ViewableComponent;
import simView.ViewableDigraph;
import util.HtmlUtil;
import util.StringUtil;

public class DigraphView
extends JPanel
implements ComponentView {
    private static final long serialVersionUID = 1L;
    protected int blackBoxWidth;
    protected int blackBoxHeight;
    protected Map nameToPortBox = new HashMap();
    protected JPanel componentsPanel;
    protected SimView.ModelView modelView;
    protected ViewableDigraph digraph;
    protected Font nameFont = new Font("SansSerif", 0, 12);
    protected FontMetrics nameFontMetrics = this.getFontMetrics(this.nameFont);
    protected int nameWidth;
    protected int nameAscent = this.nameFontMetrics.getAscent();

    public DigraphView(ViewableDigraph digraph_, SimView.ModelView modelView_) {
        JPanel outportsPanel;
        JPanel inportsPanel;
        this.digraph = digraph_;
        this.modelView = modelView_;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        DragViewListener dragListener = new DragViewListener(this, this.modelView);
        JPanel panel = inportsPanel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        this.add(panel);
        ComponentViewUtil.createPortBoxes(panel, this.digraph.getInportNames(), true, false, this.nameToPortBox, this.digraph, this.modelView, dragListener);
        panel = this.componentsPanel = new ComponentsPanel();
        panel.setOpaque(false);
        panel.setLayout(null);
        this.add(panel);
        panel.addMouseListener(dragListener);
        panel.addMouseMotionListener(dragListener);
        panel = outportsPanel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        this.add(panel);
        ComponentViewUtil.createPortBoxes(panel, this.digraph.getOutportNames(), false, true, this.nameToPortBox, null, this.modelView, dragListener);
        String name = this.digraph.getName();
        this.nameWidth = this.nameFontMetrics.stringWidth(name);
        this.blackBoxWidth = this.nameWidth + 20 + inportsPanel.getPreferredSize().width + outportsPanel.getPreferredSize().width;
        this.blackBoxHeight = Math.max(this.digraph.getNumInports(), this.digraph.getNumOutports()) * PortBox.nameFontAscent * 3 / 2;
        this.blackBoxHeight = Math.max(this.blackBoxHeight, this.nameFontMetrics.getHeight() + 10);
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        g.drawRect(0, 0, width - 1, this.getHeight() - 1);
        super.paint(g);
    }

    @Override
    public Point getPreferredLocation() {
        return this.digraph.getPreferredLocation();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.digraph.isBlackBox()) {
            return this.digraph.getPreferredSize();
        }
        return new Dimension(this.blackBoxWidth, this.blackBoxHeight);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (comp instanceof AtomicView || comp instanceof DigraphView) {
            this.componentsPanel.add(comp, constraints);
            return;
        }
        super.add(comp, constraints);
    }

    @Override
    public Point getPortLocation(String portName) {
        return ComponentViewUtil.getPortLocation(this, portName, this.nameToPortBox);
    }

    @Override
    public ViewableComponent getViewableComponent() {
        return this.digraph;
    }

    public ViewableDigraph getDigraph() {
        return this.digraph;
    }

    @Override
    public void injectAll() {
        ComponentViewUtil.injectAll(this);
    }

    protected class ComponentsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected Rectangle nameBox = new Rectangle();

        public ComponentsPanel() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ComponentsPanel.this.updateTooltip();
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            if (this.nameBox.height == 0) {
                this.nameBox.x = this.getWidth() / 2 - DigraphView.this.nameWidth / 2;
                this.nameBox.y = 0;
                this.nameBox.width = DigraphView.this.nameWidth;
                this.nameBox.height = DigraphView.this.nameAscent;
            }
            g.setFont(DigraphView.this.nameFont);
            String name = DigraphView.this.digraph.getName();
            g.drawString(name, this.getWidth() / 2 - DigraphView.this.nameWidth / 2, DigraphView.this.nameAscent);
            if (DigraphView.this.digraph.isBlackBox()) {
                return;
            }
            super.paint(g);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            if (this.nameBox.contains(event.getPoint())) {
                return this.getToolTipText();
            }
            return null;
        }

        protected void updateTooltip() {
            StringBuffer text = new StringBuffer();
            text.append(HtmlUtil.yellowTooltipHeader);
            text.append(StringUtil.replaceAll(DigraphView.this.digraph.getTooltipText(), "\n", "<br>"));
            text.append("</font></body></html>");
            this.setToolTipText(text.toString());
        }
    }
}

