/*
 * Decompiled with CFR 0.152.
 */
package simView;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import simView.ComponentView;
import simView.DigraphView;
import simView.SimView;
import simView.ViewableDigraph;
import util.PointUtil;

public class DragViewListener
extends MouseInputAdapter {
    protected Point cursorDeltaFromView;
    protected JComponent view;
    protected SimView.ModelView modelView;
    protected boolean resizing;
    protected Cursor resizeCursor;

    public DragViewListener(JComponent view_, SimView.ModelView modelView_) {
        this.view = view_;
        this.modelView = modelView_;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e = this.convertEvent(e);
        this.cursorDeltaFromView = e.getPoint();
        this.resizing = false;
        if (this.view instanceof DigraphView && this.resizeCursor != null) {
            this.resizing = true;
        }
    }

    protected MouseEvent convertEvent(MouseEvent e) {
        if (e.getSource() != this.view) {
            e = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, this.view);
        }
        return e;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!(this.view instanceof DigraphView)) {
            return;
        }
        if (this.resizing) {
            return;
        }
        e = this.convertEvent(e);
        Point location = e.getPoint();
        this.detmResizeCursor(location);
        if (this.resizeCursor != null) {
            this.modelView.setCursor(this.resizeCursor);
        } else {
            this.modelView.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.resizing) {
            this.modelView.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.resizing = false;
        this.modelView.setCursor(Cursor.getDefaultCursor());
    }

    protected void detmResizeCursor(Point location) {
        int borderWidth = 6;
        int type = 0;
        int x = location.x;
        int y = location.y;
        int width = this.view.getWidth();
        int height = this.view.getHeight();
        if (x >= width - 6 && y >= height - 6) {
            type = 5;
        } else if (x >= width - 6 && y < 6) {
            type = 7;
        } else if (x < 6 && y >= height - 6) {
            type = 4;
        } else if (x < 6 && y < 6) {
            type = 6;
        } else if (x < 6) {
            type = 10;
        } else if (y < 6) {
            type = 8;
        } else if (x >= width - 6) {
            type = 11;
        } else if (y >= height - 6) {
            type = 9;
        }
        this.resizeCursor = type != 0 ? Cursor.getPredefinedCursor(type) : null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e = this.convertEvent(e);
        Point location = e.getPoint();
        if (this.resizing) {
            this.resizeView(location);
            this.view.revalidate();
            ViewableDigraph digraph2 = (ViewableDigraph)((ComponentView)((Object)this.view)).getViewableComponent();
            digraph2.setPreferredSize(new Dimension(location.x, location.y));
        } else {
            PointUtil.translate(location, this.view.getLocation());
            PointUtil.negativeTranslate(location, this.cursorDeltaFromView);
            this.view.setLocation(location);
            if (this.view instanceof ComponentView) {
                ((ComponentView)((Object)this.view)).getViewableComponent().setPreferredLocation(location);
                Container parent = this.view.getParent();
                do {
                    if (!(parent instanceof DigraphView)) continue;
                    ((DigraphView)parent).getDigraph().setLayoutChanged(true);
                    break;
                } while ((parent = parent.getParent()) != this.modelView && parent != null);
            }
        }
        this.modelView.repaint();
    }

    protected void resizeView(Point dragLocation) {
        if (this.resizeCursor == null) {
            return;
        }
        int x = dragLocation.x;
        int y = dragLocation.y;
        int viewx = this.view.getX();
        int viewy = this.view.getY();
        int width = this.view.getWidth();
        int height = this.view.getHeight();
        int type = this.resizeCursor.getType();
        if (type == 5) {
            this.view.setSize(x, y);
        } else if (type == 6) {
            this.view.setBounds(viewx + x, viewy + y, width - x, height - y);
        } else if (type == 4) {
            this.view.setBounds(viewx + x, viewy, width - x, y);
        } else if (type == 7) {
            this.view.setBounds(viewx, viewy + y, x, height - y);
        } else if (type == 8) {
            this.view.setBounds(viewx, viewy + y, width, height - y);
        } else if (type == 9) {
            this.view.setBounds(viewx, viewy, width, y);
        } else if (type == 10) {
            this.view.setBounds(viewx + x, viewy, width - x, height);
        } else if (type == 11) {
            this.view.setBounds(viewx, viewy, x, height);
        }
    }
}

