/*
 * Decompiled with CFR 0.152.
 */
package simView;

import genDevs.modeling.content;
import genDevs.modeling.message;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import simView.SimView;
import simView.TestInput;
import simView.ViewableComponent;

public class PortBox
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected ViewableComponent component;
    protected SimView.ModelView modelView;
    protected String portName;
    protected int labelWidth;
    protected boolean in;
    protected boolean extendsLeft;
    protected int pinX;
    protected final int pinWidth = 8;
    protected final int spaceBetweenPinAndName = 8;
    protected final int lineLength = 4;
    protected static Font nameFont = new Font("SansSerif", 0, 10);
    protected static FontMetrics nameFontMetrics = new JPanel().getFontMetrics(nameFont);
    public static int nameFontAscent = nameFontMetrics.getAscent();

    public PortBox(String portName_, boolean in_, boolean extendsLeft_, ViewableComponent component_, SimView.ModelView modelView_) {
        this.portName = portName_;
        this.in = in_;
        this.extendsLeft = extendsLeft_;
        this.component = component_;
        this.modelView = modelView_;
        this.labelWidth = nameFontMetrics.stringWidth(this.portName);
        this.setOpaque(false);
        if (this.in && this.component != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    List inputs = event.isControlDown() ? PortBox.this.component.getTestInputs(PortBox.this.portName) : PortBox.this.component.getTestInputs();
                    InputsDialog dialog = new InputsDialog(inputs);
                    Point location = new Point(PortBox.this.getLocation());
                    SwingUtilities.convertPointToScreen(location, PortBox.this);
                    dialog.setLocation(location);
                    dialog.setVisible(true);
                }
            });
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PortBox.this.modelView.mouseEnteredPort();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PortBox.this.modelView.mouseExitedPort();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.black);
        int width = this.getWidth();
        int pinHeight = 8;
        this.pinX = this.extendsLeft ? width - 4 - 8 : 4;
        g.fillOval(this.pinX, this.getHeight() / 2 - pinHeight / 2 + 1, 8, pinHeight);
        int lineY = this.getHeight() / 2 + 1;
        g.drawLine(this.extendsLeft ? width : 0, lineY, this.pinX, lineY);
        g.setColor(Color.black);
        g.setFont(nameFont);
        int nameX = !this.extendsLeft ? 16 : width - 8 - 8 - this.labelWidth;
        g.drawString(this.portName, nameX, this.getHeight() / 2 + nameFontAscent / 3 + 1);
    }

    public Point getPinLocation() {
        return new Point(this.pinX + 4, this.getHeight() / 2 + 1);
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 28 + this.labelWidth;
        return new Dimension(width, super.getPreferredSize().height);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.getPreferredSize().width, Integer.MAX_VALUE);
    }

    protected class InputsDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public InputsDialog(List inputs) {
            super((Frame)SwingUtilities.getWindowAncestor(PortBox.this), "Inputs");
            this.setModal(true);
            this.setSize(200, 150);
            Container pane = this.getContentPane();
            pane.setLayout(new BorderLayout());
            final JList<Object> list = new JList<Object>();
            list.setFont(new Font("SansSerif", 0, 10));
            pane.add((Component)new JScrollPane(list), "Center");
            if (inputs != null) {
                list.setListData(inputs.toArray());
            }
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            pane.add((Component)panel, "South");
            JButton button = new JButton("inject");
            button.setFont(new Font("SansSerif", 0, 10));
            panel.add(button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InputsDialog.this.setVisible(false);
                    InputsDialog.this.inject(list.getSelectedValues());
                }
            });
        }

        protected void inject(Object[] inputs) {
            if (inputs.length == 0) {
                return;
            }
            message m = new message();
            double e = Double.MAX_VALUE;
            int i = 0;
            while (i < inputs.length) {
                TestInput input = (TestInput)inputs[i];
                m.add(new content(input.portName, input.value));
                e = Math.min(e, input.e);
                ++i;
            }
            PortBox.this.component.getSimulator().simInject(e, m);
            PortBox.this.modelView.inputInjected();
        }
    }
}

