/*
 * Decompiled with CFR 0.152.
 */
package simView;

import GenCol.entity;
import genDevs.modeling.atomic;
import genDevs.simulation.atomicSimulator;
import java.awt.Color;
import java.awt.Point;
import java.text.DecimalFormat;
import java.util.List;
import simView.AtomicView;
import simView.ComponentView;
import simView.SimView;
import simView.ViewableComponent;
import simView.ViewableComponentBase;
import simView.ViewableComponentUtil;

public class ViewableAtomic
extends atomic
implements ViewableComponent {
    private static final long serialVersionUID = 6135295523330460865L;
    protected ViewableComponentBase base = new ViewableComponentBase();
    protected AtomicView view;
    protected Color backgroundColor = new Color(155, 155, 155);

    public ViewableAtomic(String name) {
        super(name);
    }

    public ViewableAtomic() {
        super("ViewableAtomic");
    }

    public String getFormattedSigma() {
        double sigma = this.getSigma();
        if (sigma >= Double.POSITIVE_INFINITY) {
            return "infinity";
        }
        return new DecimalFormat("0.000").format(sigma);
    }

    @Override
    public ComponentView getView() {
        return this.view;
    }

    public AtomicView getAtomicView() {
        return this.view;
    }

    public String getFormattedPhase() {
        String phase = this.getPhase();
        if (phase == null) {
            return null;
        }
        try {
            double numericValue = Double.parseDouble(phase);
            phase = new DecimalFormat("0.000").format(numericValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return phase;
    }

    @Override
    public int getNumInports() {
        return this.mh.getInports().size();
    }

    @Override
    public int getNumOutports() {
        return this.mh.getOutports().size();
    }

    public void createView(SimView.ModelView modelView) {
        this.view = new AtomicView(this, modelView);
        if (this.isHidden()) {
            this.view.setVisible(false);
        }
    }

    @Override
    public List getInportNames() {
        return ViewableComponentUtil.getPortNames(this.mh.getInports());
    }

    @Override
    public List getOutportNames() {
        return ViewableComponentUtil.getPortNames(this.mh.getOutports());
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void addTestInput(String portName, entity value) {
        this.addTestInput(portName, value, 0.0);
    }

    public void addTestInput(String portName, entity value, double e) {
        ViewableComponentUtil.addTestInput(portName, value, e, this.base.testInputs, this.base.testInputsByPortName);
    }

    @Override
    public List getTestInputs() {
        return this.base.testInputs;
    }

    @Override
    public List getTestInputs(String portName) {
        return (List)this.base.testInputsByPortName.get(portName);
    }

    @Override
    public atomicSimulator getSimulator() {
        return (atomicSimulator)((Object)this.getSim());
    }

    @Override
    public Point getPreferredLocation() {
        return this.base.preferredLocation;
    }

    @Override
    public void setPreferredLocation(Point location) {
        this.base.preferredLocation = location;
    }

    @Override
    public void setSigma(double sigma) {
        super.setSigma(sigma);
        if (this.view != null) {
            this.view.sigmaChanged();
        }
    }

    public String getTooltipText() {
        return "class: <font size=\"-2\">" + this.getClass().getName() + "</font><br>" + "phase: " + this.getFormattedPhase() + "<br>" + "sigma: " + this.getFormattedSigma() + "<br>" + "tL: " + this.getFormattedTL() + "<br>" + "tN: " + this.getFormattedTN();
    }

    protected String getFormattedTL() {
        return new DecimalFormat("0.000").format(((atomicSimulator)((Object)this.mySim)).getTL());
    }

    protected String getFormattedTN() {
        return new DecimalFormat("0.000").format(((atomicSimulator)((Object)this.mySim)).getTN());
    }

    @Override
    public String getLayoutName() {
        return this.base.layoutName != null ? this.base.layoutName : ViewableComponentUtil.buildLayoutName(this.name);
    }

    public void setLayoutName(String name) {
        this.base.layoutName = name;
    }

    @Override
    public boolean isHidden() {
        return this.base.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.base.hidden = hidden;
    }
}

