/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation;

import GenCol.EntityInterface;
import GenCol.Function;
import GenCol.Pair;
import genDevs.modeling.couprel;
import genDevs.simulation.atomicSimulator;
import genDevs.simulation.coordinator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AtomicSimulatorUtil {
    public static List getCouplingsToSourcePort(String portName, String sourceComponentName, couprel internalCouplings, couprel externalCouplings, Function modelToSimMap, Function internalModelToSimMap, atomicSimulator rootSim) {
        HashSet couplings = internalCouplings.translate(sourceComponentName, portName);
        List resolvedCouplings = AtomicSimulatorUtil.resolveCouplings(couplings, modelToSimMap, rootSim);
        if (externalCouplings != null) {
            couplings = externalCouplings.translate(sourceComponentName, portName);
            resolvedCouplings.addAll(AtomicSimulatorUtil.resolveCouplings(couplings, internalModelToSimMap, rootSim));
        }
        return resolvedCouplings;
    }

    protected static List resolveCouplings(Set couplings, Function modelToSimMap, atomicSimulator rootSim) {
        ArrayList<Pair> resolvedCouplings = new ArrayList<Pair>();
        for (Pair coupling : couplings) {
            EntityInterface component = AtomicSimulatorUtil.getComponentWithName((String)coupling.getKey(), modelToSimMap, rootSim);
            resolvedCouplings.add(new Pair(component, coupling.getValue()));
        }
        return resolvedCouplings;
    }

    public static EntityInterface getComponentWithName(String name, Function modelToSimMap, atomicSimulator rootSim) {
        atomicSimulator simulator = null;
        if (modelToSimMap != null) {
            simulator = (atomicSimulator)modelToSimMap.get(name);
        }
        if (simulator == null && rootSim != null) {
            simulator = rootSim;
        } else if (simulator == null) {
            return null;
        }
        EntityInterface model = simulator.getModel();
        if (simulator instanceof coordinator) {
            model = ((coordinator)simulator).getCoupled();
        }
        return model;
    }
}

