/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation.distributed;

import GenCol.Pair;
import genDevs.modeling.ContentInterface;
import genDevs.modeling.Coupled;
import genDevs.modeling.content;
import genDevs.modeling.coupledDevs;
import genDevs.simulation.distributed.RTCoordinatorClient;
import genDevs.simulation.distributed.RTCoordinatorServer;
import genDevs.simulation.distributed.SimulatorProxy;
import java.util.Iterator;
import util.Util;

public class RTCoordinatorServerAndClient
extends RTCoordinatorServer {
    private static final long serialVersionUID = -6444154584500547692L;
    protected RTCoordinatorClient client;

    public RTCoordinatorServerAndClient(coupledDevs devs2, String serverAddress, int serverPort, int myPort) {
        super(devs2, 0, myPort, false);
        while (this.registerCount > 0) {
            Util.sleep(1000L);
        }
        this.client = new RTCoordinatorClient((Coupled)devs2, serverAddress, serverPort);
    }

    @Override
    public void putMyMessages(ContentInterface content2) {
        this.client.putMyMessages(content2);
    }

    @Override
    public void sendDownMessages() {
        if (!this.input.isEmpty()) {
            Iterator i = this.convertInput(this.input).iterator();
            while (i.hasNext()) {
                Pair p = (Pair)i.next();
                SimulatorProxy proxy = (SimulatorProxy)this.modelToSim.get(p.getKey());
                if (proxy == null) continue;
                proxy.putMessages((content)p.getValue());
            }
        }
    }

    protected class RTCoordinatorClient
    extends genDevs.simulation.distributed.RTCoordinatorClient {
        private static final long serialVersionUID = 6227335744684871920L;

        public RTCoordinatorClient(Coupled devs2, String serverAddress, int serverPort) {
            super(devs2, serverAddress, serverPort);
        }

        @Override
        protected void createClient(Coupled devs2, String serverAddress, int serverPort) {
            this.client = new Client(devs2.getName(), serverAddress, serverPort);
        }

        @Override
        public void sendDownMessages() {
            RTCoordinatorServerAndClient.this.input = this.input;
            RTCoordinatorServerAndClient.this.sendDownMessages();
        }

        protected class Client
        extends RTCoordinatorClient.Client {
            public Client(String devsName, String serverAddress, int serverPort) {
                super(devsName, serverAddress, serverPort);
            }

            @Override
            protected void startSimulateMessageReceived(int numIterations) {
                RTCoordinatorServerAndClient.this.broadcast("startSimulate:" + numIterations);
            }

            @Override
            protected void initializeMessageReceived(String message2) {
                double currentTime = Double.parseDouble(message2.substring(message2.indexOf(58) + 1));
                RTCoordinatorServerAndClient.this.broadcast("initialize:" + currentTime);
            }
        }
    }
}

