/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation.realTime;

import GenCol.Pair;
import GenCol.Relation;
import genDevs.modeling.ActivityInterface;
import genDevs.modeling.ContentInterface;
import genDevs.modeling.IOBasicDevs;
import genDevs.modeling.MessageInterface;
import genDevs.modeling.content;
import genDevs.modeling.message;
import genDevs.simulation.CouplingProtocolInterface;
import genDevs.simulation.coupledSimulator;
import genDevs.simulation.realTime.CoupledRTSimulatorInterface;
import genDevs.simulation.realTime.RTCoordinatorInterface;
import genDevs.simulation.realTime.RTCoupledCoordinatorInterface;
import genDevs.simulation.realTime.RTcoupledCoordinator;
import genDevs.simulation.realTime.simTimer;
import java.util.Iterator;

public class coupledRTSimulator
extends coupledSimulator
implements CoupledRTSimulatorInterface {
    private static final long serialVersionUID = 2445738487170973541L;
    protected double startTime;
    protected int numIter;
    protected Thread myThread;
    protected boolean inputReady = false;
    protected boolean Elapsed = false;
    protected long timeToSleep;
    protected RTCoordinatorInterface myRTRootParent;
    protected RTcoupledCoordinator myRTParent;
    protected simTimer timer;

    public coupledRTSimulator(IOBasicDevs devs2) {
        super(devs2);
    }

    public coupledRTSimulator() {
    }

    @Override
    public synchronized void initialize() {
        this.myModel.initialize();
        this.tL = this.startTime = (double)this.timeInMillis();
        this.tN = this.tL + this.myModel.ta() * 1000.0;
        System.out.println("INITIALIZATION, relative time: 0, next event at: " + (this.tN - this.startTime) / 1000.0 + " seconds");
        this.myModel.showState();
        this.myThread = new Thread(this);
    }

    @Override
    public synchronized void initialize(double sTime) {
        this.myModel.initialize();
        this.tL = this.startTime = sTime;
        this.tN = this.tL + this.myModel.ta() * 1000.0;
        System.out.println("INITIALIZATION, relative time: 0, next event at: " + (this.tN - this.startTime) / 1000.0 + " seconds");
        this.myModel.showState();
        this.myThread = new Thread(this);
    }

    @Override
    public void setTN() {
        this.tN = (double)this.timeInMillis() + this.myModel.ta() * 1000.0;
    }

    @Override
    public double getTN() {
        return this.tN;
    }

    @Override
    public long timeInSecs() {
        return this.timeInMillis() / 1000L;
    }

    @Override
    public long timeInMillis() {
        return System.currentTimeMillis();
    }

    public void setRTRootParent(RTCoordinatorInterface r) {
        this.myRTRootParent = r;
    }

    public RTCoordinatorInterface getRTRootParent() {
        return this.myRTRootParent;
    }

    public void setRTParent(RTcoupledCoordinator r) {
        this.myRTParent = r;
    }

    public RTCoupledCoordinatorInterface getRTParent() {
        return this.myRTParent;
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.myModel.getName());
        this.setTN();
        int iter = 0;
        while (true) {
            if ((double)this.timeInMillis() < this.getTN() - 10.0) {
                this.timeToSleep = (long)(this.getTN() - (double)this.timeInMillis());
                if ((double)this.timeToSleep < Double.POSITIVE_INFINITY) {
                    this.timer = new simTimer(this, this.timeToSleep);
                    this.Elapsed = false;
                }
                this.waitForNextEvent();
                if (!this.inputReady) {
                    continue;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((double)this.timeInMillis() >= this.getTN() - 10.0) {
                this.Elapsed = true;
            }
            if (this.Elapsed) {
                this.computeInputOutput(this.getTN());
                this.showOutput();
                this.sendMessages();
                this.wrapDeltfunc(this.getTN());
            } else if (this.inputReady) {
                double externalEventTime = this.timeInMillis();
                if (externalEventTime > this.getTN()) {
                    externalEventTime = this.getTN();
                }
                this.wrapDeltfunc(externalEventTime);
            }
            if (this.timer != null) {
                this.timer.interrupt();
            }
            this.inputReady = false;
            this.Elapsed = false;
            this.tL = this.timeInMillis();
            this.tN = this.tL + this.myModel.ta() * 1000.0;
            ++iter;
        }
    }

    @Override
    public void sendMessages() {
        MessageInterface o = this.getOutput();
        if (o != null && !o.isEmpty()) {
            Relation r = this.convertMsg((message)this.getOutput());
            Iterator rit = r.iterator();
            while (rit.hasNext()) {
                CouplingProtocolInterface sim;
                Pair p = (Pair)rit.next();
                content co = (content)p.getValue();
                Object ds = p.getKey();
                if (this.modelToSim.get(ds) instanceof CoupledRTSimulatorInterface) {
                    sim = (CoupledRTSimulatorInterface)this.modelToSim.get(ds);
                    sim.putMessages(co);
                    continue;
                }
                if (this.modelToSim.get(ds) instanceof RTCoupledCoordinatorInterface) {
                    sim = (RTCoupledCoordinatorInterface)this.modelToSim.get(ds);
                    sim.putMessages(co);
                    continue;
                }
                RTCoupledCoordinatorInterface cci = this.getRTParent();
                RTCoordinatorInterface ci = this.getRTRootParent();
                if (cci != null) {
                    this.myRTParent.putMyMessages(co);
                    continue;
                }
                if (ci == null) continue;
                this.myRTRootParent.putMyMessages(co);
            }
        }
    }

    public synchronized void waitForNextEvent() {
        while (!this.inputReady && !this.Elapsed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void notifyElapsed() {
        this.Elapsed = true;
        this.notify();
    }

    @Override
    public void simulate(Integer i) {
        this.simulate((int)i);
    }

    @Override
    public void simulate(int NumIter) {
        this.numIter = NumIter;
        this.tN = this.nextTN();
        this.myThread.start();
    }

    @Override
    public void stopSimulate() {
        this.numIter = 0;
        this.myThread.interrupt();
    }

    @Override
    public void wrapDeltfunc(double t) {
        this.wrapDeltfunc(t, this.getInput());
        this.input = new message();
    }

    @Override
    public void wrapDeltfunc(double t, MessageInterface x) {
        if (x == null) {
            System.out.println("ERROR RECEIVED NULL INPUT  " + this.myModel.toString());
            return;
        }
        if (x.isEmpty() && !this.equalTN(t)) {
            return;
        }
        if (!x.isEmpty() && this.equalTN(t)) {
            double e = t - this.tL;
            this.myModel.deltcon(e / 1000.0, x);
        } else if (this.equalTN(t)) {
            this.myModel.deltint();
        } else if (!x.isEmpty()) {
            double e = t - this.tL;
            this.myModel.deltext(e / 1000.0, x);
        }
    }

    @Override
    public void startActivity(ActivityInterface a) {
        a.setSimulator(this);
        a.start();
    }

    @Override
    public synchronized void putMessages(ContentInterface c) {
        if (c == null) {
            return;
        }
        System.out.flush();
        this.input.add(c);
        this.inputReady = true;
        this.notify();
    }
}

