/*
 * Decompiled with CFR 0.152.
 */
package moea.commons;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import moea.commons.ObjectiveVector;

public abstract class Entity
implements Serializable {
    protected static int N;
    protected ObjectiveVector objectiveVector;
    protected boolean scoresValid;
    protected Map<String, Number> properties;

    public abstract void evaluate();

    public Entity() {
        this.objectiveVector = new ObjectiveVector();
        this.scoresValid = false;
        this.properties = new HashMap<String, Number>();
    }

    public Entity(Entity src) {
        this.objectiveVector = new ObjectiveVector(src.objectiveVector);
        this.scoresValid = src.scoresValid;
        this.properties = new HashMap<String, Number>();
        for (Map.Entry<String, Number> entry : src.properties.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        ObjectiveVector obj = this.getObjectiveVector();
        int i = 0;
        while (i < obj.size()) {
            result.append(obj.get(i) + "\t");
            ++i;
        }
        return result.toString();
    }

    public int compareTo(Entity right, Comparator<Entity> comparator) {
        return comparator.compare(this, right);
    }

    public ObjectiveVector getObjectiveVector() {
        if (!this.scoresValid) {
            this.evaluate();
            this.scoresValid = true;
        }
        return this.objectiveVector;
    }

    public void invalidateScores() {
        this.scoresValid = false;
    }

    public void setProperty(String name, Number value) {
        this.properties.put(name, value);
    }

    public Number getProperty(String name) {
        return this.properties.get(name);
    }

    public static int getN() {
        return N;
    }
}

