/*
 * Decompiled with CFR 0.152.
 */
package moea.commons.examples;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Collections;
import moea.commons.Entity;
import moea.commons.Individual;
import moea.commons.ObjectiveVector;
import moea.commons.Population;
import moea.commons.comparator.ComparatorObjective;

public class TestFunction<E extends Individual>
extends Individual {
    public static KindOfTestFunction kindOfTestFunction;

    public TestFunction() {
    }

    public TestFunction(String[] args) {
        double[] xLTemp = null;
        double[] xUTemp = null;
        if (args[0].equals("ZDT1")) {
            kindOfTestFunction = KindOfTestFunction.ZDT1;
        } else if (args[0].equals("ZDT2")) {
            kindOfTestFunction = KindOfTestFunction.ZDT2;
        } else if (args[0].equals("ZDT3")) {
            kindOfTestFunction = KindOfTestFunction.ZDT3;
        } else if (args[0].equals("ZDT4")) {
            kindOfTestFunction = KindOfTestFunction.ZDT4;
        } else if (args[0].equals("DTLZ2")) {
            kindOfTestFunction = KindOfTestFunction.DTLZ2;
        } else if (args[0].equals("DTLZ5")) {
            kindOfTestFunction = KindOfTestFunction.DTLZ5;
        } else if (args[0].equals("DTLZ7")) {
            kindOfTestFunction = KindOfTestFunction.DTLZ7;
        }
        switch (kindOfTestFunction) {
            case ZDT1: 
            case ZDT2: 
            case ZDT3: {
                N = 2;
                M = 30;
                xLTemp = new double[M];
                xUTemp = new double[M];
                int i = 0;
                while (i < M) {
                    xLTemp[i] = 0.0;
                    xUTemp[i] = 1.0;
                    ++i;
                }
                break;
            }
            case ZDT4: {
                N = 2;
                M = 10;
                xLTemp = new double[M];
                xUTemp = new double[M];
                xLTemp[0] = 0.0;
                xUTemp[0] = 1.0;
                int i = 1;
                while (i < M) {
                    xLTemp[i] = -5.0;
                    xUTemp[i] = 5.0;
                    ++i;
                }
                break;
            }
            case ZDT6: {
                N = 2;
                M = 10;
                xLTemp = new double[M];
                xUTemp = new double[M];
                int i = 0;
                while (i < M) {
                    xLTemp[i] = 0.0;
                    xUTemp[i] = 1.0;
                    ++i;
                }
                break;
            }
            case DTLZ2: {
                N = 3;
                M = 12;
                xLTemp = new double[M];
                xUTemp = new double[M];
                int i = 0;
                while (i < M) {
                    xLTemp[i] = 0.0;
                    xUTemp[i] = 1.0;
                    ++i;
                }
                break;
            }
            case DTLZ5: {
                N = 3;
                M = 12;
                xLTemp = new double[M];
                xUTemp = new double[M];
                int i = 0;
                while (i < M) {
                    xLTemp[i] = 0.0;
                    xUTemp[i] = 1.0;
                    ++i;
                }
                break;
            }
            case DTLZ7: {
                N = 3;
                M = 22;
                xLTemp = new double[M];
                xUTemp = new double[M];
                int i = 0;
                while (i < M) {
                    xLTemp[i] = 0.0;
                    xUTemp[i] = 1.0;
                    ++i;
                }
                break;
            }
        }
        xL = xLTemp;
        xU = xUTemp;
    }

    @Override
    public void evaluate() {
    }

    public void evaluateFunction(double[] x, ObjectiveVector objs) {
        int i = 0;
        while (i < N) {
            objs.set(i, 0.0);
            ++i;
        }
        int k = M - N + 1;
        double f1 = 0.0;
        double g = 0.0;
        double h = 0.0;
        switch (kindOfTestFunction) {
            case ZDT1: {
                f1 = x[0];
                g = 0.0;
                int j = 1;
                while (j < M) {
                    g += x[j];
                    ++j;
                }
                g /= (double)(M - 1);
                g *= 9.0;
                h = 1.0 - Math.sqrt(f1 / (g += 1.0));
                objs.set(0, f1);
                objs.set(1, g * h);
                break;
            }
            case ZDT2: {
                f1 = x[0];
                g = 0.0;
                int j = 1;
                while (j < M) {
                    g += x[j];
                    ++j;
                }
                g /= (double)(M - 1);
                g *= 9.0;
                h = 1.0 - f1 / (g += 1.0) * (f1 / g);
                objs.set(0, f1);
                objs.set(1, g * h);
                break;
            }
            case ZDT3: {
                f1 = x[0];
                g = 0.0;
                int j = 1;
                while (j < M) {
                    g += x[j];
                    ++j;
                }
                g /= (double)(M - 1);
                g *= 9.0;
                h = 1.0 - Math.sqrt(f1 / (g += 1.0)) - f1 / g * Math.sin(Math.PI * 10 * f1);
                objs.set(0, f1);
                objs.set(1, g * h);
                break;
            }
            case ZDT4: {
                f1 = x[0];
                g = 0.0;
                int j = 1;
                while (j < M) {
                    g += x[j] * x[j] - 10.0 * Math.cos(Math.PI * 4 * x[j]);
                    ++j;
                }
                h = 1.0 - Math.sqrt(f1 / (g += (double)(1 + 10 * (M - 1))));
                objs.set(0, f1);
                objs.set(1, g * h);
                break;
            }
            case ZDT6: {
                f1 = 1.0 - Math.exp(-4.0 * x[0]) * Math.pow(Math.sin(Math.PI * 6 * x[0]), 6.0);
                g = 0.0;
                int j = 1;
                while (j < M) {
                    g += x[j];
                    ++j;
                }
                g /= (double)(M - 1);
                g = Math.pow(g, 0.25);
                g *= 9.0;
                h = 1.0 - f1 / (g += 1.0) * (f1 / g);
                objs.set(0, f1);
                objs.set(1, g * h);
                break;
            }
            case DTLZ2: {
                int i2 = M - k + 1;
                while (i2 <= M) {
                    g += Math.pow(x[i2 - 1] - 0.5, 2.0);
                    ++i2;
                }
                i2 = 1;
                while (i2 <= N) {
                    double f = 1.0 + g;
                    int j = N - i2;
                    while (j >= 1) {
                        f *= Math.cos(x[j - 1] * Math.PI / 2.0);
                        --j;
                    }
                    if (i2 > 1) {
                        f *= Math.sin(x[N - i2] * Math.PI / 2.0);
                    }
                    objs.set(i2 - 1, f);
                    ++i2;
                }
                break;
            }
            case DTLZ5: {
                double[] theta = new double[N];
                int i3 = M - k + 1;
                while (i3 <= M) {
                    g += Math.pow(x[i3 - 1] - 0.5, 2.0);
                    ++i3;
                }
                double t = Math.PI / (4.0 * (1.0 + g));
                theta[0] = x[0] * Math.PI / 2.0;
                int i4 = 2;
                while (i4 <= N - 1) {
                    theta[i4 - 1] = t * (1.0 + 2.0 * g * x[i4 - 1]);
                    ++i4;
                }
                i4 = 1;
                while (i4 <= N) {
                    double f = 1.0 + g;
                    int j = N - i4;
                    while (j >= 1) {
                        f *= Math.cos(theta[j - 1]);
                        --j;
                    }
                    if (i4 > 1) {
                        f *= Math.sin(theta[N - i4]);
                    }
                    objs.set(i4 - 1, f);
                    ++i4;
                }
                break;
            }
            case DTLZ7: {
                int i5 = M - k + 1;
                while (i5 <= M) {
                    g += x[i5 - 1];
                    ++i5;
                }
                g = 1.0 + 9.0 * g / (double)k;
                i5 = 1;
                while (i5 <= N - 1) {
                    objs.set(i5 - 1, x[i5 - 1]);
                    ++i5;
                }
                h = 0.0;
                int j = 1;
                while (j <= N - 1) {
                    h += x[j - 1] / (1.0 + g) * (1.0 + Math.sin(Math.PI * 3 * x[j - 1]));
                    ++j;
                }
                h = (double)N - h;
                objs.set(N - 1, (1.0 + g) * h);
            }
        }
    }

    @Override
    public ObjectiveVector getObjectiveVector() {
        this.evaluateFunction(this.x, this.objectiveVector);
        return this.objectiveVector;
    }

    public Population<TestFunction<E>> loadParetoOptimalFront(String filePath) throws Exception {
        Population<TestFunction<TestFunction<E>>> paretoOptimalFront = new Population<TestFunction<TestFunction<E>>>();
        BufferedReader reader = new BufferedReader(new FileReader(new File(filePath)));
        String line = reader.readLine();
        while (line != null) {
            String[] parts = line.split(" ");
            TestFunction<E> p = new TestFunction<E>();
            int i = 0;
            while (i < N) {
                Double objValue = Double.valueOf(parts[i]);
                p.objectiveVector.set(i, objValue);
                ++i;
            }
            p.scoresValid = true;
            paretoOptimalFront.add(p);
            line = reader.readLine();
        }
        reader.close();
        return paretoOptimalFront;
    }

    public Population<TestFunction<E>> generateParetoOptimalFront(int num) {
        Population<TestFunction<TestFunction<E>>> paretoOptimalFront = new Population<TestFunction<TestFunction<E>>>();
        int i = 0;
        while (i < num) {
            paretoOptimalFront.add(new TestFunction<E>());
            ++i;
        }
        i = 0;
        while (i < num) {
            TestFunction p = (TestFunction)paretoOptimalFront.get(i);
            switch (kindOfTestFunction) {
                case ZDT1: 
                case ZDT2: 
                case ZDT3: 
                case ZDT4: {
                    p.x[0] = xL[0] + (double)i * ((xU[0] - xL[0]) / (double)(num - 1));
                    int j = 1;
                    while (j < M) {
                        p.x[j] = 0.0;
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        paretoOptimalFront.keepNonDominated();
        return paretoOptimalFront;
    }

    public double calculateGenerationalDistance(Population<E> pop, Population<TestFunction<E>> pof) {
        double res = 0.0;
        for (Individual p1 : pop) {
            double minDistance = Double.MAX_VALUE;
            double curDistance = 0.0;
            ObjectiveVector objs1 = p1.getObjectiveVector();
            for (TestFunction testFunction : pof) {
                ObjectiveVector objs2 = testFunction.getObjectiveVector();
                curDistance = 0.0;
                int i = 0;
                while (i < Entity.N) {
                    curDistance += ((Double)objs1.get(i) - (Double)objs2.get(i)) * ((Double)objs1.get(i) - (Double)objs2.get(i));
                    ++i;
                }
                if (!((curDistance = Math.sqrt(curDistance)) < minDistance)) continue;
                minDistance = curDistance;
            }
            res += Math.pow(minDistance, Entity.N);
        }
        res = Math.pow(res, 1.0 / (double)Entity.N);
        return res /= (double)pop.size();
    }

    public double calculateDiversity(Population<E> pop, Population<TestFunction<E>> pof) {
        double res = 0.0;
        double dem = 0.0;
        int i = 0;
        while (i < N) {
            Collections.sort(pop, ComparatorObjective.getInstance(i));
            Collections.sort(pof, ComparatorObjective.getInstance(i));
            dem += Math.abs((Double)((Individual)pop.get(pop.size() - 1)).getObjectiveVector().get(i) - (Double)((TestFunction)pof.get(pof.size() - 1)).getObjectiveVector().get(i));
            ++i;
        }
        double[] di = new double[pop.size()];
        int i2 = 0;
        while (i2 < pop.size()) {
            Individual pI = (Individual)pop.get(i2);
            ObjectiveVector objI = pI.getObjectiveVector();
            double minDistance = Double.MAX_VALUE;
            double curDistance = 0.0;
            int j = 0;
            while (j < pop.size()) {
                if (i2 != j) {
                    Individual pJ = (Individual)pop.get(j);
                    ObjectiveVector objJ = pJ.getObjectiveVector();
                    curDistance = 0.0;
                    int k = 0;
                    while (k < N) {
                        curDistance += Math.abs((Double)objI.get(k) - (Double)objJ.get(k));
                        ++k;
                    }
                    if (curDistance < minDistance) {
                        minDistance = curDistance;
                    }
                }
                ++j;
            }
            di[i2] = minDistance;
            ++i2;
        }
        double avgD = 0.0;
        int i3 = 0;
        while (i3 < pop.size()) {
            avgD += di[i3];
            ++i3;
        }
        avgD /= (double)pop.size();
        double sumD = 0.0;
        int i4 = 0;
        while (i4 < pop.size()) {
            sumD += Math.abs(di[i4] - avgD);
            ++i4;
        }
        res = (dem + sumD) / (dem + (double)pop.size() * avgD);
        return res;
    }

    public void savePopInFile(Population<E> pop, String filePath) throws Exception {
        BufferedWriter logger = new BufferedWriter(new FileWriter(new File(filePath)));
        for (Individual p : pop) {
            ObjectiveVector objs = p.getObjectiveVector();
            int k = 0;
            while (k < N) {
                logger.write(objs.get(k) + " ");
                ++k;
            }
            logger.write("\n");
        }
        logger.flush();
        logger.close();
    }

    public static enum KindOfTestFunction {
        ZDT1,
        ZDT2,
        ZDT3,
        ZDT4,
        ZDT6,
        DTLZ2,
        DTLZ5,
        DTLZ7;

    }
}

