/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.algorithms;

import moea.commons.Population;
import moea.commons.assigner.AssignerNsga2;
import moea.commons.comparator.ComparatorNsga2;
import moea.moga.algorithms.Moea;
import moea.moga.genome.Chromosome;
import moea.moga.selector.BinarySelector;

public class Nsga2
extends Moea {
    protected AssignerNsga2<Chromosome> assigner;

    public Nsga2(String name, Population<Chromosome> popIni, int maxGenerations, double probabilityOfCrossover, double probabilityOfMutation) {
        super(name, popIni, maxGenerations, probabilityOfCrossover, probabilityOfMutation);
        this.selector = new BinarySelector(ComparatorNsga2.getInstance());
        this.assigner = new AssignerNsga2();
    }

    @Override
    public synchronized void step() {
        if (this.currentGeneration == 0) {
            this.assigner.fastNonDominatedSort(this.pop);
            ++this.currentGeneration;
            return;
        }
        Population<Chromosome> childPop = this.generate(this.pop);
        Population<Chromosome> mixedPop = new Population<Chromosome>();
        mixedPop.add(this.pop);
        mixedPop.add(childPop);
        if (this.externalIndividuals.size() > 0) {
            for (Chromosome externalInd : this.externalIndividuals) {
                mixedPop.add(externalInd);
            }
        }
        this.pop = this.assigner.reduce(mixedPop, this.popSizeMax);
        ++this.currentGeneration;
    }
}

