/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.genome;

import moea.moga.genome.Chromosome;

public abstract class ChromosomeWithMapping
extends Chromosome {
    protected int[] mapping = new int[M];
    protected static MappingMethod mappingMethod;

    @Override
    public abstract ChromosomeWithMapping clone();

    public ChromosomeWithMapping() {
        int i = 0;
        while (i < M) {
            this.mapping[i] = (int)((double)M * Math.random());
            ++i;
        }
    }

    public ChromosomeWithMapping(ChromosomeWithMapping src) {
        super(src);
        int i = 0;
        while (i < M) {
            this.mapping[i] = src.mapping[i];
            ++i;
        }
    }

    @Override
    public boolean crossover(double probabilityOfCrossover, Chromosome dad, Chromosome sister, Chromosome brother) {
        boolean cross = super.crossover(probabilityOfCrossover, dad, sister, brother);
        if (mappingMethod == MappingMethod.NONE) {
            return cross;
        }
        ChromosomeWithMapping dadWithMapping = (ChromosomeWithMapping)dad;
        ChromosomeWithMapping sisterWithMapping = (ChromosomeWithMapping)sister;
        ChromosomeWithMapping brotherWithMapping = (ChromosomeWithMapping)brother;
        if (cross) {
            int pos;
            int j = pos = 1 + (int)((double)(M - 1) * Math.random());
            while (j < M) {
                sisterWithMapping.mapping[j] = dadWithMapping.mapping[j];
                ++j;
            }
            j = pos;
            while (j < M) {
                brotherWithMapping.mapping[j] = this.mapping[j];
                ++j;
            }
            sister.invalidateScores();
            brother.invalidateScores();
            return true;
        }
        return false;
    }

    @Override
    public void mutate(double probabilityOfMutation) {
        int j;
        int temp;
        int posMax;
        int posMin;
        int pos2;
        super.mutate(probabilityOfMutation);
        if (mappingMethod == MappingMethod.NONE) {
            this.invalidateScores();
            return;
        }
        int i = 0;
        while (i < M) {
            if (Math.random() < 0.2 * probabilityOfMutation) {
                this.mapping[i] = (int)(Math.random() * (double)M);
            }
            if (mappingMethod == MappingMethod.EMMRS && Math.random() < probabilityOfMutation) {
                pos2 = (int)(Math.random() * (double)M);
                posMin = Math.min(i, pos2);
                posMax = Math.max(i, pos2);
                temp = this.mapping[posMin];
                j = posMax;
                while (j > posMin + 1) {
                    this.mapping[j] = this.mapping[j - 1];
                    --j;
                }
                if (posMin + 1 < M) {
                    this.mapping[posMin + 1] = temp;
                }
            }
            ++i;
        }
        if (mappingMethod == MappingMethod.EMM && Math.random() < probabilityOfMutation) {
            int pos1 = (int)(Math.random() * (double)this.mapping.length);
            pos2 = (int)(Math.random() * (double)this.mapping.length);
            posMin = Math.min(pos1, pos2);
            posMax = Math.max(pos1, pos2);
            temp = this.mapping[posMin];
            j = posMax;
            while (j > posMin + 1) {
                this.mapping[j] = this.mapping[j - 1];
                --j;
            }
            if (posMin + 1 < this.mapping.length) {
                this.mapping[posMin + 1] = temp;
            }
        }
        this.invalidateScores();
    }

    protected static enum MappingMethod {
        NONE,
        EMM,
        EMMRS;

    }
}

