/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.selector;

import java.util.Comparator;
import moea.commons.Entity;
import moea.commons.Population;
import moea.moga.genome.Chromosome;
import moea.moga.selector.Selector;

public class TournamentSelector
extends Selector {
    protected int[] tournament;
    protected int tournamentSize;

    public TournamentSelector(Comparator<Entity> comparator, int tournamentSize) {
        super(comparator);
        this.tournamentSize = tournamentSize;
        this.tournament = new int[tournamentSize];
    }

    @Override
    public void update(Population<Chromosome> pop) {
        super.initialize(pop);
        int i = 0;
        while (i < this.poolSize) {
            this.generateTournament(pop, this.tournamentSize);
            Chromosome winner = (Chromosome)pop.get(this.tournament[0]);
            int j = 1;
            while (j < this.tournamentSize) {
                Chromosome currentIndividual = (Chromosome)pop.get(this.tournament[j]);
                if (this.comparator.compare(currentIndividual, winner) == -1) {
                    winner = currentIndividual;
                }
                ++j;
            }
            this.pool[i] = winner;
            ++i;
        }
        this.currentIndex = 0;
    }

    protected void generateTournament(Population<Chromosome> pop, int size) {
        int maxIndex = pop.size() - 1;
        int j = 0;
        while (j < size) {
            int currentRandomIndex = (int)((double)(maxIndex + 1) * Math.random());
            boolean isNewIndex = true;
            if (j <= maxIndex) {
                int i = 0;
                while (isNewIndex && i < j) {
                    isNewIndex = currentRandomIndex != this.tournament[i];
                    ++i;
                }
            }
            if (!isNewIndex) continue;
            this.tournament[j++] = currentRandomIndex;
        }
    }
}

