/*
 * Decompiled with CFR 0.152.
 */
package moea.mopso.algorithms;

import java.util.Collections;
import moea.commons.Population;
import moea.commons.comparator.ComparatorPareto;
import moea.mopso.society.Particle;

public class MOPSO {
    protected String name;
    protected int t;
    protected int maxT;
    protected int popSizeMax;
    protected Population<Particle> pop;

    public MOPSO(String name, Population<Particle> popIni, int maxT) {
        this.name = name;
        this.t = 0;
        this.maxT = maxT;
        this.popSizeMax = popIni.size();
        this.pop = popIni;
        for (Particle pIter : this.pop) {
            pIter.updatePBest();
        }
        Collections.sort(this.pop, ComparatorPareto.getInstance());
        Particle gBest = ((Particle)this.pop.get(0)).clone();
        for (Particle pIter : this.pop) {
            pIter.updateGBest(gBest);
        }
    }

    public void step() {
        for (Particle p : this.pop) {
            p.updatePosition();
            p.updateVelocity();
            p.applyConstraints();
            p.updatePBest();
        }
        Collections.sort(this.pop, ComparatorPareto.getInstance());
        Particle gBest = ((Particle)this.pop.get(0)).clone();
        for (Particle p : this.pop) {
            p.updateGBest(gBest);
        }
        ++this.t;
    }

    public boolean done() {
        return this.t >= this.maxT;
    }

    public void setT(int t) {
        this.t = t;
    }

    public int getT() {
        return this.t;
    }

    public Population<Particle> getPopulation() {
        return this.pop;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxT() {
        return this.maxT;
    }

    public void setMaxT(int maxT) {
        this.maxT = maxT;
    }
}

