/*
 * Decompiled with CFR 0.152.
 */
package moea.mopso.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import moea.commons.Entity;
import moea.commons.Population;
import moea.commons.comparator.ComparatorNsga2;
import moea.commons.comparator.ComparatorObjective;
import moea.commons.comparator.ComparatorPareto;
import moea.mopso.algorithms.MOPSO;
import moea.mopso.society.Particle;

public class NSPSO
extends MOPSO {
    public NSPSO(String name, Population<Particle> popIni, int maxT) {
        super(name, popIni, maxT);
        this.fastNonDominatedSort(this.pop);
        this.crowdingDistanceAssignment(this.pop);
        Collections.sort(this.pop, ComparatorNsga2.getInstance());
    }

    public void assignParameters(Particle p) {
        double c2;
        double c1;
        double w;
        double cd = p.getProperty("crowdingDistance").doubleValue();
        if (cd == Double.MAX_VALUE) {
            w = 1.0 / cd;
            c1 = 0.0;
            c2 = 0.0;
        } else {
            w = (1.0 + cd) / (1.0 + Math.pow(1.0 + cd, 2.0));
            c1 = 1.0 + w;
            c2 = 1.0 + w;
        }
        p.setW(w);
        p.setC1(c1);
        p.setC2(c2);
    }

    @Override
    public void step() {
        Population<Particle> childPop = new Population<Particle>();
        for (Particle pTemp : this.pop) {
            childPop.add(pTemp.clone());
        }
        Particle p = null;
        int i = 0;
        while (i < childPop.size()) {
            p = (Particle)childPop.get(i);
            this.assignParameters(p);
            p.updatePosition();
            p.updateVelocity();
            p.applyConstraints();
            p.updatePBest();
            p.updateGBest((Particle)this.pop.get((int)(Math.random() * (double)Entity.getN())));
            ++i;
        }
        Population<Particle> mixedPop = new Population<Particle>();
        mixedPop.add(this.pop);
        mixedPop.add(childPop);
        this.pop = this.reduce(mixedPop, this.popSizeMax);
        ++this.t;
    }

    public ArrayList<Population<Particle>> fastNonDominatedSort(Population<Particle> pop) {
        Particle qInd;
        int q;
        Population setS;
        Particle pInd;
        ArrayList<Population<Particle>> setsF = new ArrayList<Population<Particle>>();
        ArrayList<Population> setsS = new ArrayList<Population>();
        int i = 0;
        while (i < pop.size()) {
            ((Particle)pop.get(i)).setProperty("n", 0);
            ((Particle)pop.get(i)).setProperty("rank", Integer.MAX_VALUE);
            ((Particle)pop.get(i)).setProperty("crowdingDistance", 0.0);
            ++i;
        }
        Population<Particle> setF = new Population<Particle>();
        int p = 0;
        while (p < pop.size()) {
            pInd = (Particle)pop.get(p);
            setS = new Population();
            q = 0;
            while (q < pop.size()) {
                qInd = (Particle)pop.get(q);
                int compare = pInd.compareTo(qInd, ComparatorPareto.getInstance());
                if (compare == -1) {
                    setS.add(qInd);
                } else if (compare == 1) {
                    pInd.setProperty("n", pInd.getProperty("n").intValue() + 1);
                }
                ++q;
            }
            if (pInd.getProperty("n").intValue() == 0) {
                setF.add(pInd);
            }
            pInd.setProperty("indexS", p);
            setsS.add(setS);
            ++p;
        }
        int rank = 1;
        while (setF.size() > 0) {
            Population<Particle> setH = new Population<Particle>();
            p = 0;
            while (p < setF.size()) {
                pInd = (Particle)setF.get(p);
                pInd.setProperty("rank", rank);
                setS = (Population)setsS.get(pInd.getProperty("indexS").intValue());
                q = 0;
                while (q < setS.size()) {
                    qInd = (Particle)setS.get(q);
                    qInd.setProperty("n", qInd.getProperty("n").intValue() - 1);
                    if (qInd.getProperty("n").intValue() == 0) {
                        setH.add(qInd);
                    }
                    ++q;
                }
                ++p;
            }
            setsF.add(setF);
            setF = setH;
            ++rank;
        }
        return setsF;
    }

    public void crowdingDistanceAssignment(Population<Particle> pop) {
        int l = pop.size();
        int i = 0;
        while (i < l) {
            ((Particle)pop.get(i)).setProperty("crowdingDistance", 0);
            ++i;
        }
        int m = 0;
        while (m < ((Particle)pop.get(0)).getObjectiveVector().size()) {
            Collections.sort(pop, ComparatorObjective.getInstance(m));
            ((Particle)pop.get(0)).setProperty("crowdingDistance", Double.MAX_VALUE);
            ((Particle)pop.get(l - 1)).setProperty("crowdingDistance", Double.MAX_VALUE);
            i = 1;
            while (i < l - 1) {
                double temp = ((Particle)pop.get(i)).getProperty("crowdingDistance").doubleValue();
                temp += ((Double)((Particle)pop.get(i + 1)).getObjectiveVector().get(m)).doubleValue();
                ((Particle)pop.get(i)).setProperty("crowdingDistance", temp -= ((Double)((Particle)pop.get(i - 1)).getObjectiveVector().get(m)).doubleValue());
                ++i;
            }
            ++m;
        }
    }

    public Population<Particle> reduce(Population<Particle> pop, int maxSize) {
        int i = 0;
        Population<Particle> reducedPop = new Population<Particle>();
        ArrayList<Population<Particle>> setsF = this.fastNonDominatedSort(pop);
        while (reducedPop.size() < maxSize && i < setsF.size()) {
            Population<Particle> setF = setsF.get(i);
            this.crowdingDistanceAssignment(setF);
            reducedPop.add(setF);
            ++i;
        }
        if (reducedPop.size() > maxSize) {
            Collections.sort(reducedPop, ComparatorNsga2.getInstance());
            while (reducedPop.size() > maxSize) {
                reducedPop.remove(reducedPop.size() - 1);
            }
        }
        return reducedPop;
    }
}

