/*
 * Decompiled with CFR 0.152.
 */
package moea.mopso.examples;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import moea.commons.ObjectiveVector;
import moea.commons.Population;
import moea.commons.examples.TestFunction;
import moea.mopso.algorithms.HNSPSO;
import moea.mopso.algorithms.MOPSO;
import moea.mopso.society.Particle;

public class TestMopso
extends Particle {
    public static String outDir = null;
    public static TestFunction<Particle> testFunction = null;

    public static void initializeProblem(String[] args) {
        testFunction = new TestFunction(args);
        outDir = "D:/jlrisco/Trabajo/MisPapers/IEEE T EVOLUT COMPUT/2007/Results";
    }

    public TestMopso() {
    }

    public TestMopso(TestMopso src) {
        super(src);
    }

    @Override
    public TestMopso clone() {
        TestMopso clone = new TestMopso(this);
        return clone;
    }

    @Override
    public void evaluate() {
        testFunction.evaluateFunction(this.x, this.objectiveVector);
    }

    public static void main(String[] args) throws Exception {
        String[] functions = new String[]{"ZDT1", "ZDT2", "ZDT3", "ZDT4", "DTLZ2", "DTLZ5", "DTLZ7"};
        String[] algorithms = new String[]{"HNSPSO", "NSPSO", "sMOPSO", "MOPSO", "PESAII", "NSGAII"};
        double[][] deltas = new double[6][7];
        deltas[0] = new double[]{0.332, 0.32, 0.608, 0.695, 0.532, 0.51, 0.706};
        deltas[1] = new double[]{0.904, 0.898, 0.634, 0.868, 0.731, 0.539, 0.743};
        deltas[2] = new double[]{0.368, 0.363, 0.741, 0.806, 0.649, 0.718, 0.895};
        deltas[3] = new double[]{0.681, 0.648, 0.839, 0.936, 0.771, 0.69, 0.879};
        deltas[4] = new double[]{0.852, 0.86, 0.995, 1.09, 0.769, 0.733, 0.89};
        deltas[5] = new double[]{0.552, 0.587, 0.726, 0.855, 0.951, 0.852, 0.983};
        double[][] gds = new double[6][7];
        gds[0] = new double[]{9.63E-4, 8.04E-4, 0.0034, 0.972, 0.00713, 0.0041, 0.038};
        gds[1] = new double[]{0.00634, 0.00945, 0.0048, 4.82, 0.0489, 0.00325, 0.0515};
        gds[2] = new double[]{0.0153, 0.00593, 0.122, 3.36, 0.0356, 0.00343, 0.291};
        gds[3] = new double[]{0.00105, 8.48E-4, 0.00394, 7.03, 0.721, 0.00592, 0.0574};
        gds[4] = new double[]{0.00111, 7.43E-4, 0.00753, 9.42, 0.0331, 0.00641, 0.0558};
        gds[5] = new double[]{0.00414, 0.00425, 0.00912, 2.92, 0.718, 0.00509, 0.049};
        double delta = 0.0;
        double gd = 0.0;
        int nd = 0;
        int t = 0;
        int maxT = 0;
        boolean nextAlgorithm = false;
        int i = 4;
        while (i < 5) {
            int j = 0;
            while (j < 1) {
                nextAlgorithm = false;
                args = new String[]{functions[i], "250", "100"};
                Integer maxGenerations = Integer.valueOf(args[1]);
                TestMopso.initializeProblem(args);
                Population pof = null;
                if (functions[i].equals("DTLZ2") || functions[i].equals("DTLZ5") || functions[i].equals("DTLZ7")) {
                    pof = testFunction.loadParetoOptimalFront(String.valueOf(outDir) + File.separator + args[0] + ".POF");
                } else {
                    pof = testFunction.generateParetoOptimalFront(1000);
                    TestMopso.saveToFile2(pof, String.valueOf(outDir) + File.separator + args[0] + ".POF");
                }
                Population<Particle> popIni = new Population<Particle>();
                int k = 0;
                while (k < Integer.valueOf(args[2])) {
                    TestMopso particle = new TestMopso();
                    popIni.add(particle);
                    ++k;
                }
                HNSPSO algorithm = new HNSPSO("HNSPSO", popIni, maxGenerations);
                Population<Particle> runPop = new Population<Particle>();
                while (!nextAlgorithm) {
                    t = algorithm.getT();
                    maxT = algorithm.getMaxT();
                    runPop.clear();
                    runPop.add(algorithm.getPopulation());
                    runPop.keepNonDominated();
                    nd = runPop.size();
                    if (nd == 100) {
                        if (t == maxT) {
                            algorithm.setMaxT(maxT + 10);
                        }
                        delta = testFunction.calculateDiversity(runPop, pof);
                        gd = testFunction.calculateGenerationalDistance(runPop, pof);
                        if (i < 4 && algorithm.getT() % 500 == 0 || i > 3 && algorithm.getT() % 5 == 0) {
                            System.out.println("CurrGen=" + algorithm.getT() + ", Delta=" + delta + ", GD=" + gd + ", ND=" + nd);
                        }
                        if (delta <= deltas[j][i] && gd <= gds[j][i] && nd == 100) {
                            TestMopso.saveToFile(runPop, String.valueOf(outDir) + File.separator + functions[i] + "." + algorithms[j]);
                            System.out.println("Function=" + functions[i] + ", Alg=" + algorithms[j] + ", CurrGen=" + algorithm.getT() + ", Delta=" + delta + ", GD=" + gd + ", ND=" + nd);
                            nextAlgorithm = true;
                            continue;
                        }
                        ((MOPSO)algorithm).step();
                        continue;
                    }
                    ((MOPSO)algorithm).step();
                }
                ++j;
            }
            ++i;
        }
    }

    public static double calculateMean(ArrayList<ObjectiveVector> setObj, int iObj, int max) {
        double res = 0.0;
        int i = 0;
        while (i < max) {
            res += ((Double)setObj.get(i).get(iObj)).doubleValue();
            ++i;
        }
        return res /= (double)max;
    }

    public static double calculateStd2(ArrayList<ObjectiveVector> setObj, Double avg, int iObj, int max) {
        double res = 0.0;
        int i = 0;
        while (i < max) {
            res += Math.pow((Double)setObj.get(i).get(iObj) - avg, 2.0);
            ++i;
        }
        return res /= (double)max;
    }

    public static void saveToFile(Population<Particle> pop, String outDir) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outDir)));
        for (Particle p : pop) {
            ObjectiveVector objs = p.getObjectiveVector();
            int i = 0;
            while (i < objs.size()) {
                if (i != 0) {
                    writer.write("\t");
                }
                writer.write("" + objs.get(i));
                ++i;
            }
            writer.write("\n");
        }
        writer.flush();
        writer.close();
    }

    public static void saveToFile2(Population<TestFunction<Particle>> pop, String outDir) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outDir)));
        for (TestFunction testFunction : pop) {
            ObjectiveVector objs = testFunction.getObjectiveVector();
            int i = 0;
            while (i < objs.size()) {
                if (i != 0) {
                    writer.write("\t");
                }
                writer.write("" + objs.get(i));
                ++i;
            }
            writer.write("\n");
        }
        writer.flush();
        writer.close();
    }
}

