/*
 * Decompiled with CFR 0.152.
 */
package simView;

import GenCol.Pair;
import GenCol.entity;
import genDevs.modeling.ContentInterface;
import genDevs.modeling.atomic;
import genDevs.modeling.content;
import genDevs.modeling.devs;
import genDevs.modeling.digraph;
import genDevs.simulation.coupledSimulator;
import genDevs.simulation.realTime.TunableCoordinator;
import genDevs.simulation.realTime.TunableCoupledCoordinator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Keymap;
import simView.AtomicView;
import simView.ComponentView;
import simView.ContentView;
import simView.DigraphView;
import simView.DragViewListener;
import simView.SimViewCoordinator;
import simView.ViewableAtomic;
import simView.ViewableAtomicSimulator;
import simView.ViewableComponent;
import simView.ViewableDigraph;
import util.ComponentUtil;
import util.FileUtil;
import util.PointUtil;
import util.Util;
import util.WindowUtil;

public class SimView {
    protected JLabel statusLabel;
    protected final String settingsFileName = "SimView_settings";
    protected boolean alwaysShowCouplings = false;
    protected final int modelBorderWidth = 5;
    protected String wrapperDigraphName = "wrapper digraph";
    protected JFrame mainFrame;
    protected List modelPackages;
    protected ConfigureDialog configureDialog;
    protected HelpDialog helpDialog;
    protected ViewableDigraph model;
    protected ModelView modelView;
    protected JScrollPane modelViewScrollPane;
    protected JLabel clockLabel;
    protected DecimalFormat decimalFormat = new DecimalFormat("0.000");
    protected TunableCoordinator coordinator;
    protected double[] realTimeFactors = new double[]{1.0E-4, 0.001, 0.01, 0.1, 0.5, 1.0, 5.0, 10.0, 100.0, 1000.0, 10000.0};
    protected RealTimeFactor realTimeFactor = new RealTimeFactor();
    protected JLabel realTimeFactorLabel;
    protected JSlider realTimeFactorSlider;
    protected JComboBox packagesBox;
    protected JComboBox modelsBox;
    protected Clock clock = new Clock();
    protected String modelsPath;
    protected String sourcePath;
    protected String modelsPackage;
    protected String lastModelViewed;

    public SimView() {
        this.loadSettings();
        this.constructUI();
        if (this.modelsPackage != null) {
            this.packagesBox.setSelectedItem(this.modelsPackage);
        }
        if (this.lastModelViewed != null) {
            this.modelsBox.setSelectedItem(this.lastModelViewed);
        }
        this.mainFrame.setVisible(true);
    }

    protected void constructUI() {
        final JFrame frame = this.mainFrame = new JFrame("DEVSJAVA Simulation Viewer");
        frame.setDefaultCloseOperation(3);
        frame.setSize(580, 400);
        Container pane = frame.getContentPane();
        pane.setBackground(Color.white);
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add(main);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    SimView.this.saveModelLayout();
                    SimView.this.saveSettings();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 0));
        main.add(panel);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        JButton button = new JButton("configure");
        button.setFont(new Font("SansSerif", 0, 10));
        panel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimView.this.configureDialog == null) {
                    SimView.this.configureDialog = new ConfigureDialog(frame);
                }
                SimView.this.configureDialog.setVisible(true);
            }
        });
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        JComboBox combo = this.packagesBox = new JComboBox();
        this.populatePackagesBox(combo);
        panel.add(combo);
        combo.setMaximumSize(new Dimension(combo.getMaximumSize().width, combo.getMinimumSize().height));
        this.packagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimView.this.packagesBox.getSelectedIndex() <= 0) {
                    return;
                }
                SimView.this.modelsPackage = (String)SimView.this.packagesBox.getSelectedItem();
                SimView.this.populateModelsBox(SimView.this.modelsBox);
            }
        });
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        this.modelsBox = new JComboBox();
        combo = this.modelsBox;
        panel.add(combo);
        combo.setMaximumSize(new Dimension(combo.getMaximumSize().width, combo.getMinimumSize().height));
        this.modelsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimView.this.modelsBox.getSelectedIndex() <= 0) {
                    return;
                }
                SimView.this.useModelClass((String)SimView.this.modelsBox.getSelectedItem());
            }
        });
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        main.add(Box.createRigidArea(new Dimension(0, 5)));
        this.modelView = new ModelView();
        JScrollPane scrollPane = this.modelViewScrollPane = new JScrollPane(this.modelView);
        main.add(scrollPane);
        panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 0));
        main.add(panel);
        JLabel label = this.statusLabel = new JLabel("", 0);
        panel.add(label);
        this.setStatusLabelToReady();
        Dimension size = new Dimension(label.getFontMetrics(label.getFont()).stringWidth("stepping") + 10, label.getMinimumSize().height);
        label.setMinimumSize(size);
        label.setMaximumSize(size);
        label.setPreferredSize(size);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        Color labelColor = new Color(102, 102, 153);
        label = new JLabel("clock: ");
        label.setForeground(labelColor);
        panel.add(label);
        label = this.clockLabel = new JLabel();
        label.setFont(new Font("SansSerif", 0, 16));
        label.setForeground(labelColor);
        panel.add(label);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        label = new JLabel("real time factor: ");
        label.setForeground(labelColor);
        panel.add(label);
        JPanel panel3 = new JPanel();
        panel3.setOpaque(false);
        panel3.setLayout(new BoxLayout(panel3, 1));
        panel.add(panel3);
        label = this.realTimeFactorLabel = new JLabel();
        label.setFont(new Font("SansSerif", 0, 13));
        label.setForeground(labelColor);
        label.setAlignmentX(0.5f);
        panel3.add(label);
        this.realTimeFactor.set(this.realTimeFactor.get());
        JSlider slider = this.realTimeFactorSlider = new JSlider();
        slider.setMaximumSize(new Dimension(100, 20));
        slider.setAlignmentX(0.5f);
        slider.setMinimum(0);
        slider.setMaximum(this.realTimeFactors.length - 1);
        panel3.add(slider);
        int i = 0;
        while (i < this.realTimeFactors.length) {
            if (this.realTimeFactors[i] == this.realTimeFactor.get()) {
                slider.setValue(i);
                break;
            }
            ++i;
        }
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider1 = SimView.this.realTimeFactorSlider;
                SimView.this.realTimeFactor.set(SimView.this.realTimeFactors[slider1.getValue()]);
                if (!slider1.getValueIsAdjusting() && SimView.this.coordinator != null) {
                    SimView.this.coordinator.interrupt();
                }
            }
        });
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        JCheckBox checkBox = new JCheckBox("always show couplings", this.alwaysShowCouplings);
        checkBox.setFont(new Font("SansSerif", 0, 10));
        panel.add(checkBox);
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SimView.this.alwaysShowCouplings = e.getStateChange() == 1;
                SimView.this.modelView.repaint();
            }
        });
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        button = new JButton("help");
        button.setFont(new Font("SansSerif", 0, 10));
        panel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimView.this.helpDialog == null) {
                    SimView.this.helpDialog = new HelpDialog(frame);
                }
                SimView.this.helpDialog.setVisible(true);
            }
        });
        main.add(Box.createRigidArea(new Dimension(0, 5)));
        panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 0));
        main.add(panel);
        button = new JButton("step");
        button.setAlignmentX(0.5f);
        panel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimView.this.coordinator == null) {
                    return;
                }
                SimView.this.modelView.stepToBeTaken();
                SimView.this.setStatusLabelToStepping();
                SimView.this.coordinator.simulate(1);
                SimView.this.clock.set(SimView.this.coordinator.getTimeOfLastEvent());
            }
        });
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        final JToggleButton runButton = new JToggleButton("run");
        runButton.setAlignmentX(0.5f);
        panel.add(runButton);
        runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimView.this.coordinator == null) {
                    return;
                }
                if (runButton.isSelected()) {
                    SimView.this.modelView.runToOccur();
                    SimView.this.setStatusLabelToRunning();
                    SimView.this.coordinator.simulate(Integer.MAX_VALUE);
                } else {
                    SimView.this.coordinator.simulate(0);
                    SimView.this.setStatusLabelToReady();
                }
            }
        });
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        button = new JButton("restart");
        button.setAlignmentX(0.5f);
        panel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimView.this.coordinator == null) {
                    return;
                }
                SimView.this.modelView.simulationRestarted();
                SimView.this.coordinator.initialize();
                SimView.this.clock.set(0.0);
            }
        });
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        ToolTipManager manager = ToolTipManager.sharedInstance();
        manager.setInitialDelay(0);
        manager.setReshowDelay(0);
    }

    public static void main(String[] args) {
        new SimView();
    }

    protected void createViews(ViewableDigraph model, JComponent parent) {
        model.createView(this.modelView);
        if (!model.isBlackBox()) {
            try {
                if (!model.layoutForSimViewOverride()) {
                    model.layoutForSimView();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DigraphView view = model.getDigraphView();
        this.modelView.addView(view, parent);
        if (parent == this.modelView) {
            view.setLocation(new Point(5, 5));
        }
        for (Object component : model.getComponents()) {
            if ((model.isBlackBox() || model.isHidden()) && component instanceof ViewableComponent) {
                ViewableComponent comp = (ViewableComponent)component;
                comp.setHidden(true);
            }
            if (component instanceof ViewableAtomic) {
                ViewableAtomic atomic2 = (ViewableAtomic)component;
                atomic2.createView(this.modelView);
                AtomicView view1 = atomic2.getAtomicView();
                this.modelView.addView(view1, view);
                if (model.getName().equals(this.wrapperDigraphName)) {
                    view1.setLocation(this.modelViewScrollPane.getWidth() / 2 - view.getWidth() / 2, this.modelViewScrollPane.getHeight() / 2 - view.getHeight() / 2);
                }
            }
            if (!(component instanceof ViewableDigraph)) continue;
            ViewableDigraph digraph2 = (ViewableDigraph)component;
            this.createViews(digraph2, view);
        }
    }

    protected void populateModelsBox(JComboBox box) {
        String extension = ".class";
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".class") && name.indexOf(36) == -1;
            }
        };
        File path = new File(String.valueOf(this.modelsPath) + "/" + this.modelsPackage.replace('.', '/'));
        File[] files = path.listFiles(filter);
        if (files == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "The selected models package does not appear to be available for loading.  Please select another.");
            return;
        }
        TreeSet sortedFiles = new TreeSet(Arrays.asList(files));
        box.removeAllItems();
        box.addItem("Select a model");
        Iterator i = sortedFiles.iterator();
        while (i.hasNext()) {
            String name = ((File)i.next()).getName();
            box.addItem(name.substring(0, name.length() - ".class".length()));
        }
    }

    protected void useModelClass(String name) {
        Object instance;
        if (this.model != null) {
            this.coordinator.simulate(0);
            Frame[] frames = Frame.getFrames();
            int i = 0;
            while (i < frames.length) {
                if (frames[i] != this.mainFrame) {
                    frames[i].setVisible(true);
                    frames[i].dispose();
                }
                ++i;
            }
            this.saveModelLayout();
        }
        try {
            Class<?> modelClass = Class.forName(String.valueOf(this.modelsPackage) + "." + name);
            instance = modelClass.newInstance();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainFrame, "That does not appear to be a valid model class.  Please select another.");
            e.printStackTrace();
            return;
        }
        if (instance instanceof ViewableAtomic) {
            this.model = new ViewableDigraph(this.wrapperDigraphName);
            this.model.add((atomic)instance);
            ViewableAtomic atomic2 = (ViewableAtomic)instance;
            List names = atomic2.getOutportNames();
            int i = 0;
            while (i < names.size()) {
                String portName = (String)names.get(i);
                this.model.addOutport(portName);
                this.model.addCoupling(atomic2, portName, this.model, portName);
                ++i;
            }
        } else if (instance instanceof ViewableDigraph) {
            this.model = (ViewableDigraph)instance;
        } else {
            JOptionPane.showMessageDialog(this.mainFrame, "That does not appear to be a viewable model class.  Please select another.");
            return;
        }
        this.modelView.removeAllViews();
        this.coordinator = new SimViewCoordinator(this.model, this.modelView);
        this.coordinator.initialize();
        this.coordinator.setTimeScale(this.realTimeFactor.get());
        this.createViews(this.model, this.modelView);
        this.modelView.clearCouplings();
        this.detmCouplings(this.model);
        ((JComponent)this.modelViewScrollPane.getParent()).revalidate();
        if (instance instanceof ViewableAtomic) {
            AtomicView view = ((ViewableAtomic)instance).getAtomicView();
            Dimension viewSize = view.getPreferredSize();
            Dimension wrapperSize = this.model.getPreferredSize();
            view.setLocation(wrapperSize.width / 2 - viewSize.width / 2, wrapperSize.height / 2 - viewSize.height / 2);
        }
        this.clock.set(0.0);
        this.lastModelViewed = name;
    }

    protected void populatePackagesBox(JComboBox box) {
        box.removeAllItems();
        box.addItem("Select a package");
        if (this.modelPackages != null) {
            int i = 0;
            while (i < this.modelPackages.size()) {
                box.addItem((String)this.modelPackages.get(i));
                ++i;
            }
        }
    }

    protected void loadSettings() {
        block4: {
            try {
                FileInputStream in = new FileInputStream("SimView_settings");
                ObjectInputStream s = new ObjectInputStream(in);
                this.modelsPath = (String)s.readObject();
                this.modelPackages = (List)s.readObject();
                this.alwaysShowCouplings = s.readBoolean();
                this.realTimeFactor.set(s.readDouble());
                this.modelsPackage = (String)s.readObject();
                this.lastModelViewed = (String)s.readObject();
                this.sourcePath = (String)s.readObject();
            }
            catch (Exception e) {
                System.out.println("Couldn't read settings from file.");
                if (this.modelsPath == null) {
                    this.modelsPath = ".";
                }
                if (this.sourcePath == null) {
                    this.sourcePath = ".";
                }
                if (this.modelPackages != null) break block4;
                this.modelPackages = new ArrayList();
            }
        }
    }

    protected void saveSettings() {
        try {
            FileOutputStream out = new FileOutputStream("SimView_settings");
            ObjectOutputStream s = new ObjectOutputStream(out);
            s.writeObject(this.modelsPath);
            s.writeObject(this.modelPackages);
            s.writeBoolean(this.alwaysShowCouplings);
            s.writeDouble(this.realTimeFactor.get());
            s.writeObject(this.modelsPackage);
            s.writeObject(this.lastModelViewed);
            s.writeObject(this.sourcePath);
            s.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void detmCouplings(ViewableDigraph model) {
        this.detmCouplings((ViewableComponent)model);
        for (Object component : model.getComponents()) {
            if (component instanceof ViewableDigraph) {
                ViewableDigraph digraph2 = (ViewableDigraph)component;
                this.detmCouplings(digraph2);
                continue;
            }
            if (!(component instanceof ViewableComponent)) continue;
            this.detmCouplings((ViewableComponent)component);
        }
    }

    protected void detmCouplings(ViewableComponent comp) {
        this.detmCouplings(comp, comp.getOutportNames());
        if (comp instanceof ViewableDigraph) {
            this.detmCouplings(comp, comp.getInportNames());
        }
    }

    protected void detmCouplings(ViewableComponent comp, List portNames) {
        int i = 0;
        while (i < portNames.size()) {
            String portName = (String)portNames.get(i);
            List couplings = null;
            if (comp instanceof ViewableAtomic) {
                couplings = ((coupledSimulator)((atomic)((Object)comp)).getSim()).getCouplingsToSourcePort(portName);
            } else if (comp instanceof ViewableDigraph) {
                couplings = ((digraph)((Object)comp)).getCoordinator().getCouplingsToSourcePort(portName);
            }
            int j = 0;
            while (j < couplings.size()) {
                Pair pair = (Pair)couplings.get(j);
                Coupling coupling = new Coupling();
                coupling.sourceView = comp.getView();
                coupling.sourcePortName = portName;
                entity destEntity = (entity)pair.getKey();
                String destPortName = (String)pair.getValue();
                if (!(destEntity instanceof ViewableComponent)) {
                    System.out.println("Coupling could not be displayed.\n\tFrom: " + comp.getName() + ", port " + portName + "\n\tTo: " + destEntity.getName() + ", port " + destPortName);
                } else {
                    coupling.destView = ((ViewableComponent)((Object)destEntity)).getView();
                    coupling.destPortName = destPortName;
                    this.modelView.addCoupling(coupling);
                }
                ++j;
            }
            ++i;
        }
    }

    public ModelView getModelView() {
        return this.modelView;
    }

    protected void setStatusLabelToStepping() {
        this.statusLabel.setForeground(Color.red.darker());
        this.statusLabel.setText("stepping");
    }

    protected void setStatusLabelToRunning() {
        this.statusLabel.setForeground(Color.blue.darker());
        this.statusLabel.setText("running");
    }

    protected void setStatusLabelToReady() {
        this.statusLabel.setForeground(Color.green.darker());
        this.statusLabel.setText("ready");
    }

    protected void saveModelLayout() {
        this.saveModelLayout(this.model);
    }

    protected void saveModelLayout(ViewableDigraph model) {
        if (model == null || model.isBlackBox() || model.isHidden()) {
            return;
        }
        if (!model.getLayoutChanged()) {
            this.saveLayoutsOfChildren(model);
            return;
        }
        String className = model.getClass().getName().replace('.', '/');
        File file = new File(String.valueOf(this.sourcePath) + "/" + className + ".java");
        String code = FileUtil.getContentsAsString(file);
        int index = code.indexOf("void layoutForSimView()");
        if (index != -1) {
            int startIndex = code.lastIndexOf("/**", index);
            startIndex = code.lastIndexOf("\n", startIndex);
            int endIndex = code.indexOf("}", index);
            endIndex = code.indexOf("\n", endIndex);
            code = String.valueOf(code.substring(0, startIndex)) + code.substring(endIndex, code.length());
        }
        index = code.lastIndexOf("}");
        index = code.lastIndexOf("\n", index);
        StringBuffer method = new StringBuffer("\n");
        method.append("    /**\n");
        method.append("     * Automatically generated by the SimView program.\n");
        method.append("     * Do not edit this manually, as such changes will get overwritten.\n");
        method.append("     */\n");
        method.append("    public void layoutForSimView()\n");
        method.append("    {\n");
        if (!model.isBlackBox()) {
            method.append("        preferredSize = new Dimension(");
            Dimension size = ((JComponent)((Object)model.getView())).getSize();
            method.append(size.width);
            method.append(", ");
            method.append(size.height);
            method.append(");\n");
        }
        for (Object next : model.getComponents()) {
            ViewableComponent component;
            if (!(next instanceof ViewableComponent) || (component = (ViewableComponent)next).isHidden()) continue;
            method.append("        ");
            method.append("((ViewableComponent)withName(" + component.getLayoutName());
            method.append(")).setPreferredLocation(new Point(");
            Point location = component.getPreferredLocation();
            method.append(location.x);
            method.append(", ");
            method.append(location.y);
            method.append("));\n");
        }
        method.append("    }\n");
        code = String.valueOf(code.substring(0, index)) + method + code.substring(index + 1, code.length());
        file = new File(file.getPath());
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(code, 0, code.length());
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        model.setLayoutChanged(false);
        this.saveLayoutsOfChildren(model);
    }

    protected void saveLayoutsOfChildren(ViewableDigraph model) {
        for (Object next : model.getComponents()) {
            ViewableComponent component;
            if (!(next instanceof ViewableComponent) || !((component = (ViewableComponent)next) instanceof ViewableDigraph)) continue;
            ViewableDigraph digraph2 = (ViewableDigraph)component;
            this.saveModelLayout(digraph2);
        }
    }

    protected class Clock {
        private double clock;

        protected Clock() {
        }

        public double get() {
            return this.clock;
        }

        public void set(double clock_) {
            this.clock = clock_;
            SimView.this.clockLabel.setText(SimView.this.decimalFormat.format(this.clock));
        }
    }

    protected class ConfigureDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public ConfigureDialog(Frame owner) {
            super(owner, "Configure", true);
            this.setSize(400, 300);
            WindowUtil.centerWindow(this);
            this.constructUI();
        }

        protected void constructUI() {
            JTextArea packagesArea;
            JTextField sourcePathField;
            JTextField classPathField;
            this.setDefaultCloseOperation(0);
            Container pane = this.getContentPane();
            JPanel main = new JPanel();
            main.setLayout(new BoxLayout(main, 1));
            main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            pane.add(main);
            JLabel label = new JLabel("Path to packages of model classes (from current folder)");
            label.setAlignmentX(0.0f);
            main.add(label);
            JTextField field = classPathField = new JTextField(SimView.this.modelsPath);
            field.setAlignmentX(0.0f);
            main.add(field);
            field.setMaximumSize(new Dimension(1000, (int)(1.5 * (double)this.getFontMetrics(field.getFont()).getHeight())));
            main.add(Box.createRigidArea(new Dimension(0, 10)));
            label = new JLabel("Path to packages of model source files (from current folder)");
            label.setAlignmentX(0.0f);
            main.add(label);
            field = sourcePathField = new JTextField(SimView.this.sourcePath);
            field.setAlignmentX(0.0f);
            main.add(field);
            field.setMaximumSize(new Dimension(1000, (int)(1.5 * (double)this.getFontMetrics(field.getFont()).getHeight())));
            main.add(Box.createRigidArea(new Dimension(0, 10)));
            label = new JLabel("Model package names (one per line)");
            label.setAlignmentX(0.0f);
            main.add(label);
            JTextArea area = packagesArea = new JTextArea(SimView.this.modelsPath);
            JScrollPane scrollPane = new JScrollPane(area);
            scrollPane.setAlignmentX(0.0f);
            main.add(scrollPane);
            String text = "";
            int i = 0;
            while (i < SimView.this.modelPackages.size()) {
                text = String.valueOf(text) + (String)SimView.this.modelPackages.get(i) + "\n";
                ++i;
            }
            area.setText(text);
            Keymap keymap = JTextArea.addKeymap(null, area.getKeymap());
            KeyStroke key = KeyStroke.getKeyStroke(155, 2);
            keymap.addActionForKeyStroke(key, new DefaultEditorKit.CopyAction());
            key = KeyStroke.getKeyStroke(155, 1);
            keymap.addActionForKeyStroke(key, new DefaultEditorKit.PasteAction());
            area.setKeymap(keymap);
            main.add(Box.createRigidArea(new Dimension(0, 10)));
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            panel.setLayout(new BoxLayout(panel, 0));
            panel.setAlignmentX(0.0f);
            main.add(panel);
            panel.add(Box.createHorizontalGlue());
            JButton button = new JButton("Ok");
            button.setAlignmentX(0.0f);
            panel.add(button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((ConfigureDialog)ConfigureDialog.this).SimView.this.modelsPath = classPathField.getText();
                    if (((ConfigureDialog)ConfigureDialog.this).SimView.this.modelsPath.equals("")) {
                        ((ConfigureDialog)ConfigureDialog.this).SimView.this.modelsPath = ".";
                    }
                    if (((ConfigureDialog)ConfigureDialog.this).SimView.this.modelsPath.endsWith("/")) {
                        ((ConfigureDialog)ConfigureDialog.this).SimView.this.modelsPath = ((ConfigureDialog)ConfigureDialog.this).SimView.this.modelsPath.substring(0, ((ConfigureDialog)ConfigureDialog.this).SimView.this.modelsPath.length() - 1);
                    }
                    ((ConfigureDialog)ConfigureDialog.this).SimView.this.sourcePath = sourcePathField.getText();
                    if (((ConfigureDialog)ConfigureDialog.this).SimView.this.sourcePath.equals("")) {
                        ((ConfigureDialog)ConfigureDialog.this).SimView.this.sourcePath = ".";
                    }
                    if (((ConfigureDialog)ConfigureDialog.this).SimView.this.sourcePath.endsWith("/")) {
                        ((ConfigureDialog)ConfigureDialog.this).SimView.this.sourcePath = ((ConfigureDialog)ConfigureDialog.this).SimView.this.sourcePath.substring(0, ((ConfigureDialog)ConfigureDialog.this).SimView.this.sourcePath.length() - 1);
                    }
                    ((ConfigureDialog)ConfigureDialog.this).SimView.this.modelPackages = new ArrayList();
                    StringReader stringReader = new StringReader(packagesArea.getText());
                    BufferedReader reader = new BufferedReader(stringReader);
                    while (true) {
                        String line = null;
                        try {
                            line = reader.readLine();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            continue;
                        }
                        if (line == null) break;
                        if ((line = line.trim()).equals("")) continue;
                        ((ConfigureDialog)ConfigureDialog.this).SimView.this.modelPackages.add(line);
                    }
                    SimView.this.populatePackagesBox(((ConfigureDialog)ConfigureDialog.this).SimView.this.packagesBox);
                    SimView.this.saveSettings();
                    ConfigureDialog.this.setVisible(false);
                }
            });
        }
    }

    protected class ContentPathKey {
        ContentInterface content;
        String componentName;

        public ContentPathKey(ContentInterface content_, String componentName_) {
            this.content = content_;
            this.componentName = componentName_;
        }

        public boolean equals(Object o) {
            if (o instanceof ContentPathKey) {
                ContentPathKey pair = (ContentPathKey)o;
                return this.content.equals(pair.content) && this.componentName.equals(pair.componentName);
            }
            return false;
        }

        public int hashCode() {
            return (String.valueOf(this.componentName) + this.content.getPort() + this.content.getValue()).hashCode();
        }
    }

    protected class ContentPathStep {
        public ComponentView view;
        public String portName;

        protected ContentPathStep() {
        }
    }

    protected class Coupling {
        public ComponentView sourceView;
        public ComponentView destView;
        public String sourcePortName;
        public String destPortName;

        protected Coupling() {
        }
    }

    protected class HelpDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public HelpDialog(Frame owner) {
            super(owner, "Help", true);
            this.setSize(550, 400);
            WindowUtil.centerWindow(this);
            this.constructUI();
        }

        protected void constructUI() {
            Container pane = this.getContentPane();
            JPanel main = new JPanel();
            main.setLayout(new BoxLayout(main, 1));
            main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            pane.add(main);
            JTextPane textPane = new JTextPane();
            try {
                textPane.setPage(new URL("file:SimView.html"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            textPane.setEditable(false);
            textPane.setFont(new Font("monospaced", 0, 12));
            JScrollPane scrollPane = new JScrollPane(textPane);
            main.add(scrollPane);
            main.add(Box.createRigidArea(new Dimension(0, 5)));
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            panel.setLayout(new BoxLayout(panel, 0));
            main.add(panel);
            JButton button = new JButton("Ok");
            panel.add(button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HelpDialog.this.setVisible(false);
                }
            });
        }
    }

    public class ModelView
    extends JLayeredPane
    implements TunableCoordinator.Listener,
    TunableCoupledCoordinator.Listener,
    ViewableAtomicSimulator.Listener,
    ViewableAtomicSimulator.TimeScaleKeeper {
        private static final long serialVersionUID = 1L;
        protected MoveContentViewThread moveContentViewThread;
        protected Map contentViewMovementMap = new HashMap();
        protected boolean showCouplings = false;
        protected CouplingsPanel couplingsPanel;
        protected List couplings = new ArrayList();
        protected List componentViews = new ArrayList();
        protected List contentViews = new ArrayList();
        protected Map contentPathMap = new HashMap();
        protected boolean stepMode = true;

        public ModelView() {
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setLayout(null);
            CouplingsPanel panel = this.couplingsPanel = new CouplingsPanel();
            this.add((Component)panel, new Integer(2));
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ModelView.this.couplingsPanel.setSize(ModelView.this.getSize());
                }
            });
            MoveContentViewThread thread = this.moveContentViewThread = new MoveContentViewThread();
            thread.start();
        }

        public void addView(ComponentView view, JComponent parent) {
            this.componentViews.add(view);
            JComponent comp = (JComponent)((Object)view);
            parent.add((Component)comp, new Integer(0));
            comp.setLocation(view.getPreferredLocation());
            comp.setSize(view.getPreferredSize());
        }

        public void inputInjected() {
            this.removeContentViews();
        }

        @Override
        public void iterationsCompleted() {
            SimView.this.setStatusLabelToReady();
        }

        @Override
        public double getTimeScale() {
            return SimView.this.coordinator.getTimeScale();
        }

        @Override
        public void clockChanged(double newTime) {
            if (newTime > SimView.this.clock.get()) {
                SimView.this.clock.set(newTime);
            }
        }

        public void removeAllViews() {
            this.componentViews.clear();
            SimView.this.modelView.removeAll();
            SimView.this.modelView.add(this.couplingsPanel);
        }

        public void stepToBeTaken() {
            this.removeContentViews();
            this.stepMode = true;
        }

        public void runToOccur() {
            this.removeContentViews();
            this.stepMode = false;
        }

        @Override
        public void contentOutputted(content content2, devs source, String sourcePortName) {
            if (!(source instanceof ViewableComponent)) {
                return;
            }
            if (!this.stepMode) {
                return;
            }
            ContentPathStep step = new ContentPathStep();
            step.view = ((ViewableComponent)((Object)source)).getView();
            step.portName = sourcePortName;
            ArrayList<ContentPathStep> path = new ArrayList<ContentPathStep>();
            path.add(step);
            ContentPathKey key = new ContentPathKey(content2, source.getName());
            this.contentPathMap.put(key, path);
        }

        @Override
        public void couplingAddedToContentPath(content oldContent, devs destComponent, String destPortName, content newContent, String sourceComponentName) {
            if (!(destComponent instanceof ViewableComponent)) {
                return;
            }
            if (!this.stepMode) {
                return;
            }
            ContentPathStep step = new ContentPathStep();
            step.view = ((ViewableComponent)((Object)destComponent)).getView();
            step.portName = destPortName;
            ContentPathKey key = new ContentPathKey(oldContent, sourceComponentName);
            ArrayList<ContentPathStep> path = (ArrayList<ContentPathStep>)this.contentPathMap.get(key);
            if (path == null) {
                return;
            }
            ContentViewMovement movement = (ContentViewMovement)this.contentViewMovementMap.remove(path);
            path = new ArrayList<ContentPathStep>(path);
            path.add(step);
            key = new ContentPathKey(newContent, destComponent.getName());
            this.contentPathMap.put(key, path);
            if (movement != null) {
                movement.path = path;
                this.contentViewMovementMap.put(path, movement);
            } else {
                ContentView view = new ContentView(newContent);
                view.setVisible(false);
                this.add((Component)view, new Integer(3));
                this.contentViews.add(view);
                view.setSize(view.getPreferredSize());
                DragViewListener listener = new DragViewListener(view, this);
                view.addMouseListener(listener);
                view.addMouseMotionListener(listener);
                movement = new ContentViewMovement();
                movement.view = view;
                movement.path = path;
                this.moveContentViewThread.addContentViewMovement(movement);
                this.contentViewMovementMap.put(path, movement);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (SimView.this.model == null || SimView.this.model.getView() == null) {
                return super.getPreferredSize();
            }
            Dimension size = ((JComponent)((Object)SimView.this.model.getView())).getSize();
            return new Dimension(size.width + 10, size.height + 10);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        protected void removeContentViews() {
            int i = 0;
            while (i < this.contentViews.size()) {
                ContentView view = (ContentView)this.contentViews.get(i);
                this.remove(view);
                ++i;
            }
            this.contentViews.clear();
            this.repaint();
        }

        public void mouseEnteredPort() {
            this.showCouplings = true;
            this.repaint();
        }

        public void mouseExitedPort() {
            this.showCouplings = false;
            this.repaint();
        }

        protected void simulationRestarted() {
            this.removeContentViews();
        }

        public Point getLocation(JComponent component) {
            return ComponentUtil.getLocationRelativeToAncestor(component, this);
        }

        public void addCoupling(Coupling coupling) {
            this.couplings.add(coupling);
        }

        public void clearCouplings() {
            this.couplings.clear();
        }

        protected class ContentViewMovement {
            protected ContentView view;
            protected List path;
            protected int currentStepIndex;
            protected double dx;
            protected double dy;
            protected Point2D.Double location;
            protected int movesRequired;
            protected int movesDone;

            protected ContentViewMovement() {
            }
        }

        protected class CouplingsPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;

            public CouplingsPanel() {
                this.setOpaque(false);
            }

            @Override
            public void paint(Graphics g) {
                if (ModelView.this.showCouplings || ((ModelView)ModelView.this).SimView.this.alwaysShowCouplings) {
                    g.setColor(Color.lightGray);
                    int i = 0;
                    while (i < ModelView.this.couplings.size()) {
                        Coupling coupling = (Coupling)ModelView.this.couplings.get(i);
                        if (!coupling.sourceView.getViewableComponent().isHidden() && !coupling.destView.getViewableComponent().isHidden()) {
                            Point source = ModelView.this.getLocation((JComponent)((Object)coupling.sourceView));
                            PointUtil.translate(source, coupling.sourceView.getPortLocation(coupling.sourcePortName));
                            Point dest = ModelView.this.getLocation((JComponent)((Object)coupling.destView));
                            PointUtil.translate(dest, coupling.destView.getPortLocation(coupling.destPortName));
                            g.drawLine(source.x, source.y, dest.x, dest.y);
                        }
                        ++i;
                    }
                }
            }
        }

        protected class MoveContentViewThread
        extends Thread {
            protected List movements = new ArrayList();

            protected MoveContentViewThread() {
            }

            public void addContentViewMovement(ContentViewMovement movement) {
                this.movements.add(movement);
            }

            @Override
            public void run() {
                while (true) {
                    this.moveContentViews();
                    Util.sleep(20L);
                }
            }

            /*
             * Unable to fully structure code
             */
            protected void moveContentViews() {
                i = 0;
                while (i < this.movements.size()) {
                    movement = (ContentViewMovement)this.movements.get(i);
                    if (movement.movesDone != 0) ** GOTO lbl38
                    step = (ContentPathStep)movement.path.get(movement.currentStepIndex);
                    if (step.view.getViewableComponent().isHidden()) {
                        ++movement.currentStepIndex;
                        if (movement.currentStepIndex >= movement.path.size()) {
                            this.discardMovement(movement);
                        }
                    } else {
                        view = movement.view;
                        if (movement.currentStepIndex == 0 || movement.location == null) {
                            start = ModelView.access$0((ModelView)ModelView.this).modelView.getLocation((JComponent)step.view);
                            PointUtil.translate(start, step.view.getPortLocation(step.portName));
                            viewX = start.x - view.getWidth() / 2;
                            viewY = start.y - view.getHeight() / 2;
                            view.setLocation(viewX, viewY);
                            view.setVisible(true);
                            movement.location = new Point2D.Double(viewX, viewY);
                            ++movement.currentStepIndex;
                            if (movement.currentStepIndex >= movement.path.size()) {
                                this.discardMovement(movement);
                            }
                        } else {
                            start = new Point((int)movement.location.x + view.getWidth() / 2, (int)movement.location.y + view.getHeight() / 2);
                            finish = ModelView.access$0((ModelView)ModelView.this).modelView.getLocation((JComponent)step.view);
                            PointUtil.translate(finish, step.view.getPortLocation(step.portName));
                            movement.location = new Point2D.Double(start.x, start.y);
                            angle = Math.atan2(finish.y - start.y, finish.x - start.x);
                            speed = 2;
                            movement.dx = 2.0 * Math.cos(angle);
                            movement.dy = 2.0 * Math.sin(angle);
                            location = movement.location;
                            movement.movesRequired = (int)Math.rint(location.distance(finish) / 2.0);
                            movement.movesDone = 0;
                            location.x -= (double)(view.getWidth() / 2);
                            location.y -= (double)(view.getHeight() / 2);
                            view.setLocation((int)Math.rint(location.x), (int)Math.rint(location.y));
lbl38:
                            // 2 sources

                            if (movement.movesDone < movement.movesRequired) {
                                location = movement.location;
                                location.x += movement.dx;
                                location.y += movement.dy;
                                movement.view.setLocation((int)Math.rint(location.x), (int)Math.rint(location.y));
                                ++movement.movesDone;
                            } else {
                                movement.movesDone = 0;
                                ++movement.currentStepIndex;
                                if (movement.currentStepIndex >= movement.path.size()) {
                                    this.discardMovement(movement);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }

            protected void discardMovement(ContentViewMovement movement) {
                ModelView.this.contentPathMap.remove(movement.view.getContent());
                ModelView.this.contentViewMovementMap.remove(movement.path);
                this.movements.remove(movement);
            }
        }
    }

    protected class RealTimeFactor {
        private double realTimeFactor;

        protected RealTimeFactor() {
            this.realTimeFactor = SimView.this.realTimeFactors[SimView.this.realTimeFactors.length / 2];
        }

        public double get() {
            return this.realTimeFactor;
        }

        public void set(double realTimeFactor_) {
            this.realTimeFactor = realTimeFactor_;
            if (SimView.this.realTimeFactorLabel != null) {
                SimView.this.realTimeFactorLabel.setText("" + this.realTimeFactor);
            }
            if (SimView.this.coordinator != null) {
                SimView.this.coordinator.setTimeScale(this.realTimeFactor);
            }
        }
    }
}

