/*
 * Decompiled with CFR 0.152.
 */
package util;

import GenCol.Queue;
import GenCol.doubleEnt;
import util.rand;

public class statistics {
    protected double[] numbers;
    protected Queue q;

    public statistics() {
        this.q = new Queue();
    }

    public statistics(double[] numbers) {
        this.numbers = numbers;
    }

    public int size() {
        return this.numbers.length;
    }

    public void add(double n) {
        this.q.add(new doubleEnt(n));
    }

    public void toArray() {
        this.numbers = new double[this.q.size()];
        int i = 0;
        while (i < this.numbers.length) {
            this.numbers[i] = ((doubleEnt)this.q.get(i)).getv();
            ++i;
        }
    }

    public String toString(double[] array) {
        String s = "{";
        int i = 0;
        while (i < array.length - 1) {
            s = String.valueOf(s) + array[i] + " ,";
            ++i;
        }
        return String.valueOf(s) + array[array.length - 1] + "}";
    }

    public double average() {
        double sum = 0.0;
        int i = 0;
        while (i < this.numbers.length) {
            sum += this.numbers[i];
            ++i;
        }
        return sum / (double)this.numbers.length;
    }

    public double avgOfSquares() {
        double sum = 0.0;
        int i = 0;
        while (i < this.numbers.length) {
            sum += this.numbers[i] * this.numbers[i];
            ++i;
        }
        return sum / (double)this.numbers.length;
    }

    public double variance() {
        double avg = this.average();
        return this.avgOfSquares() - avg * avg;
    }

    public double std() {
        return Math.sqrt(this.variance());
    }

    public double[] partition(double begin, double end, int numClasses) {
        double size = (end - begin) / (double)numClasses;
        if (size <= 0.0) {
            System.out.println("invalid class specification");
            return null;
        }
        double[] classes = new double[numClasses + 2];
        int i = 0;
        while (i < this.numbers.length) {
            int j = 0;
            while (j <= numClasses) {
                if (this.numbers[i] < begin + (double)j * size) {
                    int n = j;
                    classes[n] = classes[n] + 1.0;
                    break;
                }
                if (this.numbers[i] >= end) {
                    int n = numClasses + 1;
                    classes[n] = classes[n] + 1.0;
                }
                ++j;
            }
            ++i;
        }
        return classes;
    }

    public static void main(String[] args) {
        double[] numArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        statistics s = new statistics();
        s.add(1.0);
        s.add(2.0);
        s.add(3.0);
        s.toArray();
        System.out.println(s.average());
        System.out.println(s.avgOfSquares());
        System.out.println(s.variance());
        System.out.println(s.std());
        System.out.println("------------------------------");
        s.add(4.0);
        s.toArray();
        System.out.println(s.average());
        System.out.println("------------------------------");
        rand r = new rand(1L);
        numArray = new double[300];
        int i = 0;
        while (i < numArray.length) {
            numArray[i] = r.expon(1.0);
            ++i;
        }
        s = new statistics(numArray);
        System.out.println(s.average());
        System.out.println(s.avgOfSquares());
        System.out.println(s.variance());
        System.out.println(s.std());
        System.out.println(s.toString(s.partition(0.0, 5.0, 5)));
        System.out.println("------------------------------");
        numArray = new double[300];
        i = 0;
        while (i < numArray.length) {
            numArray[i] = r.lognormal(0.0, 0.7);
            ++i;
        }
        s = new statistics(numArray);
        System.out.println(s.average());
        System.out.println(s.avgOfSquares());
        System.out.println(s.variance());
        System.out.println(s.std());
        System.out.println(s.toString(s.partition(0.0, 100.0, 10)));
        System.out.println("------------------------------");
        numArray = new double[300];
        i = 0;
        while (i < numArray.length) {
            numArray[i] = r.pareto(10.0, 2.0);
            ++i;
        }
        s = new statistics(numArray);
        System.out.println(s.average());
        System.out.println(s.avgOfSquares());
        System.out.println(s.variance());
        System.out.println(s.std());
        System.out.println("------------------------------");
    }
}

