/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation;

import GenCol.EntityInterface;
import GenCol.Function;
import GenCol.Pair;
import GenCol.Relation;
import GenCol.entity;
import genDevs.modeling.ActivityInterface;
import genDevs.modeling.ContentInterface;
import genDevs.modeling.ContentIteratorInterface;
import genDevs.modeling.IOBasicDevs;
import genDevs.modeling.MessageInterface;
import genDevs.modeling.atomic;
import genDevs.modeling.content;
import genDevs.modeling.couprel;
import genDevs.modeling.message;
import genDevs.simulation.AtomicSimulatorUtil;
import genDevs.simulation.CoordinatorInterface;
import genDevs.simulation.CoupledCoordinatorInterface;
import genDevs.simulation.CoupledSimulatorInterface;
import genDevs.simulation.CouplingProtocolInterface;
import genDevs.simulation.atomicSimulator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import util.Logging;

public class coupledSimulator
extends atomicSimulator
implements CoupledSimulatorInterface {
    private static final long serialVersionUID = -4871386167073438664L;
    protected Function modelToSim = new Function();
    protected couprel coupInfo = new couprel();
    protected ActivityInterface myActivity = this.myModel.getActivity();
    protected boolean activityDue = false;
    protected CoupledCoordinatorInterface myParent;
    protected CoordinatorInterface myRootParent;

    public coupledSimulator() {
        this(new atomic());
    }

    public coupledSimulator(IOBasicDevs devs2) {
        super(devs2);
        this.myModel.setSimulator(this);
    }

    @Override
    public void setParent(CoupledCoordinatorInterface p) {
        this.myParent = p;
    }

    @Override
    public void setRootParent(CoordinatorInterface p) {
        this.myRootParent = p;
    }

    @Override
    public CoupledCoordinatorInterface getParent() {
        return this.myParent;
    }

    @Override
    public CoordinatorInterface getRootParent() {
        return this.myRootParent;
    }

    @Override
    public Double nextTNDouble() {
        return new Double(this.nextTN());
    }

    @Override
    public void DeltFunc(Double d) {
        this.DeltFunc((double)d);
    }

    @Override
    public void addPair(Pair cs, Pair cd) {
        this.coupInfo.add(cs, cd);
    }

    @Override
    public void showCoupling() {
        System.out.println("The coupling is: ");
        this.coupInfo.print();
    }

    @Override
    public void setModToSim(Function mts) {
        this.modelToSim = mts;
    }

    public synchronized Relation convertMsg(MessageInterface x) {
        Relation r = new Relation();
        if (x.isEmpty()) {
            return r;
        }
        ContentIteratorInterface cit = ((message)x).mIterator();
        while (cit.hasNext()) {
            content co = (content)cit.next();
            HashSet s = this.coupInfo.translate(this.myModel.getName(), co.getPort().getName());
            for (Pair cp : s) {
                content tempco = new content((String)cp.getValue(), (entity)co.getValue());
                r.put(cp.getKey(), tempco);
                this.convertMsgHook1(co, cp, tempco, this.myModel.getName(), (String)cp.getKey());
            }
        }
        return r;
    }

    @Override
    public void startActivity(ActivityInterface a) {
        a.setSimulator(this);
        this.myActivity = a;
        double completionTime = Math.random() * 2.0 * a.getProcessingTime();
        if (this.myModel instanceof atomic) {
            if (completionTime < ((atomic)this.myModel).getSigma()) {
                ((atomic)this.myModel).setSigma(completionTime);
                this.activityDue = true;
            }
        } else {
            return;
        }
    }

    @Override
    public void returnResultFromActivity(EntityInterface result) {
        content c = new content("outputFromActivity", (entity)result);
        this.putMessages(c);
    }

    @Override
    public void putMessages(ContentInterface c) {
        this.input.add(c);
    }

    @Override
    public void sendMessages() {
        MessageInterface o;
        if (this.activityDue) {
            this.returnResultFromActivity(this.myActivity.computeResult());
            this.activityDue = false;
        }
        if ((o = this.getOutput()) != null && !o.isEmpty()) {
            Relation r = this.convertMsg((message)this.getOutput());
            Iterator rit = r.iterator();
            while (rit.hasNext()) {
                CouplingProtocolInterface sim;
                Pair p = (Pair)rit.next();
                content co = (content)p.getValue();
                Object ds = p.getKey();
                if (this.modelToSim.get(ds) instanceof CoupledSimulatorInterface) {
                    sim = (CoupledSimulatorInterface)this.modelToSim.get(ds);
                    sim.putMessages(co);
                    continue;
                }
                if (this.modelToSim.get(ds) instanceof CoupledCoordinatorInterface) {
                    sim = (CoupledCoordinatorInterface)this.modelToSim.get(ds);
                    sim.putMessages(co);
                    continue;
                }
                CoupledCoordinatorInterface cci = this.getParent();
                CoordinatorInterface ci = this.getRootParent();
                if (cci != null) {
                    this.myParent.putMyMessages(co);
                    continue;
                }
                if (ci == null) continue;
                this.myRootParent.putMyMessages(co);
            }
        }
    }

    @Override
    public void DeltFunc(double t) {
        this.wrapDeltfunc(t, this.input);
        this.input = new message();
    }

    @Override
    public void simulate(int num_iter) {
        int i = 1;
        this.tN = this.nextTN();
        while (this.tN < Double.POSITIVE_INFINITY && i <= num_iter) {
            Logging.log("ITERATION " + i + " ,time: " + this.tN, 100);
            this.computeInputOutput(this.tN);
            this.showOutput();
            this.sendMessages();
            this.DeltFunc(this.tN);
            this.tL = this.tN;
            this.tN = this.nextTN();
            this.showModelState();
            ++i;
        }
        System.out.println("Terminated Normally at ITERATION " + i + " ,time: " + this.tN);
    }

    public List getCouplingsToSourcePort(String portName) {
        return AtomicSimulatorUtil.getCouplingsToSourcePort(portName, this.myModel.getName(), this.coupInfo, null, this.modelToSim, null, (atomicSimulator)((Object)this.myRootParent));
    }

    protected void convertMsgHook1(content oldContent, Pair coupling, content newContent, String sourceComponentName, String destComponentName) {
    }
}

