/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation.distributed;

import GenCol.ensembleBag;
import genDevs.modeling.coupledDevs;
import genDevs.simulation.coupledSimulator;
import genDevs.simulation.distributed.SimulatorProxy;
import genDevs.simulation.realTime.RTcoordinator;
import java.net.ServerSocket;
import java.net.Socket;
import util.Util;

public class RTCoordinatorServer
extends RTcoordinator {
    private static final long serialVersionUID = 3826329080501058948L;
    protected int numIterations;
    protected int registerCount = 1;

    public RTCoordinatorServer(coupledDevs devs2, int numIterations_, int port2, boolean shouldBroadcastInitialize) {
        super(devs2, true);
        this.numIterations = numIterations_;
        new WaitForClientsToConnectThread(port2, shouldBroadcastInitialize).start();
    }

    public RTCoordinatorServer(coupledDevs devs2, int numIterations) {
        this(devs2, numIterations, 7000, true);
    }

    public void registerSimulatorProxy(coupledSimulator proxy, String devsName) {
        this.simulators.add(proxy);
        this.modelToSim.put(devsName, proxy);
        --this.registerCount;
    }

    @Override
    public void setSimulators() {
        this.tellAllSimsSetModToSim();
    }

    protected void broadcast(String message2) {
        System.out.println("broadcast: tell all send " + message2);
        Class[] classes = new Class[]{ensembleBag.getTheClass("java.lang.String")};
        Object[] args = new Object[]{message2};
        this.simulators.tellAll("sendMessage", classes, args);
    }

    protected class WaitForClientsToConnectThread
    extends Thread {
        protected int port;
        protected boolean shouldBroadcastInitialize;

        public WaitForClientsToConnectThread(int port_, boolean shouldBroadcastInitialize_) {
            this.port = port_;
            this.shouldBroadcastInitialize = shouldBroadcastInitialize_;
        }

        @Override
        public void run() {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(this.port);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            RTCoordinatorServer.this.registerCount = RTCoordinatorServer.this.myCoupled.getComponents().size();
            int numConnected = 0;
            int numShouldConnect = RTCoordinatorServer.this.registerCount;
            while (numConnected < numShouldConnect) {
                Socket socket = null;
                try {
                    System.out.println("Waiting for connection...");
                    socket = serverSocket.accept();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("Yes!  Received a connection!");
                System.out.println("number connected:" + ++numConnected);
                new SimulatorProxy(socket, RTCoordinatorServer.this);
            }
            while (RTCoordinatorServer.this.registerCount > 0) {
                Util.sleep(1000L);
            }
            RTCoordinatorServer.this.setSimulators();
            RTCoordinatorServer.this.informCoupling();
            if (this.shouldBroadcastInitialize) {
                RTCoordinatorServer.this.broadcast("initialize:" + Util.time());
                RTCoordinatorServer.this.broadcast("startSimulate:" + RTCoordinatorServer.this.numIterations);
            }
        }
    }
}

