/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation.realTime;

import GenCol.Pair;
import GenCol.Relation;
import GenCol.ensembleBag;
import genDevs.modeling.ContentInterface;
import genDevs.modeling.Coupled;
import genDevs.modeling.IOBasicDevs;
import genDevs.modeling.MessageInterface;
import genDevs.modeling.content;
import genDevs.modeling.message;
import genDevs.simulation.CouplingProtocolInterface;
import genDevs.simulation.coupledCoordinator;
import genDevs.simulation.realTime.CoupledRTSimulatorInterface;
import genDevs.simulation.realTime.RTCoordinatorInterface;
import genDevs.simulation.realTime.RTCoupledCoordinatorInterface;
import genDevs.simulation.realTime.coupledRTSimulator;
import java.util.Iterator;

public class RTcoupledCoordinator
extends coupledCoordinator
implements RTCoupledCoordinatorInterface {
    private static final long serialVersionUID = -8747061543846459926L;
    protected int numIter;
    protected RTCoordinatorInterface myRTRootParent;
    protected RTcoupledCoordinator myRTParent;

    public RTcoupledCoordinator(Coupled c) {
        super(c);
    }

    public long timeInSecs() {
        return this.timeInMillis() / 1000L;
    }

    public long timeInMillis() {
        return System.currentTimeMillis();
    }

    public void setRTRootParent(RTCoordinatorInterface r) {
        this.myRTRootParent = r;
    }

    public RTCoordinatorInterface getRTRootParent() {
        return this.myRTRootParent;
    }

    public void setRTParent(RTcoupledCoordinator r) {
        this.myRTParent = r;
    }

    public RTCoupledCoordinatorInterface getRTParent() {
        return this.myRTParent;
    }

    @Override
    public void addSimulator(IOBasicDevs comp) {
        coupledRTSimulator s = new coupledRTSimulator(comp);
        this.simulators.add(s);
        s.setRTParent(this);
        this.modelToSim.put(comp.getName(), s);
        this.internalModelTosim.put(comp.getName(), s);
    }

    @Override
    public void addCoordinator(Coupled comp) {
        RTcoupledCoordinator s = new RTcoupledCoordinator(comp);
        s.setRTParent(this);
        this.simulators.add(s);
        this.modelToSim.put(comp.getName(), s);
        this.internalModelTosim.put(comp.getName(), s);
    }

    @Override
    public void simulate(int numIter) {
        this.numIter = numIter;
        this.tL = this.timeInSecs();
        this.tN = this.nextTN();
        this.tellAllSimulate(numIter);
    }

    @Override
    public synchronized void putMessages(ContentInterface c) {
        this.input.add(c);
        this.sendDownMessages();
        this.input = new message();
    }

    @Override
    public synchronized void putMyMessages(ContentInterface c) {
        this.output.add(c);
        this.sendMessages();
        this.output = new message();
    }

    @Override
    public void sendMessages() {
        MessageInterface o = this.getOutput();
        if (o != null && !o.isEmpty()) {
            Relation r = this.convertMsg((message)this.getOutput());
            Iterator rit = r.iterator();
            while (rit.hasNext()) {
                CouplingProtocolInterface sim;
                Pair p = (Pair)rit.next();
                content co = (content)p.getValue();
                Object ds = p.getKey();
                if (this.modelToSim.get(ds) instanceof CoupledRTSimulatorInterface) {
                    sim = (CoupledRTSimulatorInterface)this.modelToSim.get(ds);
                    sim.putMessages(co);
                    continue;
                }
                if (this.modelToSim.get(ds) instanceof RTCoupledCoordinatorInterface) {
                    sim = (RTCoupledCoordinatorInterface)this.modelToSim.get(ds);
                    sim.putMessages(co);
                    continue;
                }
                RTCoupledCoordinatorInterface cci = this.getRTParent();
                RTCoordinatorInterface ci = this.getRTRootParent();
                if (cci != null) {
                    this.myRTParent.putMyMessages(co);
                    continue;
                }
                if (ci == null) continue;
                this.myRTRootParent.putMyMessages(co);
            }
        }
    }

    @Override
    public void sendDownMessages() {
        if (!this.input.isEmpty()) {
            Relation r = this.convertInput(this.input);
            Iterator rit = r.iterator();
            while (rit.hasNext()) {
                CouplingProtocolInterface sim;
                Pair p = (Pair)rit.next();
                Object ds = p.getKey();
                content co = (content)p.getValue();
                if (this.internalModelTosim.get(ds) instanceof CoupledRTSimulatorInterface) {
                    sim = (CoupledRTSimulatorInterface)this.internalModelTosim.get(ds);
                    sim.putMessages(co);
                    continue;
                }
                if (!(this.internalModelTosim.get(ds) instanceof RTCoupledCoordinatorInterface)) continue;
                sim = (RTCoupledCoordinatorInterface)this.internalModelTosim.get(ds);
                sim.putMessages(co);
            }
        }
    }

    public void tellAllSimulate(int numIter) {
        Class[] classes = new Class[]{ensembleBag.getTheClass("java.lang.Integer")};
        Object[] args = new Object[]{new Integer(numIter)};
        this.simulators.tellAll("simulate", classes, args);
    }

    public void stopSimulate() {
        this.simulators.tellAll("stopSimulate");
    }

    public void tellAllStop() {
        this.simulators.tellAll("stopSimulate");
    }
}

