/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation.realTime;

import genDevs.modeling.Coupled;
import genDevs.modeling.IOBasicDevs;
import genDevs.modeling.digraph;
import genDevs.simulation.coupledSimulator;
import genDevs.simulation.realTime.RTCentralCoord;
import genDevs.simulation.realTime.TunableCoupledCoordinator;
import util.Logging;
import util.Util;

public class TunableCoordinator
extends RTCentralCoord {
    private static final long serialVersionUID = 6087100641266131901L;
    protected Listener listener;
    protected int timeScale = 1000;
    protected boolean shouldIterate = false;

    public TunableCoordinator(digraph digraph2, Listener listener_) {
        super(digraph2, false, null);
        this.listener = listener_;
        this.constructorHook1();
        this.setSimulators();
        this.informCoupling();
    }

    public TunableCoordinator(digraph digraph2) {
        this(digraph2, null);
    }

    protected void constructorHook1() {
    }

    @Override
    public void addSimulator(IOBasicDevs devs2) {
        coupledSimulator simulator = this.createSimulator(devs2);
        this.addSimulatorHook1(simulator);
        this.simulatorCreated(simulator, devs2);
    }

    protected void addSimulatorHook1(coupledSimulator simulator) {
    }

    protected coupledSimulator createSimulator(IOBasicDevs devs2) {
        coupledSimulator simulator = this.createSimulatorHook1(devs2);
        if (simulator == null) {
            simulator = new coupledSimulator(devs2);
        }
        simulator.setRootParent(this);
        simulator.initialize();
        return simulator;
    }

    protected coupledSimulator createSimulatorHook1(IOBasicDevs devs2) {
        return null;
    }

    @Override
    public void addCoordinator(Coupled digraph2) {
        TunableCoupledCoordinator coordinator2 = this.addCoordinatorHook1((digraph)digraph2);
        if (coordinator2 == null) {
            coordinator2 = new TunableCoupledCoordinator((digraph)digraph2, (TunableCoupledCoordinator.Listener)((Object)this.listener));
        }
        coordinator2.setRootParent(this);
        this.simulatorCreated(coordinator2, digraph2);
    }

    protected TunableCoupledCoordinator addCoordinatorHook1(digraph digraph2) {
        return null;
    }

    public double getTimeOfLastEvent() {
        return this.tL;
    }

    public void setTimeScale(double realTimeFactor) {
        this.timeScale = (int)Math.floor(1000.0 * realTimeFactor);
    }

    @Override
    public void initialize() {
        this.simulators.tellAll("initialize");
        this.tL = 0.0;
    }

    @Override
    public void simulate(int numIterations) {
        this.numIter = numIterations;
        this.shouldIterate = true;
        if (!this.myThread.isAlive()) {
            this.myThread.start();
        }
    }

    @Override
    public void run() {
        while (true) {
            if (!this.shouldIterate) {
                int minWait = 100;
                Util.sleep(this.myThread, 100L);
                continue;
            }
            int i = 1;
            this.tN = this.nextTN();
            while (this.tN < this.INFINITY && i <= this.numIter) {
                Logging.log("ITERATION " + i + " ,time: " + this.getTimeOfLastEvent(), 100);
                this.timeToSleep = (long)((this.tN - this.tL) * (double)this.timeScale);
                this.timeToSleep = Math.max(this.timeToSleep, 0L);
                Util.sleep(this.myThread, this.timeToSleep);
                this.computeInputOutput(this.tN);
                this.wrapDeltFunc(this.tN);
                this.tL = this.tN;
                this.tN = this.nextTN();
                ++i;
                if (this.listener == null) continue;
                this.listener.clockChanged(this.getTimeOfLastEvent());
            }
            System.out.println("Terminated Normally before ITERATION " + i + " ,time: " + this.getTimeOfLastEvent());
            this.shouldIterate = false;
            if (this.listener == null) continue;
            this.listener.iterationsCompleted();
        }
    }

    public void interrupt() {
        this.myThread.interrupt();
    }

    public double getTimeScale() {
        return this.timeScale;
    }

    public static interface Listener {
        public void clockChanged(double var1);

        public void iterationsCompleted();
    }
}

