/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation.realTime;

import GenCol.EntityInterface;
import GenCol.entity;
import genDevs.modeling.IOBasicDevs;
import genDevs.modeling.MessageInterface;
import genDevs.modeling.PortInterface;
import genDevs.modeling.message;
import genDevs.modeling.port;
import genDevs.simulation.atomicSimulator;
import genDevs.simulation.realTime.RTSimulatorInterface;
import genDevs.simulation.realTime.injectThread;
import util.Logging;

public class atomicRTSimulator
extends atomicSimulator
implements RTSimulatorInterface {
    private static final long serialVersionUID = -4996175761635046720L;
    protected Thread myThread = new Thread(this);
    protected double startTime;
    protected int numIter = 0;
    protected injectThread injThread;
    protected long timeToSleep;
    public boolean pauseFlag = false;

    public atomicRTSimulator(IOBasicDevs atomic2) {
        super(atomic2);
    }

    @Override
    public void initialize() {
        this.myModel.initialize();
        this.tL = this.startTime = (double)this.timeInMillis();
        this.tN = this.tL + this.myModel.ta() * 1000.0;
        Logging.log("Relative INITIALIZATION, time: 0, next event at: " + (this.tN - this.startTime), 100);
        this.myModel.showState();
    }

    @Override
    public void setTN() {
        this.tN = (double)this.timeInMillis() + this.myModel.ta() * 1000.0;
    }

    @Override
    public double getTN() {
        return this.tN;
    }

    @Override
    public long timeInSecs() {
        return this.timeInMillis() / 1000L;
    }

    @Override
    public long timeInMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public void sendMessages() {
    }

    public synchronized void myThreadpause() {
        this.pauseFlag = true;
    }

    public void myThreadrestart() {
        this.pauseFlag = false;
    }

    @Override
    public void simulate(int num) {
        this.numIter = num;
        this.myThread.start();
    }

    @Override
    public void stopSimulate() {
        this.numIter = 0;
        this.myThread.interrupt();
    }

    @Override
    public void run() {
        this.tL = this.timeInMillis();
        this.tN = this.tL + this.myModel.ta() * 1000.0;
        int iter = 0;
        while (this.tN < Double.POSITIVE_INFINITY && iter < this.numIter) {
            System.out.println("ITERATION " + iter + " ,relative time: " + (this.tN - this.startTime));
            while ((double)this.timeInMillis() < this.getTN() - 10.0) {
                this.timeToSleep = (long)(this.getTN() - (double)this.timeInMillis());
                if (this.timeToSleep < 0L) continue;
                try {
                    Thread.sleep(this.timeToSleep);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.computeInputOutput(this.getTN());
            this.showOutput();
            this.sendMessages();
            this.wrapDeltfunc(this.getTN());
            this.showModelState();
            while (this.pauseFlag) {
            }
            this.tL = this.timeInMillis();
            this.tN = this.tL + this.myModel.ta() * 1000.0;
            ++iter;
        }
        System.out.println("Terminated Normally at ITERATION " + iter + ",relative time: " + (this.tN - this.startTime));
    }

    @Override
    public void wrapDeltfunc(double t, MessageInterface x) {
        if (x == null) {
            System.out.println("ERROR RECEIVED NULL INPUT  " + this.myModel.toString());
            return;
        }
        if (x.isEmpty() && !this.equalTN(t)) {
            return;
        }
        if (!x.isEmpty() && this.equalTN(t)) {
            double e = t - this.tL;
            this.myModel.deltcon(e / 1000.0, x);
        } else if (this.equalTN(t)) {
            this.myModel.deltint();
        } else if (!x.isEmpty()) {
            double e = t - this.tL;
            this.myModel.deltext(e / 1000.0, x);
        }
        this.tL = t;
        this.tN = this.tL + this.myModel.ta() * 1000.0;
    }

    @Override
    public MessageInterface makeMessage() {
        return new message();
    }

    @Override
    public void simInject(double e, String portName, entity value) {
        this.simInject(e, new port(portName), (EntityInterface)value);
    }

    @Override
    public void simInject(double e, PortInterface p, EntityInterface value) {
        MessageInterface m = this.makeMessage();
        m.add(this.myModel.makeContent(p, value));
        this.simInject(e, m);
    }

    @Override
    public void simInject(double e, MessageInterface m) {
        this.injThread = new injectThread(this, e, m);
    }
}

