/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.examples;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import moea.commons.Population;
import moea.commons.comparator.ComparatorPareto;
import moea.moga.algorithms.Moea;
import moea.moga.algorithms.Vega;
import moea.moga.genome.Chromosome;
import moea.moga.genome.ChromosomeWithMapping;

public class ChowPaper
extends ChromosomeWithMapping {
    protected static KindOfFunction kindOfFunction;
    protected static int numTrials;

    static {
        numTrials = 100;
    }

    @Override
    public ChowPaper clone() {
        ChowPaper clone = new ChowPaper(this);
        return clone;
    }

    public ChowPaper() {
    }

    public ChowPaper(ChowPaper src) {
        super(src);
    }

    public static void initializeProblem(String[] args) throws Exception {
        String function = args[0];
        N = 1;
        M = Integer.valueOf(args[1]);
        if (M != 40 && M != 60) {
            throw new Exception("Second argument must be 40 or 60");
        }
        if (function.equals("UGLY")) {
            kindOfFunction = KindOfFunction.UGLY;
        } else if (function.equals("BAD")) {
            kindOfFunction = KindOfFunction.BAD;
        } else if (function.equals("TRAP4")) {
            kindOfFunction = KindOfFunction.TRAP4;
        } else if (function.equals("TRAP8")) {
            kindOfFunction = KindOfFunction.TRAP8;
        } else {
            throw new Exception("First argument must be UGLY, BAD, TRAP4 OR TRAP8");
        }
        xL = new double[M];
        xU = new double[M];
        int j = 0;
        while (j < M) {
            ChowPaper.xL[j] = 0.0;
            ChowPaper.xU[j] = 1.0;
            ++j;
        }
    }

    @Override
    public void evaluate() {
        int i = 0;
        while (i < N) {
            this.objectiveVector.set(i, 0.0);
            ++i;
        }
        int groups = M / 4;
        double fitnessG = 0.0;
        double acumulador = 0.0;
        int[] auxiliar = new int[4];
        int i2 = 0;
        while (i2 < groups) {
            int j = 0;
            while (j < 4) {
                auxiliar[j] = (int)Math.round(this.x[this.mapping[groups * j + i2]]);
                ++j;
            }
            int valorDecimal = 0;
            int base2 = 1;
            int m = 3;
            while (m >= 0) {
                valorDecimal += auxiliar[m] * base2;
                base2 *= 2;
                --m;
            }
            acumulador = kindOfFunction == KindOfFunction.UGLY ? (acumulador += ChowPaper.ugly(valorDecimal)) : (acumulador += ChowPaper.bad(valorDecimal));
            ++i2;
        }
        fitnessG = -acumulador;
        this.objectiveVector.set(0, fitnessG);
    }

    public static void printStats(BufferedWriter out, int[] array) throws Exception {
        int optimalValues = 0;
        int generations = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != 0) {
                ++optimalValues;
                generations += array[i];
            }
            ++i;
        }
        double avg = 1.0 * (double)generations / (double)optimalValues;
        out.write("Optimal values: " + optimalValues + "\n");
        out.write("Avg. Generations: " + avg + "\n");
    }

    public static void main(String[] args) throws Exception {
        args = new String[]{"UGLY", "40", "10000", "200"};
        if (args.length != 4) {
            System.out.println("Arguments: Function NumBits Evaluations Size");
            System.out.println("Recommended: [UGLY|BAD] [40|60] 10000 200");
            System.out.println("Recommended: [UGLY|BAD] [40|60] 50000 2000");
            return;
        }
        ChowPaper.initializeProblem(args);
        BufferedWriter out = new BufferedWriter(new FileWriter(new File("ChowPaper_" + args[0] + "_" + args[1] + "_" + args[2] + "_" + args[3] + ".txt")));
        int[] genToMax = new int[numTrials];
        int i = 0;
        while (i < numTrials) {
            genToMax[i] = 0;
            out.write("Iteration number: " + i + "...");
            System.out.print("Iteration number: " + i + "...");
            Population<Chromosome> popIni = new Population<Chromosome>();
            int k = 0;
            while (k < Integer.valueOf(args[3])) {
                ChowPaper individual = new ChowPaper();
                popIni.add(individual);
                ++k;
            }
            Vega algorithm = new Vega("Vega", popIni, Integer.valueOf(args[2]), 0.6, 1.0 / (double)M);
            while (!algorithm.done() && genToMax[i] == 0) {
                ((Moea)algorithm).step();
                Chromosome ind = algorithm.getPopulation().getBestIndividual(ComparatorPareto.getInstance());
                double value = (Double)ind.getObjectiveVector().get(0);
                if (!ChowPaper.isOptimal(value)) continue;
                genToMax[i] = algorithm.getCurrentGeneration();
            }
            out.write("done with optimal at generation: " + genToMax[i] + "\n");
            System.out.println("done with optimal at generation: " + genToMax[i]);
            ++i;
        }
        ChowPaper.printStats(out, genToMax);
        out.flush();
        out.close();
    }

    public static boolean isOptimal(double value) {
        return value <= -(30.0 * (double)M) / 4.0;
    }

    public static double bad(int parametro) {
        double res = 0.0;
        switch (parametro) {
            case 0: {
                res = 18.0;
                break;
            }
            case 1: {
                res = 6.0;
                break;
            }
            case 2: {
                res = 26.0;
                break;
            }
            case 3: {
                res = 16.0;
                break;
            }
            case 4: {
                res = 24.0;
                break;
            }
            case 5: {
                res = 14.0;
                break;
            }
            case 6: {
                res = 28.0;
                break;
            }
            case 7: {
                res = 20.0;
                break;
            }
            case 8: {
                res = 4.0;
                break;
            }
            case 9: {
                res = 30.0;
                break;
            }
            case 10: {
                res = 12.0;
                break;
            }
            case 11: {
                res = 0.0;
                break;
            }
            case 12: {
                res = 10.0;
                break;
            }
            case 13: {
                res = 2.0;
                break;
            }
            case 14: {
                res = 22.0;
                break;
            }
            case 15: {
                res = 8.0;
                break;
            }
            default: {
                res = 0.0;
            }
        }
        return res;
    }

    public static double ugly(int parametro) {
        double res = 0.0;
        switch (parametro) {
            case 0: {
                res = 28.0;
                break;
            }
            case 1: {
                res = 26.0;
                break;
            }
            case 2: {
                res = 24.0;
                break;
            }
            case 3: {
                res = 18.0;
                break;
            }
            case 4: {
                res = 22.0;
                break;
            }
            case 5: {
                res = 16.0;
                break;
            }
            case 6: {
                res = 14.0;
                break;
            }
            case 7: {
                res = 0.0;
                break;
            }
            case 8: {
                res = 20.0;
                break;
            }
            case 9: {
                res = 12.0;
                break;
            }
            case 10: {
                res = 10.0;
                break;
            }
            case 11: {
                res = 2.0;
                break;
            }
            case 12: {
                res = 8.0;
                break;
            }
            case 13: {
                res = 4.0;
                break;
            }
            case 14: {
                res = 6.0;
                break;
            }
            case 15: {
                res = 30.0;
                break;
            }
            default: {
                res = 0.0;
            }
        }
        return res;
    }

    protected static enum KindOfFunction {
        UGLY,
        BAD,
        TRAP4,
        TRAP8;

    }
}

