/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.examples;

import moea.commons.Population;
import moea.commons.examples.TestFunction;
import moea.moga.algorithms.Moea;
import moea.moga.algorithms.Nsga2;
import moea.moga.genome.Chromosome;

public class TestMoga
extends Chromosome {
    public static TestFunction<Chromosome> testFunctions = null;

    public static void initializeProblem(String[] args) {
        testFunctions = new TestFunction(args);
    }

    public TestMoga() {
    }

    public TestMoga(TestMoga src) {
        super(src);
    }

    @Override
    public TestMoga clone() {
        TestMoga clone = new TestMoga(this);
        return clone;
    }

    @Override
    public void evaluate() {
        testFunctions.evaluateFunction(this.x, this.objectiveVector);
    }

    public static void main(String[] args) throws Exception {
        args = new String[]{"ZDT4", "100", "400"};
        TestMoga.initializeProblem(args);
        Population pof = testFunctions.generateParetoOptimalFront(500);
        int i = 0;
        while (i < 1) {
            System.out.println("Iteration number: " + i);
            Population<Chromosome> popIni = new Population<Chromosome>();
            int k = 0;
            while (k < Integer.valueOf(args[2])) {
                TestMoga particle = new TestMoga();
                popIni.add(particle);
                ++k;
            }
            Nsga2 algorithm = new Nsga2("Moga", popIni, Integer.valueOf(args[1]), 0.8, 0.01);
            while (!algorithm.done()) {
                if (algorithm.getCurrentGeneration() % 100 == 0) {
                    System.out.println("Current generation: " + algorithm.getCurrentGeneration());
                }
                ((Moea)algorithm).step();
            }
            Population<Chromosome> runPop = algorithm.getPopulation();
            runPop.keepNonDominated();
            System.out.println("Non-dominated solutions: " + runPop.size());
            double gd = testFunctions.calculateGenerationalDistance(runPop, pof);
            System.out.println("Generational distance: " + gd);
            double s = testFunctions.calculateDiversity(runPop, pof);
            System.out.println("Diversity: " + s);
            ++i;
        }
    }
}

