/*
 * Decompiled with CFR 0.152.
 */
package moea.mopso.examples;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import moea.commons.ObjectiveVector;
import moea.commons.Population;
import moea.moga.examples.Profile;
import moea.mopso.algorithms.HNSPSO;
import moea.mopso.algorithms.MOPSO;
import moea.mopso.society.Particle;

public class ProfileMopso
extends Particle {
    public static void initializeProblem(String proPath) {
        Profile.initializeProblem(proPath);
        double[] xLTemp = new double[M];
        double[] xUTemp = new double[M];
        int i = 0;
        while (i < M) {
            xLTemp[i] = 0.0;
            xUTemp[i] = 9.0;
            ++i;
        }
        xL = xLTemp;
        xU = xUTemp;
    }

    public ProfileMopso() {
        super(0.4, 1.0, 1.0);
    }

    public ProfileMopso(ProfileMopso src) {
        super(src);
    }

    @Override
    public ProfileMopso clone() {
        ProfileMopso clone = new ProfileMopso(this);
        return clone;
    }

    @Override
    public void evaluate() {
        int i = 0;
        while (i < this.objectiveVector.size()) {
            this.objectiveVector.set(i, 0.0);
            ++i;
        }
        double performance = 0.0;
        double memory = 0.0;
        double energy = 0.0;
        double randomCount = 0.0;
        double secuentialCount = 0.0;
        double averageSize = 0.0;
        double numCreations = 0.0;
        double reads = 0.0;
        double writes = 0.0;
        double execTime = 0.0;
        int i2 = 0;
        while (i2 < M) {
            int ddt = (int)Math.round(this.x[i2]);
            randomCount = 0.0;
            secuentialCount = 0.0;
            averageSize = 0.0;
            numCreations = 0.0;
            reads = Profile.readsPerDdt[i2][ddt];
            writes = Profile.writesPerDdt[i2][ddt];
            execTime = 0.0;
            if (ddt == 0) {
                secuentialCount = 9L * Profile.Ne[i2];
                randomCount = 2.0;
                averageSize = (long)(19 * Profile.Tref) + Profile.Ne[i2] * (long)Profile.Te[i2];
                numCreations = 1.0;
            } else if (ddt == 1) {
                secuentialCount = 10L * Profile.Ne[i2];
                randomCount = 3.0;
                averageSize = (long)(19 * Profile.Tref) + Profile.Ne[i2] * (long)(Profile.Tref + Profile.Te[i2]);
                numCreations = 1.0 + Profile.Nve[i2];
            } else if (ddt == 2) {
                secuentialCount = 7L * Profile.Ne[i2];
                randomCount = Profile.Ne[i2] / 2L + 1L;
                averageSize = (long)(19 * Profile.Tref) + Profile.Ne[i2] * (long)(2 * Profile.Tref + Profile.Te[i2]);
                numCreations = 1.0 + Profile.Nve[i2];
            } else if (ddt == 3) {
                secuentialCount = 7L * Profile.Ne[i2];
                randomCount = Profile.Ne[i2] / 4L + 1L;
                averageSize = (long)(19 * Profile.Tref) + Profile.Ne[i2] * (long)(3 * Profile.Tref + Profile.Te[i2]);
                numCreations = 1.0 + Profile.Nve[i2];
            } else if (ddt == 4) {
                secuentialCount = 10L * Profile.Ne[i2];
                randomCount = Profile.Ne[i2] / 3L + 1L;
                averageSize = (long)(20 * Profile.Tref) + Profile.Ne[i2] * (long)(2 * Profile.Tref + Profile.Te[i2]);
                numCreations = 1.0 + Profile.Nve[i2];
            } else if (ddt == 5) {
                secuentialCount = 10L * Profile.Ne[i2];
                randomCount = Profile.Ne[i2] / 6L + 1L;
                averageSize = (long)(20 * Profile.Tref) + Profile.Ne[i2] * (long)(3 * Profile.Tref + Profile.Te[i2]);
                numCreations = 1.0 + Profile.Nve[i2];
            } else if (ddt == 6) {
                secuentialCount = 18L * Profile.Ne[i2] + (long)(8 * Profile.Na);
                randomCount = Profile.Nn[i2] / 2.0 + 1.0;
                averageSize = (double)(21 * Profile.Tref) + Profile.Nn[i2] * (double)((long)(21 * Profile.Tref) + Profile.Ne[i2] * (long)(Profile.Te[i2] + Profile.Tref));
                numCreations = (double)(2L * Profile.Ne[i2]) + Profile.Nve[i2];
            } else if (ddt == 7) {
                secuentialCount = 18L * Profile.Ne[i2] + (long)(8 * Profile.Na);
                randomCount = Profile.Nn[i2] / 4.0 + 1.0;
                averageSize = (double)(21 * Profile.Tref) + Profile.Nn[i2] * (double)((long)(22 * Profile.Tref) + Profile.Ne[i2] * (long)(Profile.Te[i2] + Profile.Tref));
                numCreations = (double)(2L * Profile.Ne[i2]) + Profile.Nve[i2];
            } else if (ddt == 8) {
                secuentialCount = 18L * Profile.Ne[i2] + (long)(10 * Profile.Na);
                randomCount = Profile.Nn[i2] / 3.0 + 1.0;
                averageSize = (double)(22 * Profile.Tref) + Profile.Nn[i2] * (double)((long)(21 * Profile.Tref) + Profile.Ne[i2] * (long)(Profile.Te[i2] + Profile.Tref));
                numCreations = (double)(2L * Profile.Ne[i2]) + Profile.Nve[i2];
            } else if (ddt == 9) {
                secuentialCount = 18L * Profile.Ne[i2] + (long)(10 * Profile.Na);
                randomCount = Profile.Nn[i2] / 6.0 + 1.0;
                averageSize = (double)(22 * Profile.Tref) + Profile.Nn[i2] * (double)((long)(22 * Profile.Tref) + Profile.Ne[i2] * (long)(Profile.Te[i2] + Profile.Tref));
                numCreations = (double)(2L * Profile.Ne[i2]) + Profile.Nve[i2];
            }
            performance += 1.0E-5 * (randomCount * (3.0 * (reads + writes - 2.0) / 4.0) + secuentialCount * ((reads + writes - 2.0) / 4.0) + 2.0 * numCreations);
            memory += averageSize;
            execTime = (reads + writes) * (1.0 - Profile.cacheMissesL1[i2][ddt]) * Profile.cacheAccessTime + (reads + writes) * Profile.cacheMissesL1[i2][ddt] * Profile.dramAccessTime + (reads + writes) * Profile.cacheMissesL1[i2][ddt] * Profile.cacheLineSize * (1.0 / Profile.dramBandwith);
            energy += execTime * Profile.cpuPower + (reads + writes) * (1.0 - Profile.cacheMissesL1[i2][ddt]) * Profile.cacheAccessEnergy + (reads + writes) * Profile.cacheMissesL1[i2][ddt] * Profile.cacheAccessEnergy * Profile.cacheLineSize + (reads + writes) * Profile.cacheMissesL1[i2][ddt] * Profile.dramAccessPower * (Profile.dramAccessTime + Profile.cacheLineSize / Profile.dramBandwith);
            ++i2;
        }
        this.objectiveVector.set(0, performance);
        this.objectiveVector.set(1, memory);
        this.objectiveVector.set(2, energy);
    }

    public static void main(String[] args) throws Exception {
        String outDir = ".";
        if (args.length < 5) {
            System.out.println("Usage:");
            System.out.println("java -jar Profile.jar <XML-PROFILE> <HNSPSO> <NumTrials:1..Inf> <NumOfIndividuals:1..Inf> <MaxGenerations:1..Inf> <UniformAnalysis:true|false>");
            args = new String[]{"Physics.pro", "HNSPSO", "10", "200", "4000"};
            outDir = "D:/jlrisco/Trabajo/MisPapers/IEEE T EVOLUT COMPUT/2007/Results";
            return;
        }
        String proPath = String.valueOf(outDir) + File.separator + args[0];
        String algorithmName = args[1];
        Integer numberOfTrials = Integer.valueOf(args[2]);
        Integer numberOfIndividuals = Integer.valueOf(args[3]);
        Integer maxGenerations = Integer.valueOf(args[4]);
        ProfileMopso.initializeProblem(proPath);
        MOPSO algorithm = null;
        int i = 0;
        while (i < numberOfTrials) {
            BufferedWriter loggerPop = new BufferedWriter(new FileWriter(new File(String.valueOf(proPath) + "." + algorithmName + "." + i)));
            System.out.println("Iteration number: " + i);
            Population<Particle> popIni = new Population<Particle>();
            int k = 0;
            while (k < numberOfIndividuals) {
                ProfileMopso particle = new ProfileMopso();
                popIni.add(particle);
                ++k;
            }
            if (algorithmName.equals("HNSPSO")) {
                algorithm = new HNSPSO("Mopso", popIni, maxGenerations);
            }
            double start = System.currentTimeMillis();
            while (!algorithm.done()) {
                if (algorithm.getT() % 100 == 0) {
                    System.out.println("Current generation: " + algorithm.getT());
                }
                algorithm.step();
            }
            double end = System.currentTimeMillis();
            System.out.println("Time: " + (end - start) / 1000.0);
            System.out.println("done.");
            loggerPop.write(ProfileMopso.ParetoFrontToString(algorithm.getPopulation()));
            loggerPop.flush();
            loggerPop.close();
            ++i;
        }
    }

    public static String ParetoFrontToString(Population<Particle> pop) {
        StringBuffer buffer = new StringBuffer();
        Population<Particle> popTemp = new Population<Particle>();
        popTemp.add(pop);
        popTemp.keepNonDominated();
        for (Particle chrom : popTemp) {
            ObjectiveVector objs = chrom.getObjectiveVector();
            int i = 0;
            while (i < N) {
                buffer.append(objs.get(i) + "\t");
                ++i;
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

