/*
 * Decompiled with CFR 0.152.
 */
package simView;

import GenCol.EntityInterface;
import GenCol.Pair;
import genDevs.modeling.ContentInterface;
import genDevs.modeling.ContentIteratorInterface;
import genDevs.modeling.content;
import genDevs.modeling.devs;
import genDevs.simulation.AtomicSimulatorUtil;
import genDevs.simulation.atomicSimulator;
import genDevs.simulation.coupledSimulator;
import simView.AtomicView;
import simView.ViewableAtomic;
import simView.ViewableComponent;
import util.Util;

public class ViewableAtomicSimulator
extends coupledSimulator {
    private static final long serialVersionUID = -2440821695962026227L;
    protected TimeScaleKeeper timeScaleKeeper;
    protected Listener listener;
    protected ViewableAtomic viewableAtomic;

    public ViewableAtomicSimulator(ViewableAtomic viewableAtomic_) {
        super(viewableAtomic_);
        this.viewableAtomic = viewableAtomic_;
    }

    @Override
    protected void computeInputOutputHook1() {
        if (this.listener == null) {
            return;
        }
        ContentIteratorInterface iterator = this.output.mIterator();
        while (iterator.hasNext()) {
            ContentInterface content2 = iterator.next();
            this.listener.contentOutputted((content)content2, this.viewableAtomic, content2.getPort().getName());
        }
    }

    @Override
    protected void wrapDeltfuncHook2() {
        AtomicView view = this.viewableAtomic.getAtomicView();
        if (view != null) {
            view.phaseChanged();
        }
    }

    @Override
    protected void simInjectHook1(double waitTime) {
        if (this.timeScaleKeeper == null) {
            return;
        }
        long timeToSleep = (long)(waitTime * this.timeScaleKeeper.getTimeScale());
        Util.sleep(timeToSleep);
    }

    @Override
    protected void simInjectHook2(double newTime) {
        if (this.listener == null) {
            return;
        }
        this.listener.clockChanged(newTime);
    }

    @Override
    protected void convertMsgHook1(content oldContent, Pair coupling, content newContent, String sourceComponentName, String destComponentName) {
        if (this.listener == null) {
            return;
        }
        EntityInterface component = AtomicSimulatorUtil.getComponentWithName(destComponentName, this.modelToSim, (atomicSimulator)((Object)this.myRootParent));
        if (component instanceof ViewableComponent) {
            this.listener.couplingAddedToContentPath(oldContent, (devs)component, (String)coupling.getValue(), newContent, sourceComponentName);
        }
    }

    public void setListener(Listener listener_) {
        this.listener = listener_;
    }

    public void setTimeScaleKeeper(TimeScaleKeeper keeper) {
        this.timeScaleKeeper = keeper;
    }

    public static interface Listener {
        public void contentOutputted(content var1, devs var2, String var3);

        public void couplingAddedToContentPath(content var1, devs var2, String var3, content var4, String var5);

        public void clockChanged(double var1);
    }

    public static interface TimeScaleKeeper {
        public double getTimeScale();
    }
}

