/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.imageio.ImageIO;

public class Util {
    public static final int BYTES_READED = 2048;

    public static BufferedImage loadBufferedImage(String fileName) {
        BufferedImage image = null;
        ByteBuffer buffer = ByteBuffer.allocateDirect(2048);
        File file = new File(fileName);
        int imageBytesPos = 0;
        try {
            int blockLength;
            FileInputStream fis = new FileInputStream(file);
            FileChannel channel = fis.getChannel();
            byte[] imageBytes = new byte[fis.available()];
            while ((blockLength = channel.read(buffer)) != -1) {
                buffer.flip();
                buffer.get(imageBytes, imageBytesPos, blockLength);
                imageBytesPos += Math.min(imageBytes.length - imageBytesPos, 2048);
                buffer.clear();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(imageBytes);
            image = ImageIO.read(bais);
        }
        catch (FileNotFoundException e) {
            System.out.println(file.toString() + " no existe.");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (image.getType() == 0) {
            BufferedImage imageARGB = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            imageARGB.getGraphics().drawImage(image, 0, 0, null);
            image = imageARGB;
        }
        return image;
    }
}

