/*
 * Decompiled with CFR 0.152.
 */
package editor.view;

import editor.ext.jgraph.AtomicNode;
import editor.ext.model.TreeXml;
import editor.ext.model.TreeXmlNodeInfo;
import editor.ext.model.VElementSimMod;
import editor.util.Util;
import editor.view.ModelWindow;
import editor.view.actions.AboutAction;
import editor.view.actions.ActionImportLibrary;
import editor.view.actions.AddIPortAction;
import editor.view.actions.AddOPortAction;
import editor.view.actions.CloseAction;
import editor.view.actions.CollapseAction;
import editor.view.actions.ConnectAction;
import editor.view.actions.CopyAction;
import editor.view.actions.CutAction;
import editor.view.actions.EditAtomicAction;
import editor.view.actions.ExitAction;
import editor.view.actions.ExpandAction;
import editor.view.actions.ExportAsAction;
import editor.view.actions.GroupAction;
import editor.view.actions.NewAction;
import editor.view.actions.OpenFileAction;
import editor.view.actions.OpenModelAction;
import editor.view.actions.PasteAction;
import editor.view.actions.PrintAction;
import editor.view.actions.PropertiesTableListener;
import editor.view.actions.RemoveAction;
import editor.view.actions.SaveAction;
import editor.view.actions.SaveAsAction;
import editor.view.actions.SelectAllAction;
import editor.view.actions.StatusBarMouseListener;
import editor.view.actions.TabbedEditorMouseListener;
import editor.view.actions.UngroupAction;
import editor.view.pane.LibraryPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.io.File;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel toolsPanel = null;
    private JPanel topPanel = null;
    private LibraryPane libraryPane = null;
    private JSplitPane centerSplitPane = null;
    private JSplitPane rightSplitPane;
    private JTabbedPane objectInspectorTabbedPane = null;
    private JScrollPane propertiesScrollPane = null;
    private JScrollPane attributesScrollPane = null;
    private JTextPane statusBar = null;
    private JMenuBar topMenuBar = null;
    private JMenu coupledMenu = null;
    private JMenu editMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem cutMenuItem = null;
    private JMenuItem copyMenuItem = null;
    private JMenuItem pasteMenuItem = null;
    private JMenuItem saveMenuItem = null;
    private JMenuItem openMenuItem = null;
    private JMenuItem newMenuItem = null;
    private JMenuItem closeMenuItem = null;
    private JMenuItem saveAsMenuItem = null;
    private JMenuItem printMenuItem = null;
    private JMenuItem deleteMenuItem = null;
    private JMenuItem selectAllMenuItem = null;
    private JMenuItem openEditMenuItem = null;
    private JMenu viewMenu = null;
    private JMenuItem toolbarMenuItem = null;
    private JMenuItem libraryMenuItem = null;
    private JMenuItem objectInspectorMenuItem = null;
    private JMenu formatMenu = null;
    private JMenu simulationMenu = null;
    private JMenuItem contentsMenuItem = null;
    private JMenuItem addIportMenuItem = null;
    private JMenuItem addOportMenuItem = null;
    private JMenuItem editAtomicMenuItem;
    private JToolBar myToolBar = null;
    private JButton newButton = null;
    private JButton openButton = null;
    private JButton saveButton = null;
    private JButton saveAsButton = null;
    private JButton printButton = null;
    private JButton copyButton = null;
    private JButton cutButton = null;
    private JButton pasteButton = null;
    private JToolBar moreToolBar = null;
    private JButton openModelButton = null;
    private JButton connectButton = null;
    private JButton removeButton = null;
    private JButton addIPortButton = null;
    private JButton addOPortButton = null;
    private JButton groupButton = null;
    private JButton ungroupButton = null;
    private JButton collapseButton = null;
    private JButton expandButton = null;
    private JTabbedPane tabbedEditorPanel = null;
    private JTable propertiesTable = null;
    private JTable attributesTable = null;
    private DefaultTableModel attributesTableModel = null;
    private DefaultTableModel propertiesTableModel = null;
    public JTree libraryTree;
    private Vector<String> columnsPropIds = null;
    private Vector<String> columnsAttIds = null;
    private Font defaultFont;
    private String iconsPath = null;
    private Action actionAbout = new AboutAction(this);
    private Action actionRemove = new RemoveAction(this);
    private Action actionClose = new CloseAction(this);
    private Action actionConnect = new ConnectAction(this);
    private Action actionCopy = new CopyAction(this);
    private Action actionCut = new CutAction(this);
    private Action actionExit = new ExitAction(this);
    private Action actionExportAs = new ExportAsAction(this);
    private Action actionNew = new NewAction(this);
    private Action actionOpenFile = new OpenFileAction(this);
    private Action actionOpenModel = new OpenModelAction(this);
    private Action actionPaste = new PasteAction(this);
    private Action actionPrint = new PrintAction(this);
    private Action actionSave = new SaveAction(this);
    private Action actionSaveAs = new SaveAsAction(this);
    private Action actionSelectAll = new SelectAllAction(this);
    private Action actionGroup = new GroupAction(this);
    private Action actionUngroup = new UngroupAction(this);
    private Action actionCollapse = new CollapseAction(this);
    private Action actionExpand = new ExpandAction(this);
    private Action actionEditAtomic = new EditAtomicAction(this);
    private Action actionAddIPort = new AddIPortAction(this);
    private Action actionAddOPort = new AddOPortAction(this);
    private Action actionImportLibrary = new ActionImportLibrary(this);
    private MouseAdapter statusAbout = new StatusBarMouseListener(this, "Information about DEVS editor");
    private MouseAdapter statusRemove = new StatusBarMouseListener(this, "Delete the selection");
    private MouseAdapter statusClose = new StatusBarMouseListener(this, "Close current document");
    private MouseAdapter statusConnect = new StatusBarMouseListener(this, "Specify conecctions between models");
    private MouseAdapter statusCopy = new StatusBarMouseListener(this, "Copy the selection to clipboard");
    private MouseAdapter statusCut = new StatusBarMouseListener(this, "Cut the selection to clipboard");
    private MouseAdapter statusExit = new StatusBarMouseListener(this, "Exit application");
    private MouseAdapter statusExportAs = new StatusBarMouseListener(this, "Export current model as...");
    private MouseAdapter statusNew = new StatusBarMouseListener(this, "Create a new model");
    private MouseAdapter statusOpenFile = new StatusBarMouseListener(this, "Open a saved file...");
    private MouseAdapter statusOpenModel = new StatusBarMouseListener(this, "Open the selected model in a new canvas");
    private MouseAdapter statusPaste = new StatusBarMouseListener(this, "Paste from clipboard");
    private MouseAdapter statusPrint = new StatusBarMouseListener(this, "Print current model");
    private MouseAdapter statusSave = new StatusBarMouseListener(this, "Save current model");
    private MouseAdapter statusSaveAs = new StatusBarMouseListener(this, "Save current model as...");
    private MouseAdapter statusSelectAll = new StatusBarMouseListener(this, "Select all element in current model");
    private MouseAdapter statusGroup = new StatusBarMouseListener(this, "Group several cells");
    private MouseAdapter statusUngroup = new StatusBarMouseListener(this, "Ungroup a group of cells");
    private MouseAdapter statusCollapse = new StatusBarMouseListener(this, "Collapse a group of cells");
    private MouseAdapter statusExpand = new StatusBarMouseListener(this, "Expand a collapsed group of cells");
    private MouseAdapter statusAddIPort = new StatusBarMouseListener(this, "Add an input port");
    private MouseAdapter statusAddOPort = new StatusBarMouseListener(this, "Add an output port");
    private MouseAdapter statusEditAtomic = new StatusBarMouseListener(this, "Edit selected atomic model attributes");
    private MouseAdapter statusImportLibrary = new StatusBarMouseListener(this, "Import library from an XML file");

    public MainWindow() throws HeadlessException {
        this.initialize();
    }

    public MainWindow(GraphicsConfiguration gc) {
        super(gc);
        this.initialize();
    }

    public MainWindow(String title) throws HeadlessException {
        super(title);
        this.initialize();
    }

    public MainWindow(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initialize();
    }

    private void initialize() {
        this.defaultFont = new Font("Dialog", 0, 12);
        this.iconsPath = "resources" + File.separator + "icons" + File.separator;
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getTopMenuBar());
        this.setSize(800, 450);
        this.setJMenuBar(this.getTopMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setTitle("xDEVS Editor");
        Dimension screenRes = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screenRes.width / 2 - this.getWidth() / 2;
        int y = screenRes.height / 2 - this.getHeight() / 2;
        this.setLocation(x, y);
    }

    private JToolBar getMyToolBar() {
        if (this.myToolBar == null) {
            this.myToolBar = new JToolBar();
            this.myToolBar.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.myToolBar.setBorderPainted(true);
            this.myToolBar.setOrientation(0);
            this.myToolBar.add(this.getNewButton());
            this.myToolBar.add(this.getOpenButton());
            this.myToolBar.add(this.getSaveButton());
            this.myToolBar.add(this.getSaveAsButton());
            this.myToolBar.add(this.getPrintButton());
            this.myToolBar.addSeparator();
            this.myToolBar.add(this.getCopyButton());
            this.myToolBar.add(this.getCutButton());
            this.myToolBar.add(this.getPasteButton());
            this.myToolBar.setFloatable(true);
            this.myToolBar.setRollover(true);
        }
        return this.myToolBar;
    }

    private JScrollPane getLibraryPane() {
        if (this.libraryPane == null) {
            JTree tree = new JTree(new TreeXml(new TreeXmlNodeInfo("Library")));
            this.libraryPane = new LibraryPane(tree);
        }
        return this.libraryPane;
    }

    private void createLibrary(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode directory = null;
        DefaultMutableTreeNode file = null;
        FileSystemView fs = FileSystemView.getFileSystemView();
        File[] dirList = fs.getFiles(new File("library"), false);
        for (int i = 0; i <= dirList.length - 1; ++i) {
            if (!dirList[i].isDirectory()) continue;
            directory = new DefaultMutableTreeNode(dirList[i].getName());
            File[] fileList = fs.getFiles(dirList[i], false);
            for (int j = 0; j <= fileList.length - 1; ++j) {
                if (!fileList[j].isFile() || !fileList[j].getName().endsWith(".xml")) continue;
                file = new DefaultMutableTreeNode(fileList[j].getName());
                directory.add(file);
            }
            root.add(directory);
        }
    }

    private JSplitPane getCenterSplitPane() {
        if (this.centerSplitPane == null) {
            this.centerSplitPane = new JSplitPane();
            this.centerSplitPane.setDividerSize(4);
            this.centerSplitPane.setDividerLocation(190);
            this.centerSplitPane.setRightComponent(this.getRightSplitPane());
            this.centerSplitPane.setLeftComponent(this.getObjectInspectorTabbedPane());
            this.centerSplitPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }
        return this.centerSplitPane;
    }

    private JSplitPane getRightSplitPane() {
        if (this.rightSplitPane == null) {
            this.rightSplitPane = new JSplitPane();
            this.rightSplitPane.setDividerSize(5);
            this.rightSplitPane.setDividerLocation(400);
            this.rightSplitPane.setLeftComponent(this.getTabbedEditorPanel());
            this.rightSplitPane.setRightComponent(this.getLibraryPane());
            this.rightSplitPane.setResizeWeight(1.0);
        }
        return this.rightSplitPane;
    }

    public JTabbedPane getTabbedEditorPanel() {
        if (this.tabbedEditorPanel == null) {
            this.tabbedEditorPanel = new JTabbedPane();
            this.tabbedEditorPanel.setFont(this.defaultFont);
            this.tabbedEditorPanel.setTabPlacement(3);
            this.tabbedEditorPanel.addMouseListener(new TabbedEditorMouseListener(this));
        }
        return this.tabbedEditorPanel;
    }

    public void addNewCanvas(AtomicNode initialCells) {
        ModelWindow newCanvas = new ModelWindow(this, initialCells);
        newCanvas.setBackground(Color.WHITE);
        newCanvas.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        int count = this.tabbedEditorPanel.getTabCount() + 1;
        this.tabbedEditorPanel.addTab("Coupled Model " + count, newCanvas);
    }

    private JTabbedPane getObjectInspectorTabbedPane() {
        if (this.objectInspectorTabbedPane == null) {
            this.objectInspectorTabbedPane = new JTabbedPane();
            this.objectInspectorTabbedPane.setFont(this.defaultFont);
            this.objectInspectorTabbedPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Object Inspector"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.objectInspectorTabbedPane.setTabLayoutPolicy(1);
            this.objectInspectorTabbedPane.addTab("Properties", null, this.getPropertiesScrollPane(), "Specify appereance properties");
            this.objectInspectorTabbedPane.addTab("Attributes", null, this.getAttributesScrollPane(), "Specify behavior attributes");
        }
        return this.objectInspectorTabbedPane;
    }

    private JScrollPane getPropertiesScrollPane() {
        if (this.propertiesScrollPane == null) {
            this.propertiesScrollPane = new JScrollPane();
            this.propertiesScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.propertiesScrollPane.setViewportView(this.getPropertiesTable());
        }
        return this.propertiesScrollPane;
    }

    public JTable getPropertiesTable() {
        if (this.propertiesTable == null) {
            this.propertiesTable = new JTable();
            this.propertiesTable.setSelectionMode(0);
            this.propertiesTable.setSelectionMode(0);
            this.propertiesTable.setModel(this.getPropertiesTableModel());
            this.propertiesTable.getModel().addTableModelListener(new PropertiesTableListener(this));
        }
        return this.propertiesTable;
    }

    private JScrollPane getAttributesScrollPane() {
        if (this.attributesScrollPane == null) {
            this.attributesScrollPane = new JScrollPane();
            this.attributesScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.attributesScrollPane.setViewportView(this.getAttributesTable());
        }
        return this.attributesScrollPane;
    }

    public JTable getAttributesTable() {
        if (this.attributesTable == null) {
            this.attributesTable = new JTable();
            this.attributesTable.setSelectionMode(0);
            this.attributesTable.setModel(this.getAttributesTableModel());
        }
        return this.attributesTable;
    }

    public DefaultTableModel getAttributesTableModel() {
        if (this.attributesTableModel == null) {
            this.attributesTableModel = new DefaultTableModel();
            this.attributesTableModel.setColumnIdentifiers(this.getColumnsAttributesIds());
        }
        return this.attributesTableModel;
    }

    public DefaultTableModel getPropertiesTableModel() {
        if (this.propertiesTableModel == null) {
            this.propertiesTableModel = new DefaultTableModel();
            this.propertiesTableModel.setColumnIdentifiers(this.getColumnsPropertiesIds());
        }
        return this.propertiesTableModel;
    }

    public Vector getColumnsPropertiesIds() {
        if (this.columnsPropIds == null) {
            this.columnsPropIds = new Vector();
            this.columnsPropIds.add("Parameters");
            this.columnsPropIds.add("Values");
        }
        return this.columnsPropIds;
    }

    public Vector getColumnsAttributesIds() {
        if (this.columnsAttIds == null) {
            this.columnsAttIds = new Vector();
            this.columnsAttIds.add("Name");
            this.columnsAttIds.add("Type");
            this.columnsAttIds.add("Value");
            this.columnsAttIds.add("Doc");
        }
        return this.columnsAttIds;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
            this.jContentPane.add((Component)this.getTopPanel(), "North");
            this.jContentPane.add((Component)this.getCenterSplitPane(), "Center");
            this.jContentPane.add((Component)this.getStatusBar(), "South");
        }
        return this.jContentPane;
    }

    private JMenuBar getTopMenuBar() {
        if (this.topMenuBar == null) {
            this.topMenuBar = new JMenuBar();
            this.topMenuBar.setBorderPainted(false);
            this.topMenuBar.add(this.getCoupledMenu());
            this.topMenuBar.add(this.getEditMenu());
            this.topMenuBar.add(this.getViewMenu());
            this.topMenuBar.add(this.getFormatMenu());
            this.topMenuBar.add(this.getSimulationMenu());
            this.topMenuBar.add(this.getHelpMenu());
        }
        return this.topMenuBar;
    }

    private JMenu getCoupledMenu() {
        if (this.coupledMenu == null) {
            this.coupledMenu = new JMenu();
            this.coupledMenu.setText("Coupled Model");
            this.coupledMenu.setFont(this.defaultFont);
            this.coupledMenu.add(this.getNewMenuItem());
            this.coupledMenu.add(this.getOpenMenuItem());
            this.coupledMenu.add(this.getCloseMenuItem());
            this.coupledMenu.add(this.getSaveMenuItem());
            this.coupledMenu.add(this.getSaveAsMenuItem());
            this.coupledMenu.add(this.getPrintMenuItem());
            this.coupledMenu.add(this.getExitMenuItem());
        }
        return this.coupledMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.setFont(this.defaultFont);
            this.helpMenu.add(this.getAboutMenuItem());
            this.helpMenu.add(this.getImportLibraryMenuItem());
            this.helpMenu.add(this.getContentsMenuItem());
        }
        return this.helpMenu;
    }

    private JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu();
            this.editMenu.setText("Edit");
            this.editMenu.setFont(this.defaultFont);
            this.editMenu.add(this.getCutMenuItem());
            this.editMenu.add(this.getCopyMenuItem());
            this.editMenu.add(this.getRemoveMenuItem());
            this.editMenu.add(this.getEditAtomicMenuItem());
            this.editMenu.add(this.getSelectAllMenuItem());
            this.editMenu.add(this.getPasteMenuItem());
            this.editMenu.add(this.getOpenEditMenuItem());
        }
        return this.editMenu;
    }

    public JMenuItem getSaveMenuItem() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new JMenuItem();
            this.saveMenuItem.setText("Save");
            this.saveMenuItem.setIcon(new ImageIcon(this.iconsPath + "disk.png"));
            this.saveMenuItem.addMouseListener(this.statusSave);
            this.saveMenuItem.addActionListener(this.actionSave);
            this.saveMenuItem.setFont(this.defaultFont);
            this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, true));
        }
        return this.saveMenuItem;
    }

    public JMenuItem getPrintMenuItem() {
        if (this.printMenuItem == null) {
            this.printMenuItem = new JMenuItem();
            this.printMenuItem.setText("Print");
            this.printMenuItem.setIcon(new ImageIcon(this.iconsPath + "print.png"));
            this.printMenuItem.addMouseListener(this.statusPrint);
            this.printMenuItem.addActionListener(this.actionPrint);
            this.printMenuItem.setFont(this.defaultFont);
        }
        return this.printMenuItem;
    }

    public JMenuItem getNewMenuItem() {
        if (this.newMenuItem == null) {
            this.newMenuItem = new JMenuItem();
            this.newMenuItem.setText("New");
            this.newMenuItem.setIcon(new ImageIcon(this.iconsPath + "empty.png"));
            this.newMenuItem.addMouseListener(this.statusNew);
            this.newMenuItem.addActionListener(this.actionNew);
            this.newMenuItem.setFont(this.defaultFont);
            this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2, true));
        }
        return this.newMenuItem;
    }

    public JMenuItem getOpenMenuItem() {
        if (this.openMenuItem == null) {
            this.openMenuItem = new JMenuItem();
            this.openMenuItem.setText("Open...");
            this.openMenuItem.setIcon(new ImageIcon(this.iconsPath + "folder.png"));
            this.openMenuItem.addMouseListener(this.statusOpenFile);
            this.openMenuItem.addActionListener(this.actionOpenFile);
            this.openMenuItem.setFont(this.defaultFont);
        }
        return this.openMenuItem;
    }

    public JMenuItem getCloseMenuItem() {
        if (this.closeMenuItem == null) {
            this.closeMenuItem = new JMenuItem();
            this.closeMenuItem.setText("Close");
            this.closeMenuItem.setIcon(new ImageIcon(this.iconsPath + "pageDelete.png"));
            this.closeMenuItem.addMouseListener(this.statusClose);
            this.closeMenuItem.addActionListener(this.actionClose);
            this.closeMenuItem.setFont(this.defaultFont);
            this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2, true));
        }
        return this.closeMenuItem;
    }

    public JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.setIcon(new ImageIcon(this.iconsPath + "blank.png"));
            this.exitMenuItem.setFont(this.defaultFont);
            this.exitMenuItem.addMouseListener(this.statusExit);
            this.exitMenuItem.addActionListener(this.actionExit);
        }
        return this.exitMenuItem;
    }

    public JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.setFont(this.defaultFont);
            this.aboutMenuItem.addMouseListener(this.statusAbout);
            this.aboutMenuItem.addActionListener(this.actionAbout);
        }
        return this.aboutMenuItem;
    }

    public JMenuItem getCutMenuItem() {
        if (this.cutMenuItem == null) {
            this.cutMenuItem = new JMenuItem();
            this.cutMenuItem.setText("Cut");
            this.cutMenuItem.setIcon(new ImageIcon(this.iconsPath + "cut.png"));
            this.cutMenuItem.addMouseListener(this.statusCut);
            this.cutMenuItem.addActionListener(this.actionCut);
            this.cutMenuItem.setFont(this.defaultFont);
            this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, true));
        }
        return this.cutMenuItem;
    }

    public JMenuItem getCopyMenuItem() {
        if (this.copyMenuItem == null) {
            this.copyMenuItem = new JMenuItem();
            this.copyMenuItem.setText("Copy");
            this.copyMenuItem.setIcon(new ImageIcon(this.iconsPath + "copy.png"));
            this.copyMenuItem.addMouseListener(this.statusCopy);
            this.copyMenuItem.addActionListener(this.actionCopy);
            this.copyMenuItem.setFont(this.defaultFont);
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, true));
        }
        return this.copyMenuItem;
    }

    public JMenuItem getPasteMenuItem() {
        if (this.pasteMenuItem == null) {
            this.pasteMenuItem = new JMenuItem();
            this.pasteMenuItem.setText("Paste");
            this.pasteMenuItem.setIcon(new ImageIcon(this.iconsPath + "paste.png"));
            this.pasteMenuItem.addMouseListener(this.statusPaste);
            this.pasteMenuItem.addActionListener(this.actionPaste);
            this.pasteMenuItem.setFont(this.defaultFont);
            this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, true));
        }
        return this.pasteMenuItem;
    }

    public JMenuItem getRemoveMenuItem() {
        if (this.deleteMenuItem == null) {
            this.deleteMenuItem = new JMenuItem();
            this.deleteMenuItem.setText("Delete");
            this.deleteMenuItem.setIcon(new ImageIcon(this.iconsPath + "delete.png"));
            this.deleteMenuItem.setFont(this.defaultFont);
            this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 2, true));
            this.deleteMenuItem.addMouseListener(this.statusRemove);
            this.deleteMenuItem.addActionListener(this.actionRemove);
        }
        return this.deleteMenuItem;
    }

    public JMenuItem getSelectAllMenuItem() {
        if (this.selectAllMenuItem == null) {
            this.selectAllMenuItem = new JMenuItem();
            this.selectAllMenuItem.setText("Select All...");
            this.selectAllMenuItem.setIcon(new ImageIcon(this.iconsPath + "blank.png"));
            this.selectAllMenuItem.addMouseListener(this.statusSelectAll);
            this.selectAllMenuItem.addActionListener(this.actionSelectAll);
            this.selectAllMenuItem.setFont(this.defaultFont);
        }
        return this.selectAllMenuItem;
    }

    public JMenuItem getOpenEditMenuItem() {
        if (this.openEditMenuItem == null) {
            this.openEditMenuItem = new JMenuItem();
            this.openEditMenuItem.setText("Open...");
            this.openEditMenuItem.setIcon(new ImageIcon(this.iconsPath + "open.png"));
            this.openEditMenuItem.addMouseListener(this.statusOpenModel);
            this.openEditMenuItem.addActionListener(this.actionOpenModel);
            this.openEditMenuItem.setFont(this.defaultFont);
        }
        return this.openEditMenuItem;
    }

    public JMenuItem getSaveAsMenuItem() {
        if (this.saveAsMenuItem == null) {
            this.saveAsMenuItem = new JMenuItem();
            this.saveAsMenuItem.setText("Save As...");
            this.saveAsMenuItem.setIcon(new ImageIcon(this.iconsPath + "saveAs.png"));
            this.saveAsMenuItem.addMouseListener(this.statusSaveAs);
            this.saveAsMenuItem.addActionListener(this.actionSaveAs);
            this.saveAsMenuItem.setFont(this.defaultFont);
        }
        return this.saveAsMenuItem;
    }

    public JMenuItem getEditAtomicMenuItem() {
        if (this.editAtomicMenuItem == null) {
            this.editAtomicMenuItem = new JMenuItem();
            this.editAtomicMenuItem.setText("Edit Atomic...");
            this.editAtomicMenuItem.setIcon(new ImageIcon(this.iconsPath + "editAtomic.png"));
            this.editAtomicMenuItem.addMouseListener(this.statusEditAtomic);
            this.editAtomicMenuItem.addActionListener(this.actionEditAtomic);
            this.editAtomicMenuItem.setFont(this.defaultFont);
        }
        return this.editAtomicMenuItem;
    }

    public JMenuItem getAddIPortMenuItem() {
        if (this.addIportMenuItem == null) {
            this.addIportMenuItem = new JMenuItem();
            this.addIportMenuItem.setText("Add input port");
            this.addIportMenuItem.setIcon(new ImageIcon(this.iconsPath + "addIPort.png"));
            this.addIportMenuItem.setFont(this.defaultFont);
            this.addIportMenuItem.addActionListener(this.actionAddIPort);
        }
        return this.addIportMenuItem;
    }

    public JMenuItem getAddOPortMenuItem() {
        if (this.addOportMenuItem == null) {
            this.addOportMenuItem = new JMenuItem();
            this.addOportMenuItem.setText("Add output port");
            this.addOportMenuItem.setIcon(new ImageIcon(this.iconsPath + "addOPort.png"));
            this.addOportMenuItem.setFont(this.defaultFont);
            this.addOportMenuItem.addActionListener(this.actionAddOPort);
        }
        return this.addOportMenuItem;
    }

    public JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "disk.png")));
            this.saveButton.setToolTipText("Save");
            this.saveButton.addMouseListener(this.statusSave);
        }
        return this.saveButton;
    }

    public JButton getOpenButton() {
        if (this.openButton == null) {
            this.openButton = new JButton();
            this.openButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "folder.png")));
            this.openButton.setToolTipText("Open");
            this.openButton.addMouseListener(this.statusOpenFile);
        }
        return this.openButton;
    }

    public JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton();
            this.newButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "empty.png")));
            this.newButton.setToolTipText("New");
            this.newButton.addActionListener(this.actionNew);
            this.newButton.addMouseListener(this.statusNew);
        }
        return this.newButton;
    }

    public JButton getSaveAsButton() {
        if (this.saveAsButton == null) {
            this.saveAsButton = new JButton();
            this.saveAsButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "saveAs.png")));
            this.saveAsButton.setToolTipText("Save As");
            this.saveAsButton.addActionListener(this.actionSaveAs);
            this.saveAsButton.addMouseListener(this.statusSaveAs);
        }
        return this.saveAsButton;
    }

    public JButton getPrintButton() {
        if (this.printButton == null) {
            this.printButton = new JButton();
            this.printButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "print.png")));
            this.printButton.setToolTipText("Print");
            this.printButton.addActionListener(this.actionPrint);
            this.printButton.addMouseListener(this.statusPrint);
        }
        return this.printButton;
    }

    public JButton getCopyButton() {
        if (this.copyButton == null) {
            this.copyButton = new JButton();
            this.copyButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "copy.png")));
            this.copyButton.setToolTipText("Copy");
            this.copyButton.addActionListener(this.actionCopy);
            this.copyButton.addMouseListener(this.statusCopy);
        }
        return this.copyButton;
    }

    public JButton getPasteButton() {
        if (this.pasteButton == null) {
            this.pasteButton = new JButton();
            this.pasteButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "paste.png")));
            this.pasteButton.setToolTipText("Paste");
            this.pasteButton.addActionListener(this.actionPaste);
            this.pasteButton.addMouseListener(this.statusPaste);
        }
        return this.pasteButton;
    }

    public JButton getConnectButton() {
        if (this.connectButton == null) {
            this.connectButton = new JButton();
            this.connectButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "connect.png")));
            this.connectButton.setToolTipText("Connect");
            this.connectButton.addActionListener(this.actionConnect);
            this.connectButton.addMouseListener(this.statusConnect);
        }
        return this.connectButton;
    }

    public JButton getCutButton() {
        if (this.cutButton == null) {
            this.cutButton = new JButton();
            this.cutButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "cut.png")));
            this.cutButton.setToolTipText("Cut");
            this.cutButton.addActionListener(this.actionCut);
            this.cutButton.addMouseListener(this.statusCut);
        }
        return this.cutButton;
    }

    public JButton getOpenModelButton() {
        if (this.openModelButton == null) {
            this.openModelButton = new JButton();
            this.openModelButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "newView.png")));
            this.openModelButton.setToolTipText("Open Model");
            this.openModelButton.addActionListener(this.actionOpenModel);
            this.openModelButton.addMouseListener(this.statusOpenModel);
        }
        return this.openModelButton;
    }

    public JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "delete.png")));
            this.removeButton.setToolTipText("Delete");
            this.removeButton.addMouseListener(this.statusRemove);
            this.removeButton.addActionListener(this.actionRemove);
        }
        return this.removeButton;
    }

    private JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu();
            this.viewMenu.setText("View");
            this.viewMenu.setPreferredSize(new Dimension(37, 21));
            this.viewMenu.setFont(this.defaultFont);
            this.viewMenu.add(this.getToolbarMenuItem());
            this.viewMenu.add(this.getImportLibraryMenuItem());
            this.viewMenu.add(this.getObjectInspectorMenuItem());
            this.viewMenu.setVisible(true);
        }
        return this.viewMenu;
    }

    private JMenuItem getToolbarMenuItem() {
        if (this.toolbarMenuItem == null) {
            this.toolbarMenuItem = new JMenuItem();
            this.toolbarMenuItem.setText("Toolbar");
            this.toolbarMenuItem.setFont(this.defaultFont);
        }
        return this.toolbarMenuItem;
    }

    private JMenuItem getImportLibraryMenuItem() {
        if (this.libraryMenuItem == null) {
            this.libraryMenuItem = new JMenuItem();
            this.libraryMenuItem.setText("Import Library ...");
            this.libraryMenuItem.addMouseListener(this.statusImportLibrary);
            this.libraryMenuItem.addActionListener(this.actionImportLibrary);
            this.libraryMenuItem.setFont(this.defaultFont);
        }
        return this.libraryMenuItem;
    }

    private JMenuItem getObjectInspectorMenuItem() {
        if (this.objectInspectorMenuItem == null) {
            this.objectInspectorMenuItem = new JMenuItem();
            this.objectInspectorMenuItem.setText("Object inspector");
            this.objectInspectorMenuItem.setFont(this.defaultFont);
        }
        return this.objectInspectorMenuItem;
    }

    private JMenu getFormatMenu() {
        if (this.formatMenu == null) {
            this.formatMenu = new JMenu();
            this.formatMenu.setText("Format");
            this.formatMenu.setFont(this.defaultFont);
        }
        return this.formatMenu;
    }

    private JMenu getSimulationMenu() {
        if (this.simulationMenu == null) {
            this.simulationMenu = new JMenu();
            this.simulationMenu.setText("Simulation");
            this.simulationMenu.setFont(this.defaultFont);
        }
        return this.simulationMenu;
    }

    private JMenuItem getContentsMenuItem() {
        if (this.contentsMenuItem == null) {
            this.contentsMenuItem = new JMenuItem();
            this.contentsMenuItem.setText("Contents");
            this.contentsMenuItem.setFont(this.defaultFont);
        }
        return this.contentsMenuItem;
    }

    private JToolBar getMoreToolBar() {
        if (this.moreToolBar == null) {
            this.moreToolBar = new JToolBar();
            this.moreToolBar.setFloatable(true);
            this.moreToolBar.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.moreToolBar.setBorderPainted(true);
            this.moreToolBar.add(this.getConnectButton());
            this.moreToolBar.add(this.getOpenModelButton());
            this.moreToolBar.add(this.getRemoveButton());
            this.moreToolBar.addSeparator();
            this.moreToolBar.add(this.getAddIPortButton());
            this.moreToolBar.add(this.getAddOPortButton());
            this.moreToolBar.addSeparator();
            this.moreToolBar.add(this.getGroupButton());
            this.moreToolBar.add(this.getUngroupButton());
            this.moreToolBar.add(this.getCollapseButton());
            this.moreToolBar.add(this.getExpandButton());
            this.moreToolBar.setRollover(true);
        }
        return this.moreToolBar;
    }

    public JButton getUngroupButton() {
        if (this.ungroupButton == null) {
            this.ungroupButton = new JButton();
            this.ungroupButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "ungroup.png")));
            this.ungroupButton.setToolTipText("Ungroup");
            this.ungroupButton.addMouseListener(this.statusUngroup);
            this.ungroupButton.addActionListener(this.actionUngroup);
        }
        return this.ungroupButton;
    }

    public JButton getCollapseButton() {
        if (this.collapseButton == null) {
            this.collapseButton = new JButton();
            this.collapseButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "collapse.png")));
            this.collapseButton.setToolTipText("Collapse");
            this.collapseButton.addMouseListener(this.statusCollapse);
            this.collapseButton.addActionListener(this.actionCollapse);
        }
        return this.collapseButton;
    }

    public JButton getExpandButton() {
        if (this.expandButton == null) {
            this.expandButton = new JButton();
            this.expandButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "expand.png")));
            this.expandButton.setToolTipText("Expand");
            this.expandButton.addMouseListener(this.statusExpand);
            this.expandButton.addActionListener(this.actionExpand);
        }
        return this.expandButton;
    }

    public JButton getGroupButton() {
        if (this.groupButton == null) {
            this.groupButton = new JButton();
            this.groupButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "group.png")));
            this.groupButton.setToolTipText("Group");
            this.groupButton.addMouseListener(this.statusGroup);
            this.groupButton.addActionListener(this.actionGroup);
        }
        return this.groupButton;
    }

    private JPanel getToolsPanel() {
        if (this.toolsPanel == null) {
            this.toolsPanel = new JPanel();
            this.toolsPanel.add((Component)this.getMyToolBar(), null);
            this.toolsPanel.add((Component)this.getMoreToolBar(), null);
        }
        return this.toolsPanel;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BorderLayout());
            this.topPanel.add((Component)this.getToolsPanel(), "West");
        }
        return this.topPanel;
    }

    public JTextPane getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new JTextPane();
            this.statusBar.setEditable(false);
            this.statusBar.setFont(this.defaultFont);
            this.statusBar.setBorder(BorderFactory.createBevelBorder(1));
            this.statusBar.setBackground(new Color(238, 238, 238));
            this.statusBar.setText("Status Bar");
            this.statusBar.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
        return this.statusBar;
    }

    public JButton getAddIPortButton() {
        if (this.addIPortButton == null) {
            this.addIPortButton = new JButton();
            this.addIPortButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "addIPort.png")));
            this.addIPortButton.setToolTipText("Add Input Port");
            this.addIPortButton.addMouseListener(this.statusAddIPort);
            this.addIPortButton.addActionListener(this.actionAddIPort);
        }
        return this.addIPortButton;
    }

    public JButton getAddOPortButton() {
        if (this.addOPortButton == null) {
            this.addOPortButton = new JButton();
            this.addOPortButton.setIcon(new ImageIcon(Util.loadBufferedImage(this.iconsPath + "addOPort.png")));
            this.addOPortButton.setToolTipText("Add Output Port");
            this.addOPortButton.addMouseListener(this.statusAddOPort);
            this.addOPortButton.addActionListener(this.actionAddOPort);
        }
        return this.addOPortButton;
    }

    public ModelWindow getCurrentCanvas() {
        return (ModelWindow)this.tabbedEditorPanel.getSelectedComponent();
    }

    public JPopupMenu createPopupMenu(Point pt, Object cell) {
        JPopupMenu menu = new JPopupMenu();
        menu.setLightWeightPopupEnabled(false);
        if (cell != null && cell instanceof AtomicNode) {
            if (((AtomicNode)((Object)cell)).isAtomic()) {
                menu.add(this.getEditAtomicMenuItem());
            }
            menu.add(this.getAddIPortMenuItem());
            menu.add(this.getAddOPortMenuItem());
            menu.addSeparator();
        }
        if (!this.getCurrentCanvas().getGraph().isSelectionEmpty()) {
            menu.add(this.getRemoveMenuItem());
            menu.add(this.getCopyMenuItem());
            menu.add(this.getCutMenuItem());
        } else {
            menu.add(this.getPasteMenuItem());
        }
        menu.addSeparator();
        menu.add(this.getCloseMenuItem());
        return menu;
    }

    public JPopupMenu createPopupMenu(Point point) {
        JPopupMenu menu = new JPopupMenu();
        menu.setLightWeightPopupEnabled(false);
        menu.add(this.getCloseMenuItem());
        return menu;
    }

    public void editAtomicWindow() {
        VElementSimMod editorWindow = new VElementSimMod(this);
        editorWindow.setVisible(true);
        editorWindow.toFront();
    }

    public void addLibrary(File file) {
        try {
            this.libraryPane.addLibrary(file);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

