/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.math;

import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class SingleInputSampler
extends AtomicImpl {
    public static final String in = "in";
    public static final String out = "out";
    protected double h;
    protected double output;
    private int debug = 1;
    private double tiempo = 0.0;

    public SingleInputSampler(String name, double h) {
        super(name);
        this.h = h;
        this.addInport(in);
        this.addOutport(out);
        super.setSigma(Double.POSITIVE_INFINITY);
        super.setPhase("initial");
    }

    public double ta(double t) {
        return super.getSigma();
    }

    public void deltext(double e, Message x) {
        this.output = (Double)x.getValuesOnPort(in).iterator().next();
        if (super.getPhase() == "initial") {
            super.setSigma(0.0);
            super.setPhase("transitory");
            return;
        }
        super.setPhase("new");
        if (this.debug == 1) {
            System.out.println("SAMPLER deltext t: " + this.tiempo + " y: " + this.output + " s: " + this.ta() + " " + super.getPhase());
        }
    }

    public void deltint() {
        super.setSigma(this.h);
        super.setPhase("old");
        if (this.debug == 1) {
            this.tiempo += this.h;
            System.out.println("SAMPLER deltin  tnext: " + this.tiempo + " output: " + this.output + " " + super.getPhase());
        }
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        msg.add(out, this.output);
        if (this.debug == 1) {
            System.out.println("SAMPLER lambda t: " + this.tiempo + " y: " + this.output + " " + super.getPhase() + " s: " + this.ta());
        }
        return msg;
    }

    public void deltcon(double e, Message x) {
        this.deltext(e, x);
        this.deltint();
    }
}

