/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.sinks;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.api.Message;

public class Disk
extends AtomicImpl {
    public static final String in = "in";
    protected Writer file;
    protected double time;

    public Disk(String name, String fileName, double t0) {
        super(name);
        this.addInport(in);
        try {
            this.file = new BufferedWriter(new FileWriter(fileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.time = t0;
        super.passivate();
    }

    public Disk(String name, String fileName) {
        this(name, fileName, 0.0);
    }

    public void deltint() {
        super.setSigma(Double.POSITIVE_INFINITY);
    }

    public void deltext(double e, Message x) {
        this.time += e;
        Collection<Object> values = x.getValuesOnPort(in);
        if (values.isEmpty()) {
            return;
        }
        StringBuffer line = new StringBuffer();
        line.append(this.time);
        for (Object value : values) {
            line.append("\t" + value.toString());
        }
        try {
            this.file.write(line.toString() + "\n");
            this.file.flush();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public Message lambda() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.file.flush();
            this.file.close();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            super.finalize();
        }
    }
}

