/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.aviones;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import javax.media.opengl.GL;
import proyectoSI.grafico.Dibujable;
import proyectoSI.grafico.ModeloAvion;
import proyectoSI.grafico.Seguible;
import proyectoSI.grafico.estructura.PV3D;
import proyectoSI.grafico.estructura.TAfin;
import proyectoSI.grafico.estructura.terreno.Terreno;
import proyectoSI.matematico.IFuncion;
import proyectoSI.matematico.IIntegrador;
import proyectoSI.matematico.RungeKutta;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvionState
extends AtomicStateImpl
implements IFuncion,
Dibujable,
Seguible {
    public static final String InSolicitud1 = "INsolicitud1";
    public static final String InSolicitud2 = "INsolicitud2";
    public static final String OutPosicion = "OUTposicion";
    public static final String OutVelocidad = "OUTVelocidad";
    public static final String OutAngulos = "OUTAngulos";
    public static final String OutFuel = "OUTFuel";
    public static final String OutEstado = "OUTEstado";
    public static final String OutTodo = "OUTTodo";
    public static final String controlador = "controlador";
    public static final String OutActualizados = "OUTActualizados";
    public static final String tactual = "tactual";
    public static final String iniciarControlador = "iniciarControlador";
    public static final int PARADA = 0;
    public static final int RUNNING = 1;
    public static final int DESTRUIDO = -1;
    public static final int Reset = 331;
    public static final int CambiarVelocidad = 332;
    public static final int CambiarAnguloPhi = 333;
    public static final int CambiarAltura = 334;
    public static final int PonerFuel = 335;
    public static final int IniciarSimulacion = 336;
    public static final int FinSimulacion = 337;
    public static final int DestruirAvion = 338;
    public static final int GetPosicion = 339;
    public static final int GetVelocidad = 3310;
    public static final int GetAngulos = 3311;
    public static final int GetFuel = 3312;
    public static final int GetEstado = 3313;
    public static final int GetActualizados = 3314;
    public static final double g = 9.8;
    private static final String phase = "Phase";
    private static final String pn = "Pn";
    private static final String pe = "Pe";
    private static final String ph = "Ph";
    private static final String v = "V";
    private static final String vh = "vh";
    private static final String alabeo = "alabeo";
    private static final String cabeceo = "cabeceo";
    private static final String rumbo = "rumbo";
    private static final String kp = "kp";
    private static final String dt = "dt";
    private static final String dtRestante = "dtRestante";
    private static final String fuel = "Fuel";
    private static final String vReferencia = "vReferencia";
    private static final String hck = "hck";
    private static final String solicitudPosicion = "solicitudPosicion";
    private static final String solicitudVelocidad = "solicitudVelocidad";
    private static final String solicitudAngulos = "solicitudAngulos";
    private static final String solicitudFuel = "solicitudFuel";
    private static final String solicitudEstado = "solicitudEstado";
    private static final String solicitudActualizados = "solicitudActualizados";
    private static final int cierto = 1;
    private static final int falso = 0;
    private IIntegrador integrador = new RungeKutta();
    private ModeloAvion _modeloAvion;
    private Terreno _terreno;

    public AvionState(String name, double kp, Terreno terreno) {
        super(name);
        this.addInport(InSolicitud1);
        this.addInport(InSolicitud2);
        this.addOutport(OutPosicion);
        this.addOutport(controlador);
        this.addOutport(OutVelocidad);
        this.addOutport(OutAngulos);
        this.addOutport(OutFuel);
        this.addOutport(OutEstado);
        this.addOutport(OutTodo);
        this.addInport(InSolicitud1);
        this.addInport(InSolicitud2);
        this.addOutport(OutActualizados);
        this.addState(phase);
        this.addState(kp);
        this.addState(dt);
        this.addState(iniciarControlador);
        this.addState(dtRestante);
        this.addState(tactual);
        this.addState(fuel);
        this.addState(vReferencia);
        this.addState(hck);
        this.addState(solicitudPosicion);
        this.addState(solicitudVelocidad);
        this.addState(solicitudAngulos);
        this.addState(solicitudFuel);
        this.addState(solicitudEstado);
        this.addState(solicitudActualizados);
        this.addState(pn);
        this.addState(pe);
        this.addState(ph);
        this.addState(v);
        this.addState(alabeo);
        this.addState(cabeceo);
        this.addState(rumbo);
        this.setStateValue(phase, 0);
        this.setStateValue(solicitudPosicion, 0);
        this.setStateValue(solicitudVelocidad, 0);
        this.setStateValue(solicitudAngulos, 0);
        this.setStateValue(solicitudFuel, 0);
        this.setStateValue(solicitudEstado, 0);
        this.setStateValue(solicitudActualizados, 0);
        this.setStateValue(kp, kp);
        this.setStateValue(tactual, 0);
        this.setStateValue(iniciarControlador, 0);
        this.setStateValue("pn", 0);
        this.setStateValue("pe", 0);
        this.setStateValue("ph", 0);
        this.setStateValue(vh, 0);
        this.setStateValue(alabeo, 0);
        this.setStateValue(cabeceo, 0);
        this.setStateValue(rumbo, 0);
        this.setStateValue("v", 100);
        this.setSigma(Double.POSITIVE_INFINITY);
        this._terreno = terreno;
    }

    @Override
    public void deltext(double arg0, Message arg1) {
        if (this.getStateValue(phase).intValue() != -1) {
            Vector<Double> vel;
            Vector<Double> pos;
            Vector solicitud;
            Iterator<Object> iteradorSolicitud1 = arg1.getValuesOnPort(InSolicitud1).iterator();
            Iterator<Object> iteradorSolicitud2 = arg1.getValuesOnPort(InSolicitud2).iterator();
            while (iteradorSolicitud1.hasNext()) {
                solicitud = (Vector)iteradorSolicitud1.next();
                switch ((Integer)solicitud.get(0)) {
                    case 331: {
                        if (solicitud.size() == 8) {
                            if ((Integer)solicitud.get(7) != Integer.parseInt(this.getName())) break;
                            pos = new Vector();
                            pos.add((Double)solicitud.get(1));
                            pos.add((Double)solicitud.get(2));
                            pos.add((Double)solicitud.get(3));
                            vel = new Vector();
                            vel.add((Double)solicitud.get(4));
                            vel.add((Double)solicitud.get(5));
                            vel.add((Double)solicitud.get(6));
                            this.reset(pos, vel);
                            break;
                        }
                        pos = new Vector();
                        pos.add((Double)solicitud.get(1));
                        pos.add((Double)solicitud.get(2));
                        pos.add((Double)solicitud.get(3));
                        vel = new Vector();
                        vel.add((Double)solicitud.get(4));
                        vel.add((Double)solicitud.get(5));
                        vel.add((Double)solicitud.get(6));
                        this.reset(pos, vel);
                        break;
                    }
                    case 332: {
                        this.cambiarVelocidad((Double)solicitud.get(1));
                        break;
                    }
                    case 333: {
                        this.cambiarAnguloPhi((Double)solicitud.get(1));
                        break;
                    }
                    case 334: {
                        this.cambiarAltura((Double)solicitud.get(1));
                        break;
                    }
                    case 335: {
                        this.ponerFuel((Double)solicitud.get(1));
                        break;
                    }
                    case 336: {
                        this.iniciarSimulacion((Double)solicitud.get(1));
                        break;
                    }
                    case 337: {
                        this.finSimulacion();
                        break;
                    }
                    case 338: {
                        this.destruirAvion();
                        break;
                    }
                    case 339: {
                        this.getPosicion();
                        break;
                    }
                    case 3310: {
                        this.getVelocidad();
                        break;
                    }
                    case 3311: {
                        this.getAngulos();
                        break;
                    }
                    case 3312: {
                        this.getFuel();
                        break;
                    }
                    case 3313: {
                        this.getEstado();
                        break;
                    }
                    case 3314: {
                        this.getActualizados();
                    }
                }
            }
            while (iteradorSolicitud2.hasNext()) {
                solicitud = (Vector)iteradorSolicitud2.next();
                switch ((Integer)solicitud.get(0)) {
                    case 331: {
                        pos = new Vector<Double>();
                        pos.add((Double)solicitud.get(1));
                        pos.add((Double)solicitud.get(2));
                        pos.add((Double)solicitud.get(3));
                        vel = new Vector<Double>();
                        vel.add((Double)solicitud.get(4));
                        vel.add((Double)solicitud.get(5));
                        vel.add((Double)solicitud.get(6));
                        this.reset(pos, vel);
                        break;
                    }
                    case 332: {
                        this.cambiarVelocidad((Double)solicitud.get(1));
                        break;
                    }
                    case 333: {
                        this.cambiarAnguloPhi((Double)solicitud.get(1));
                        break;
                    }
                    case 334: {
                        this.cambiarAltura((Double)solicitud.get(1));
                        break;
                    }
                    case 335: {
                        this.ponerFuel((Double)solicitud.get(1));
                        break;
                    }
                    case 336: {
                        this.iniciarSimulacion((Double)solicitud.get(1));
                        break;
                    }
                    case 337: {
                        this.finSimulacion();
                        break;
                    }
                    case 338: {
                        this.destruirAvion();
                        break;
                    }
                    case 339: {
                        this.getPosicion();
                        break;
                    }
                    case 3310: {
                        this.getVelocidad();
                        break;
                    }
                    case 3311: {
                        this.getAngulos();
                        break;
                    }
                    case 3312: {
                        this.getFuel();
                        break;
                    }
                    case 3313: {
                        this.getEstado();
                    }
                }
            }
        }
    }

    private void reset(Vector<Double> posicion, Vector<Double> velocidad) {
        if (this.getStateValue(phase).intValue() == 0) {
            this.setStateValue("pn", (double)posicion.get(0));
            this.setStateValue("pe", (double)posicion.get(1));
            this.setStateValue("ph", (double)posicion.get(2));
            this.setStateValue("v", (double)velocidad.get(0));
            this.setStateValue(hck, (double)posicion.get(2));
            this.setStateValue(vReferencia, AvionState.modulo(velocidad));
            this.setStateValue(cabeceo, Math.asin(velocidad.get(2) / velocidad.get(0)));
            this.setStateValue(rumbo, Math.acos(velocidad.get(1) / AvionState.modulo(velocidad)));
            this.setSigma(0.0);
        }
    }

    private void cambiarVelocidad(double vReferenciaValue) {
        this.setStateValue(vReferencia, vReferenciaValue);
    }

    private void cambiarAnguloPhi(double phi) {
        this.setStateValue(alabeo, phi);
    }

    private void cambiarAltura(double altura) {
        this.setStateValue(hck, altura);
    }

    private void ponerFuel(double fuelValue) {
        this.setStateValue(fuel, fuelValue);
    }

    private void iniciarSimulacion(double dtValue) {
        this.setStateValue(dt, dtValue);
        this.setStateValue(phase, 1);
        this.setStateValue(iniciarControlador, 1);
        this.setSigma(dtValue);
    }

    private void finSimulacion() {
        this.setStateValue(phase, 0);
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    private void destruirAvion() {
        this.setStateValue(phase, -1);
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    private void getPosicion() {
        this.setStateValue(solicitudPosicion, 1);
        this.setStateValue(dtRestante, this.getSigma());
        this.setSigma(0.0);
    }

    private void getVelocidad() {
        this.setStateValue(solicitudVelocidad, 1);
        this.setStateValue(dtRestante, this.getSigma());
        this.setSigma(0.0);
    }

    private void getAngulos() {
        this.setStateValue(solicitudAngulos, 1);
        this.setStateValue(dtRestante, this.getSigma());
        this.setSigma(0.0);
    }

    private void getFuel() {
        this.setStateValue(solicitudFuel, 1);
        this.setStateValue(dtRestante, this.getSigma());
        this.setSigma(0.0);
    }

    private void getEstado() {
        this.setStateValue(solicitudEstado, 1);
        this.setStateValue(dtRestante, this.getSigma());
        this.setSigma(0.0);
    }

    private void getActualizados() {
        this.setStateValue(solicitudActualizados, 1);
        this.setStateValue(dtRestante, this.getSigma());
        this.setSigma(0.0);
    }

    public static double modulo(Vector<Double> datos) {
        double suma = 0.0;
        for (int i = 0; i < datos.size(); ++i) {
            suma += datos.get(i) * datos.get(i);
        }
        return Math.sqrt(suma);
    }

    public void imprimeEstado() {
        System.out.println("AVIONSTATE pe " + this.getStateValue("pe").doubleValue() + "pn " + this.getStateValue("pn").doubleValue() + "ph " + this.getStateValue("ph").doubleValue() + "alabeo " + this.getStateValue(alabeo).doubleValue() + "cabeceo " + this.getStateValue(cabeceo).doubleValue() + "rumbo " + this.getStateValue(rumbo).doubleValue() + "v " + this.getStateValue("v").doubleValue());
    }

    @Override
    public void deltint() {
        if (this.getStateValue(solicitudPosicion).intValue() == 1 || this.getStateValue(solicitudVelocidad).intValue() == 1 || this.getStateValue(solicitudAngulos).intValue() == 1 || this.getStateValue(solicitudFuel).intValue() == 1 || this.getStateValue(solicitudEstado).intValue() == 1 || this.getStateValue(solicitudActualizados).intValue() == 1) {
            this.setStateValue(solicitudPosicion, 0);
            this.setStateValue(solicitudVelocidad, 0);
            this.setStateValue(solicitudAngulos, 0);
            this.setStateValue(solicitudFuel, 0);
            this.setStateValue(solicitudEstado, 0);
            this.setStateValue(solicitudActualizados, 0);
            if (this.getStateValue(phase).intValue() == 0) {
                this.setSigma(Double.POSITIVE_INFINITY);
            } else {
                this.setSigma(this.getStateValue(dtRestante).doubleValue());
            }
        } else if (this.getStateValue(phase).intValue() == 1) {
            this.setSigma(this.getStateValue(dt).doubleValue());
        } else {
            this.setSigma(Double.POSITIVE_INFINITY);
        }
    }

    @Override
    public Message lambda() {
        this.avanzaTiempo();
        MessageImpl msg = new MessageImpl();
        if (this.getStateValue(iniciarControlador).doubleValue() == 1.0) {
            Vector<Integer> iniciar = new Vector<Integer>();
            iniciar.add(3234);
            this.setStateValue(iniciarControlador, 0);
            msg.add(controlador, iniciar);
        }
        Vector<Double> posicion = new Vector<Double>(3, 0);
        posicion.add(new Double(this.getStateValue("pe").doubleValue()));
        posicion.add(new Double(this.getStateValue("pn").doubleValue()));
        posicion.add(new Double(this.getStateValue("ph").doubleValue()));
        Vector<Double> velocidad = new Vector<Double>(3, 0);
        velocidad.add(new Double(this.dameComponentesV(1)));
        velocidad.add(new Double(this.dameComponentesV(2)));
        velocidad.add(new Double(this.dameComponentesV(3)));
        Vector<Number> angulos = new Vector<Number>(3, 0);
        angulos.add(this.getStateValue(alabeo));
        angulos.add(this.getStateValue(cabeceo));
        angulos.add(this.getStateValue(rumbo));
        Vector<Serializable> todo = new Vector<Serializable>();
        todo.add(posicion);
        todo.add(velocidad);
        todo.add(angulos);
        todo.add(Double.valueOf(this.getStateValue(fuel).doubleValue()));
        todo.add(Double.valueOf(this.getStateValue(phase).doubleValue()));
        todo.add(Double.valueOf(this.getStateValue(dt).doubleValue()));
        todo.add(Integer.valueOf(Integer.parseInt(this.getName())));
        msg.add(OutTodo, todo);
        return msg;
    }

    @Override
    public void deltcon(double e, Message x) {
        this.deltint();
        this.deltext(e, x);
    }

    @Override
    public void actualizaEstados(double[] estadosActuales) {
        double h = this.getStateValue(ph).doubleValue();
        double nMax = 5.382E-9 * h * h - 4.4291E-4 * h + 6.1;
        double n = 1.0 / Math.cos(this.getStateValue(alabeo).doubleValue());
        double v = this.getStateValue("v").doubleValue();
        double w = 9.8 * Math.tan(this.getStateValue(alabeo).doubleValue()) / v;
        double vmin = 7.8038E-7 * h * h - 8.2021E-4 * h + 59.0;
        double vmax = -1.0764E-7 * h * h - 8.2021E-4 * h + 335.0;
        double amax = -4.0365E-9 * h * h - 2.0505E-4 * h + 3.8;
        double vmaxs = 1.7403E-11 * h * h * h - 4.8328E-7 * h * h + 0.00317 * h + 93.257;
        double vmaxb = 2.8064E-12 * h * h * h - 2.5433E-7 * h * h + 0.004739 * h - 46.005;
        double phi = this.getStateValue(alabeo).doubleValue();
        if (n > nMax) {
            n = nMax;
        }
        if ((phi = Math.atan(v * (w = 9.8 * Math.signum(w) * Math.sqrt(n * n - 1.0) / v) / 9.8)) > Math.PI) {
            phi -= Math.PI * 2;
        } else if (phi < -Math.PI) {
            phi += Math.PI * 2;
        }
        this.setStateValue(alabeo, phi);
        this.setStateValue("pe", estadosActuales[0]);
        this.setStateValue("pn", estadosActuales[1]);
        this.setStateValue("ph", estadosActuales[2]);
        double estado = estadosActuales[3];
        if (estado > vmaxs) {
            estado = vmaxs;
        } else if (estado < vmaxb) {
            estado = vmaxb;
        }
        this.setStateValue(vh, estado);
        this.setStateValue(rumbo, this.normalizar(estadosActuales[4]));
        estado = estadosActuales[5];
        if (estado > vmax) {
            estado = vmax;
        } else if (estado < vmin) {
            estado = vmin;
        }
        this.setStateValue("v", estado);
    }

    public double normalizar(double angulo) {
        double angulo_normalizado = angulo;
        if (angulo > Math.PI) {
            angulo_normalizado = this.normalizar(angulo - Math.PI * 2);
        }
        if (angulo < -Math.PI) {
            angulo_normalizado = this.normalizar(angulo + Math.PI * 2);
        }
        return angulo_normalizado;
    }

    @Override
    public void avanzaTiempo() {
        double tiempo = this.getStateValue(dt).doubleValue();
        this.actualizaEstados(this.integrador.integra(this, tiempo, this.getStateValue(tactual).doubleValue()));
        this.setStateValue(tactual, this.getStateValue(tactual).doubleValue() + tiempo);
    }

    @Override
    public double[] dameControlActual() {
        return null;
    }

    @Override
    public double[] dameDerivadas(double tiempo, double[] estados, double[] control) {
        double h = this.getStateValue("ph").doubleValue();
        double nMax = 5.382E-9 * h * h - 4.4291E-4 * h + 6.1;
        double n = 1.0 / Math.cos(this.getStateValue(alabeo).doubleValue());
        double v = this.getStateValue("v").doubleValue();
        double w = 9.8 * Math.tan(this.getStateValue(alabeo).doubleValue()) / v;
        double vmin = 7.8038E-7 * h * h - 8.2021E-4 * h + 59.0;
        double vmax = -1.0764E-7 * h * h - 8.2021E-4 * h + 335.0;
        double amax = -4.0365E-9 * h * h - 2.0505E-4 * h + 3.8;
        double vmaxs = 1.7403E-11 * h * h * h - 4.8328E-7 * h * h + 0.00317 * h + 93.257;
        double vmaxb = 2.8064E-12 * h * h * h - 2.5433E-7 * h * h + 0.004739 * h - 46.005;
        double chi = this.getStateValue(rumbo).doubleValue() + this.getStateValue(dt).doubleValue() * w;
        if (chi > Math.PI) {
            chi -= Math.PI * 2;
        } else if (chi < -Math.PI) {
            chi += Math.PI * 2;
        }
        double a1 = 0.76666;
        double a2 = 0.58768;
        double vh = this.getStateValue(vh).doubleValue();
        double hck = this.getStateValue(hck).doubleValue();
        double asmax = -0.0047077 * h + 66.078;
        double abmax = -7.1275E-8 * h * h + 0.0017604 * h - 20.142;
        int num_estados = 6;
        double[] derivadas = new double[num_estados];
        derivadas[0] = v * Math.cos(this.getStateValue(rumbo).doubleValue());
        derivadas[1] = v * Math.sin(this.getStateValue(rumbo).doubleValue());
        derivadas[2] = vh;
        derivadas[3] = -a1 * vh - a2 * (h - hck);
        if (derivadas[3] > asmax) {
            derivadas[3] = asmax;
        } else if (derivadas[3] < abmax) {
            derivadas[3] = abmax;
        }
        derivadas[4] = w;
        double vr = this.getStateValue(vReferencia).doubleValue();
        double kp = this.getStateValue(kp).doubleValue();
        derivadas[5] = kp * (vr - v);
        if (this.absoluto(derivadas[5]) > amax) {
            derivadas[5] = this.signo(derivadas[5]) * amax;
        }
        return derivadas;
    }

    public double absoluto(double valor) {
        double retorno = 0.0;
        if (valor > 0.0) {
            retorno = valor;
        }
        if (valor < 0.0) {
            retorno = -valor;
        }
        return retorno;
    }

    public double signo(double valor) {
        double retorno = 0.0;
        if (valor > 0.0) {
            retorno = 1.0;
        }
        if (valor < 0.0) {
            retorno = -1.0;
        }
        return retorno;
    }

    public double dameComponentesV(int tipoComponente) {
        double componente = 0.0;
        double v = this.getStateValue("v").doubleValue();
        double psi = this.getStateValue(rumbo).doubleValue();
        if (tipoComponente == 1) {
            componente = v * Math.cos(psi);
        }
        if (tipoComponente == 2) {
            componente = v * Math.sin(psi);
        }
        if (tipoComponente == 3) {
            componente = this.getStateValue(vh).doubleValue();
        }
        return componente;
    }

    public double dameTheta() {
        return Math.asin(this.getStateValue(vh).doubleValue() / this.getStateValue("v").doubleValue());
    }

    @Override
    public double[] dameEstadoActual() {
        int num_estados = 6;
        double[] estados = new double[num_estados];
        estados[0] = this.getStateValue("pe").doubleValue();
        estados[1] = this.getStateValue("pn").doubleValue();
        estados[2] = this.getStateValue("ph").doubleValue();
        estados[3] = this.getStateValue(vh).doubleValue();
        estados[4] = this.getStateValue(rumbo).doubleValue();
        estados[5] = this.getStateValue("v").doubleValue();
        return estados;
    }

    @Override
    public void dibujar2D(GL gl) {
        this._modeloAvion.dibujar2D(this.getStateValue("pn").floatValue(), this.getStateValue("pe").floatValue(), gl);
    }

    @Override
    public void dibujar3D(GL gl) {
        this._modeloAvion = new ModeloAvion(gl, this._terreno);
        TAfin angulos = new TAfin();
        gl.glPushMatrix();
        gl.glMultMatrixf(angulos.getMatriz(), 0);
        this._modeloAvion.getTafin().escalar(100.0f, 100.0f, 100.0f, gl);
        this._modeloAvion.posicionar(this.getStateValue("pn").floatValue() / 100000.0f * 100.0f, this.getStateValue("ph").floatValue() / 100.0f, this.getStateValue("pe").floatValue() / 100000.0f * 100.0f, gl);
        this._modeloAvion.dibujar3D(gl);
        gl.glPopMatrix();
    }

    @Override
    public void inicializar(GL gl) {
        this._modeloAvion = new ModeloAvion(gl, this._terreno);
        this._modeloAvion.getTafin().escalar(100.0f, 100.0f, 100.0f, gl);
    }

    @Override
    public PV3D obtenerPosicion() {
        PV3D posicion = new PV3D(this.getStateValue("pn").floatValue(), this.getStateValue("ph").floatValue(), this.getStateValue("pe").floatValue());
        return posicion;
    }

    @Override
    public float obtenerRumbo() {
        return this.getStateValue(rumbo).floatValue() * 360.0f / ((float)Math.PI * 2);
    }

    @Override
    public int devolverTipoSeguible() {
        return 1;
    }
}

