/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.aviones;

import java.util.Iterator;
import java.util.Vector;
import proyectoSI.matematico.IFuncion;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControladorRumboState
extends AtomicStateImpl
implements IFuncion {
    private static final String racha = "racha";
    private static final String phase = "phase";
    public static final int NO_INICIADO = 1;
    public static final int INICIADO = 2;
    public static final int DESTRUIDO = 3;
    private static final String tiempoRumbo = "tiempoRumbo";
    private static final String activo = "activo";
    private static final String pon = "pon";
    private static final String poe = "poe";
    private static final String poh = "poh";
    private static final String pn = "pn";
    private static final String pe = "pe";
    private static final String ph = "ph";
    private static final String vn = "vn";
    private static final String ve = "ve";
    private static final String vh = "vh";
    private static final String Xi = "Xi";
    private static final String phi = "phi";
    private static final String temporizador = "temporizador";
    private Message _msg;
    private static final double wn = 0.5;
    protected static final String Inicializar = "Inicializar";
    protected static final String InPosRef = "INPosRef";
    protected static final String InPosRefCon = "INPosRefCon";
    protected static final String InAvion = "INAvion";
    protected static final String OutPeticion = "OUTPeticion";
    protected static final String PeticionPunto = "PeticionPunto";
    public static final int CamPosRef = 1100;
    public static final int CamPosRefRut = 2100;
    public static final int Iniciar = 3234;
    public static final int Destruir = 4234;

    public ControladorRumboState(String nombre) {
        super(nombre);
        this.addInport(InAvion);
        this.addInport(Inicializar);
        this.addInport(InPosRef);
        this.addInport(InPosRefCon);
        this.addOutport(OutPeticion);
        this.addOutport(PeticionPunto);
        this.addState(pon);
        this.addState(poe);
        this.addState(poh);
        this.addState(pn);
        this.addState(pe);
        this.addState(ph);
        this.addState(vn);
        this.addState(ve);
        this.addState(vh);
        this.addState(Xi);
        this.addState(temporizador);
        this.addState(phi);
        this.addState(activo);
        this.addState(racha);
        this.addState(tiempoRumbo);
        this.setStateValue(activo, 0);
        this.setStateValue(temporizador, 0);
        this.setStateValue(racha, Double.NEGATIVE_INFINITY);
        this.setStateValue(phase, 1);
        this.setSigma(Double.POSITIVE_INFINITY);
        this._msg = new MessageImpl();
    }

    @Override
    public void deltext(double arg0, Message arg1) {
        double altura;
        Vector<Number> a;
        double dpn;
        double dpon;
        double dpe;
        double Xi;
        for (Vector vector : arg1.getValuesOnPort(Inicializar)) {
            this.setStateValue(phase, 2);
            this.setStateValue(racha, -100);
            this.setStateValue(temporizador, -100);
            this.setSigma(0.0);
        }
        for (Vector vector : arg1.getValuesOnPort(InPosRef)) {
            if ((vector == null || vector.size() >= 5) && (vector.size() != 5 || (Integer)vector.get(4) != Integer.parseInt(this.getName()))) continue;
            switch ((Integer)vector.get(0)) {
                case 1100: {
                    double valor_temporizador;
                    double den_tempo;
                    double num_tempo;
                    double r22;
                    double r2;
                    double r12;
                    double r1;
                    double vn;
                    double vh;
                    double ve;
                    double dpoe;
                    Xi = 0.0;
                    if (this.getStateValue(activo).doubleValue() == 0.0) {
                        dpoe = (Double)vector.get(1);
                        dpe = this.getStateValue(pe).doubleValue();
                        dpon = (Double)vector.get(2);
                        dpn = this.getStateValue(pn).doubleValue();
                        if (dpoe != Double.MAX_VALUE) {
                            ve = this.getStateValue(ve).doubleValue();
                            vh = this.getStateValue(vh).doubleValue();
                            vn = this.getStateValue(vn).doubleValue();
                            r1 = dpoe - this.getStateValue(pe).doubleValue();
                            r12 = r1 * r1;
                            r2 = dpon - this.getStateValue(pn).doubleValue();
                            r22 = r2 * r2;
                            num_tempo = Math.sqrt(r12 + r22);
                            den_tempo = Math.sqrt(ve * ve + vn * vn) / 10.0;
                            valor_temporizador = num_tempo / den_tempo;
                            this.setStateValue(temporizador, valor_temporizador);
                            Xi = Math.atan2(dpon - dpn, dpoe - dpe);
                            this.setStateValue(Xi, Xi);
                        }
                        this.setStateValue(activo, 1);
                    } else {
                        dpoe = (Double)vector.get(1);
                        dpe = this.getStateValue(pe).doubleValue();
                        dpon = (Double)vector.get(2);
                        if (dpon != Double.MAX_VALUE) {
                            dpn = this.getStateValue(pn).doubleValue();
                            ve = this.getStateValue(ve).doubleValue();
                            vh = this.getStateValue(vh).doubleValue();
                            vn = this.getStateValue(vn).doubleValue();
                            r1 = dpoe - this.getStateValue(pe).doubleValue();
                            r12 = r1 * r1;
                            r2 = dpon - this.getStateValue(pn).doubleValue();
                            r22 = r2 * r2;
                            num_tempo = Math.sqrt(r12 + r22);
                            den_tempo = Math.sqrt(ve * ve + vn * vn) / 10.0;
                            valor_temporizador = num_tempo / den_tempo;
                            this.setStateValue(temporizador, valor_temporizador);
                            Xi = Math.atan2(dpon - dpn, dpoe - dpe);
                            this.setStateValue(Xi, Xi);
                        }
                    }
                    if ((Double)vector.get(2) != Double.MAX_VALUE) {
                        this.setStateValue(pon, (double)((Double)vector.get(2)));
                        this.setStateValue(poe, (double)((Double)vector.get(1)));
                        this.setStateValue(poh, (double)((Double)vector.get(3)));
                    }
                    a = new Vector<Number>();
                    altura = this.getStateValue(poh).doubleValue();
                    a.add(new Integer(334));
                    a.add(altura);
                    this._msg.add(OutPeticion, a);
                }
            }
        }
        for (Vector vector : arg1.getValuesOnPort(InPosRefCon)) {
            switch ((Integer)vector.get(0)) {
                case 2100: {
                    double dpoe;
                    Xi = 0.0;
                    if (this.getStateValue(activo).doubleValue() == 0.0) {
                        dpoe = (Double)vector.get(1);
                        dpe = this.getStateValue(pe).doubleValue();
                        dpon = (Double)vector.get(2);
                        dpn = this.getStateValue(pn).doubleValue();
                        Xi = Math.atan2(dpon - dpn, dpoe - dpe);
                        this.setStateValue(Xi, Xi);
                        Xi = Math.PI - Xi;
                        this.setStateValue(activo, 1);
                    } else {
                        dpoe = (Double)vector.get(1);
                        dpe = this.getStateValue(poe).doubleValue();
                        dpon = (Double)vector.get(2);
                        dpn = this.getStateValue(pon).doubleValue();
                        Xi = Math.atan2(dpon - dpn, dpoe - dpe);
                        Xi = Math.PI - Xi;
                        this.setStateValue(Xi, Xi);
                    }
                    this.setStateValue(pon, (double)((Double)vector.get(2)));
                    this.setStateValue(poe, (double)((Double)vector.get(1)));
                    this.setStateValue(poh, (double)((Double)vector.get(3)));
                    a = new Vector();
                    altura = this.getStateValue(poh).doubleValue();
                    a.add(new Integer(334));
                    a.add(altura);
                    this._msg.add(OutPeticion, a);
                }
            }
        }
        Iterator<Object> iterator = arg1.getValuesOnPort(InAvion).iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            boolean bl2 = true;
            Vector todo = (Vector)iterator.next();
            double pea = (Double)((Vector)todo.get(0)).get(0);
            double pna = (Double)((Vector)todo.get(0)).get(1);
            double pha = (Double)((Vector)todo.get(0)).get(2);
            double peo = this.getStateValue(poe).doubleValue();
            double pno = this.getStateValue(pon).doubleValue();
            double pho = this.getStateValue(poh).doubleValue();
            double dactual = Math.sqrt((pea - peo) * (pea - peo) + (pna - pno) * (pna - pno));
            if (this.getStateValue(pe) != null) {
                pea = this.getStateValue(pe).doubleValue();
                pna = this.getStateValue(pn).doubleValue();
                pha = this.getStateValue(ph).doubleValue();
                double dantigua = Math.sqrt((pea - peo) * (pea - peo) + (pna - pno) * (pna - pno));
                double ve = this.getStateValue(ve).doubleValue();
                double vh = this.getStateValue(vh).doubleValue();
                double vn = this.getStateValue(vn).doubleValue();
                double distancia_recorrible = Math.sqrt(ve * ve + vn * vn);
                if (dantigua + 0.03 * Math.sqrt(ve * ve + vn * vn) < dactual) {
                    this.setStateValue(racha, this.getStateValue(racha).doubleValue() - 1.0);
                } else {
                    this.setStateValue(racha, 0);
                }
            }
            this.setStateValue(ve, (Number)((Vector)todo.get(1)).get(0));
            this.setStateValue(vn, (Number)((Vector)todo.get(1)).get(1));
            this.setStateValue(vh, (Number)((Vector)todo.get(1)).get(2));
            this.setStateValue(pe, (Number)((Vector)todo.get(0)).get(0));
            this.setStateValue(pn, (Number)((Vector)todo.get(0)).get(1));
            this.setStateValue(ph, (Number)((Vector)todo.get(0)).get(2));
            this.setSigma(0.0);
        }
    }

    @Override
    public void deltcon(double e, Message x) {
        this.deltint();
        this.deltext(e, x);
    }

    public void imprimeEstado() {
        System.out.println("racha " + this.getStateValue(racha).doubleValue() + "temporizador " + this.getStateValue(temporizador).doubleValue() + phase + this.getStateValue(phase).doubleValue() + "activo " + this.getStateValue(activo).doubleValue() + poe + this.getStateValue(poe).doubleValue() + pon + this.getStateValue(pon).doubleValue() + pe + this.getStateValue(pe).doubleValue() + pn + this.getStateValue(pn).doubleValue());
    }

    @Override
    public void deltint() {
        this._msg = new MessageImpl();
        this.controlUAV();
        this.setStateValue(temporizador, this.getStateValue(temporizador).doubleValue() - 1.0);
        if (this.getStateValue(phase).intValue() == 2 && (this.getStateValue(racha).doubleValue() < -1.0 && this.getStateValue(temporizador).doubleValue() < 0.0 || this.getStateValue(racha).doubleValue() < -20.0)) {
            Vector<Integer> solicitud = new Vector<Integer>();
            solicitud.add(new Integer(4));
            solicitud.add(new Integer(Integer.parseInt(this.getName())));
            this._msg.add(PeticionPunto, solicitud);
            this.setStateValue(racha, 10);
        }
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    @Override
    public Message lambda() {
        return this._msg;
    }

    public void controlUAV() {
        if (this.getStateValue(activo).intValue() == 1) {
            Vector<Double> aux = new Vector<Double>(2, 0);
            aux.add(new Double(this.getStateValue(pe).doubleValue() - this.getStateValue(poe).doubleValue()));
            aux.add(new Double(this.getStateValue(pn).doubleValue() - this.getStateValue(pon).doubleValue()));
            Vector<Double> pn = this.transformarEjes(this.getStateValue(Xi).doubleValue(), aux);
            aux = new Vector(2, 0);
            aux.add(this.getStateValue(ve).doubleValue());
            aux.add(this.getStateValue(vn).doubleValue());
            Vector<Double> vn = this.transformarEjes(this.getStateValue(Xi).doubleValue(), aux);
            double eta2 = Math.atan2(vn.get(1), vn.get(0));
            double va = Math.sqrt(this.getStateValue(ve).doubleValue() * this.getStateValue(ve).doubleValue() + this.getStateValue(vn).doubleValue() * this.getStateValue(vn).doubleValue());
            double l = Math.sqrt(2.0) * va / 0.5;
            double y = pn.get(1);
            double eta1 = Math.atan(y / l);
            double eta = -(eta1 + eta2);
            double w = 2.0 * va / l * Math.sin(eta);
            double nmax = this.nmaxcarga(this.getStateValue(ph).doubleValue());
            double wmax = 9.8 * Math.sqrt(nmax * nmax - 1.0) / va;
            double wmin = 0.0;
            if (Math.abs(eta2) >= 1.5707963267948966) {
                w = Math.signum(eta) * wmax;
            }
            if (Math.abs(w) > wmax) {
                w = Math.signum(eta) * wmax;
            }
            if (Math.abs(w) < wmin) {
                w = 0.0;
            }
            double phiValue = 0.0;
            phiValue = Math.atan(va * w / 9.8);
            this.setStateValue(phi, phiValue);
            Vector<Number> solicitud = new Vector<Number>(2, 0);
            solicitud.add(new Integer(333));
            solicitud.add(new Double(phiValue));
            this._msg.add(OutPeticion, solicitud);
        }
    }

    public Vector<Double> transformarEjes(double xi, Vector<Double> punto) {
        Vector<Double> resultado = new Vector<Double>(2, 0);
        Vector<Double> t = new Vector<Double>(4, 0);
        t.add(new Double(Math.cos(xi)));
        t.add(new Double(Math.sin(xi)));
        t.add(new Double(-Math.sin(xi)));
        t.add(new Double(Math.cos(xi)));
        resultado.add(new Double((Double)t.get(0) * punto.get(0) + (Double)t.get(1) * punto.get(1)));
        resultado.add(new Double((Double)t.get(2) * punto.get(0) + (Double)t.get(3) * punto.get(1)));
        return resultado;
    }

    public double nmaxcarga(double h) {
        double nMax = 5.382E-9 * h * h - 4.4291E-4 * h + 6.1;
        return nMax;
    }

    @Override
    public void actualizaEstados(double[] estadosActuales) {
    }

    @Override
    public void avanzaTiempo() {
    }

    @Override
    public double[] dameControlActual() {
        return null;
    }

    @Override
    public double[] dameDerivadas(double tiempo, double[] estados, double[] control) {
        return null;
    }

    @Override
    public double[] dameEstadoActual() {
        return null;
    }
}

