/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.barcos;

import java.util.Iterator;
import java.util.Vector;
import javax.media.opengl.GL;
import proyectoSI.grafico.Dibujable;
import proyectoSI.grafico.ModeloBarco;
import proyectoSI.grafico.Seguible;
import proyectoSI.grafico.estructura.PV3D;
import proyectoSI.grafico.estructura.terreno.Terreno;
import proyectoSI.matematico.IFuncion;
import proyectoSI.matematico.IIntegrador;
import proyectoSI.matematico.RungeKutta;
import proyectoSI.utilControl.mlved;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarcoState
extends AtomicStateImpl
implements IFuncion,
Dibujable,
Seguible {
    public static final String InSolicitud1 = "INsolicitud1";
    public static final String InSolicitud2 = "INsolicitud2";
    public static final String OutPosicion = "OUTposicion";
    public static final String OutVelocidad = "OUTVelocidad";
    public static final String OutAngulos = "OUTAngulos";
    public static final String OutFuel = "OUTFuel";
    public static final String OutEstado = "OUTEstado";
    public static final String OutTodo = "OUTTodo";
    public static final String OutActualizados = "OUTActualizados";
    public static final int PARADA = 0;
    public static final int RUNNING = 1;
    public static final int DESTRUIDO = -1;
    public static final int Mariner = 1;
    public static final int Petrolero = 2;
    public static final int Reset = 1;
    public static final int CambiarAnguloTimon = 2;
    public static final int CambiarVelocidad = 3;
    public static final int PonerFuel = 4;
    public static final int IniciarSimulacion = 5;
    public static final int FinSimulacion = 6;
    public static final int DestruirBarco = 7;
    public static final int GetPosicion = 8;
    public static final int GetVelocidad = 9;
    public static final int GetAngulos = 10;
    public static final int GetFuel = 11;
    public static final int GetEstado = 12;
    public static final int GetActualizados = 13;
    public static final double g = 9.8;
    private static final String solicitudActualizados = "solicitudActualizados";
    private static final String phase = "Phase";
    public static final String dt = "dt";
    public static final String tactual = "tactual";
    public static final String x1 = "x1";
    public static final String x2 = "x2";
    public static final String x3 = "x3";
    public static final String x4 = "x4";
    public static final String x = "x";
    public static final String y = "y";
    public static final String vx = "vx";
    public static final String vy = "vy";
    public static final String T1 = "T1";
    public static final String T2 = "T2";
    public static final String T3 = "T3";
    public static final String K = "K";
    public static final String longitud = "longitud";
    public static final String U = "U";
    public static final String u = "u";
    public static final String v = "v";
    public static final String timon_obj = "timon_obj";
    private static final int cierto = 1;
    private static final int falso = 0;
    private IIntegrador integrador = new RungeKutta();
    private mlved ecuacionDif;
    private Terreno _terreno;
    private ModeloBarco _modeloBarco;

    public BarcoState(String name, double kp, Terreno terreno) {
        super(name);
        this.addInport(InSolicitud1);
        this.addInport(InSolicitud2);
        this.addOutport(OutPosicion);
        this.addOutport(OutVelocidad);
        this.addOutport(OutAngulos);
        this.addOutport(OutFuel);
        this.addOutport(OutEstado);
        this.addOutport(OutTodo);
        this.addOutport(OutActualizados);
        this.addState(phase);
        this.addState(dt);
        this.addState(tactual);
        this.addState(x1);
        this.addState(x2);
        this.addState(x3);
        this.addState(x4);
        this.addState(T1);
        this.addState(T2);
        this.addState(T3);
        this.addState(x);
        this.addState(y);
        this.addState(vx);
        this.addState(vy);
        this.addState(K);
        this.addState(timon_obj);
        this.addState(longitud);
        this.addState(U);
        this.setStateValue(dt, 1);
        this.setStateValue(solicitudActualizados, 0);
        this.setStateValue(x1, 0.0);
        this.setStateValue(x2, 0.0);
        this.setStateValue(x3, 0.0);
        this.setStateValue(x4, 0.0);
        this.setStateValue(x, 0.0);
        this.setStateValue(y, 0.0);
        this.setStateValue(vx, 0.0);
        this.setStateValue(vy, 0.0);
        this.setStateValue(v, 0);
        this.setStateValue(u, 7.7);
        this.setStateValue(timon_obj, 0);
        this.setStateValue(tactual, 0);
        this.ponerValores(1);
        double T1 = this.getStateValue(T1).doubleValue();
        double T2 = this.getStateValue(T2).doubleValue();
        double T3 = this.getStateValue(T3).doubleValue();
        double K = this.getStateValue(K).doubleValue();
        double a1 = (T1 + T2) / (T1 * T2);
        double a2 = 1.0 / (T1 * T2);
        double b1 = K * T3 / (T1 * T2);
        double b2 = K / (T1 * T2);
        double[][] A = new double[][]{{1.8712, -0.8722}, {1.0, 0.0}};
        double[][] B = new double[][]{{0.0625}, {0.0}};
        double[][] C = new double[][]{{0.0571, -0.0541}};
        double[][] D = new double[][]{{0.0}};
        this.ecuacionDif = new mlved(A, B, C, D);
        this._terreno = terreno;
        this.setStateValue(phase, 0);
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    public void ponerValores(int tipoBarco) {
        if (tipoBarco == 1) {
            this.setStateValue(longitud, 161);
            this.setStateValue(U, 7.7);
            this.setStateValue(K, 0.185);
            this.setStateValue(T1, 118.0);
            this.setStateValue(T2, 7.8);
            this.setStateValue(T3, 18.5);
        }
        if (tipoBarco == 2) {
            this.setStateValue(longitud, 350);
            this.setStateValue(U, 8.1);
            this.setStateValue(u, 8.1);
            this.setStateValue(K, -0.019);
            this.setStateValue(T1, -124.1);
            this.setStateValue(T2, 16.4);
            this.setStateValue(T3, 46.0);
        }
    }

    public double normalizar(double angulo) {
        double angulo_normalizado = angulo;
        if (angulo > Math.PI) {
            angulo_normalizado = this.normalizar(angulo - Math.PI * 2);
        }
        if (angulo < -Math.PI) {
            angulo_normalizado = this.normalizar(angulo + Math.PI * 2);
        }
        return angulo_normalizado;
    }

    @Override
    public void deltext(double arg0, Message arg1) {
        if (this.getStateValue(phase).intValue() != -1) {
            Vector<Double> vel;
            Vector<Double> pos;
            Vector solicitud;
            Iterator<Object> iteradorSolicitud1 = arg1.getValuesOnPort(InSolicitud1).iterator();
            Iterator<Object> iteradorSolicitud2 = arg1.getValuesOnPort(InSolicitud2).iterator();
            while (iteradorSolicitud1.hasNext()) {
                solicitud = (Vector)iteradorSolicitud1.next();
                switch ((Integer)solicitud.get(0)) {
                    case 1: {
                        if ((Integer)solicitud.get(5) != Integer.parseInt(this.getName())) break;
                        pos = new Vector();
                        vel = new Vector<Double>();
                        pos.add((Double)solicitud.get(1));
                        pos.add((Double)solicitud.get(2));
                        vel.add((Double)solicitud.get(3));
                        vel.add((Double)solicitud.get(4));
                        this.reset(pos, vel);
                        break;
                    }
                    case 3: {
                        this.cambiarVelocidad((Double)solicitud.get(1));
                        break;
                    }
                    case 2: {
                        this.cambiarAnguloTimon((Double)solicitud.get(1));
                        break;
                    }
                    case 4: {
                        this.ponerFuel((Double)solicitud.get(1));
                        break;
                    }
                    case 5: {
                        this.iniciarSimulacion((Double)solicitud.get(1));
                        break;
                    }
                    case 6: {
                        this.finSimulacion();
                        break;
                    }
                    case 7: {
                        this.destruirBarco();
                        break;
                    }
                    case 8: {
                        this.getPosicion();
                        break;
                    }
                    case 9: {
                        this.getVelocidad();
                        break;
                    }
                    case 10: {
                        this.getAngulos();
                        break;
                    }
                    case 11: {
                        this.getFuel();
                        break;
                    }
                    case 12: {
                        this.getEstado();
                        break;
                    }
                    case 13: {
                        this.getActualizados();
                    }
                }
            }
            while (iteradorSolicitud2.hasNext()) {
                solicitud = (Vector)iteradorSolicitud2.next();
                switch ((Integer)solicitud.get(0)) {
                    case 1: {
                        pos = new Vector<Double>();
                        pos.add((Double)solicitud.get(1));
                        pos.add((Double)solicitud.get(2));
                        vel = new Vector();
                        vel.add((Double)solicitud.get(3));
                        vel.add((Double)solicitud.get(4));
                        vel.add((Double)solicitud.get(5));
                        vel.add((Double)solicitud.get(6));
                        this.reset(pos, vel);
                        break;
                    }
                    case 3: {
                        this.cambiarVelocidad((Double)solicitud.get(1));
                        break;
                    }
                    case 2: {
                        this.cambiarAnguloTimon((Double)solicitud.get(1));
                        break;
                    }
                    case 4: {
                        this.ponerFuel((Double)solicitud.get(1));
                        break;
                    }
                    case 5: {
                        this.iniciarSimulacion((Double)solicitud.get(1));
                        break;
                    }
                    case 6: {
                        this.finSimulacion();
                        break;
                    }
                    case 7: {
                        this.destruirBarco();
                        break;
                    }
                    case 8: {
                        this.getPosicion();
                        break;
                    }
                    case 9: {
                        this.getVelocidad();
                        break;
                    }
                    case 10: {
                        this.getAngulos();
                        break;
                    }
                    case 11: {
                        this.getFuel();
                        break;
                    }
                    case 12: {
                        this.getEstado();
                    }
                }
            }
        }
    }

    private void reset(Vector<Double> posicion, Vector<Double> velocidad) {
        this.setStateValue(x, posicion.get(0));
        this.setStateValue(y, posicion.get(1));
        this.setStateValue(dt, 1);
        this.setStateValue(phase, 1);
        this.setSigma(this.getStateValue(dt).doubleValue());
    }

    private void cambiarVelocidad(double vReferenciaValue) {
    }

    private void cambiarAnguloTimon(double timon) {
        this.setStateValue(timon_obj, this.limitar(-20.0, 20.0, timon));
    }

    private void ponerFuel(double fuelValue) {
    }

    private void iniciarSimulacion(double dtValue) {
        this.setStateValue(dt, dtValue);
        this.setStateValue(phase, 1);
        this.setSigma(dtValue);
    }

    private void finSimulacion() {
        this.setStateValue(phase, 0);
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    private void destruirBarco() {
        this.setStateValue(phase, -1);
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    private void getPosicion() {
    }

    private void getVelocidad() {
    }

    private void getAngulos() {
    }

    private void getFuel() {
    }

    private void getEstado() {
    }

    private void getActualizados() {
    }

    public static double modulo(Vector<Double> datos) {
        double suma = 0.0;
        for (int i = 0; i < datos.size(); ++i) {
            suma += datos.get(i) * datos.get(i);
        }
        return Math.sqrt(suma);
    }

    @Override
    public void deltint() {
        this.avanzaTiempo();
        this.setSigma(this.getStateValue(dt).doubleValue());
    }

    public void imprimeEstado() {
        System.out.println("BARCOSTATE " + this.getName() + "x1 " + this.getStateValue(x1).doubleValue() + "x2 " + this.getStateValue(x2).doubleValue() + "x3 " + this.getStateValue(x3).doubleValue() + "x4 " + this.getStateValue(x4).doubleValue() + "timon_obj " + this.getStateValue(timon_obj).doubleValue() + "x " + this.getStateValue(x).doubleValue() + "y " + this.getStateValue(y).doubleValue() + "vx " + this.getStateValue(vx).doubleValue() + "vy " + this.getStateValue(vy).doubleValue());
    }

    @Override
    public void actualizaEstados(double[] estadosActuales) {
        this.setStateValue(x1, this.normalizar(estadosActuales[0]));
        this.setStateValue(x3, estadosActuales[2]);
        this.setStateValue(x4, estadosActuales[3]);
        this.setStateValue(x, estadosActuales[4]);
        this.setStateValue(y, estadosActuales[5]);
        this.setStateValue(vx, this.getStateValue(u).doubleValue() * Math.cos(this.getStateValue(x1).doubleValue()) - this.getStateValue(v).doubleValue() * Math.sin(this.getStateValue(x1).doubleValue()));
        this.setStateValue(vy, this.getStateValue(u).doubleValue() * Math.sin(this.getStateValue(x1).doubleValue()) + this.getStateValue(v).doubleValue() * Math.cos(this.getStateValue(x1).doubleValue()));
    }

    @Override
    public double[] dameControlActual() {
        return null;
    }

    public double angARad(double valorGrados) {
        return valorGrados / 360.0 * 2.0 * Math.PI;
    }

    public double radAAng(double valorRadianes) {
        return valorRadianes / (Math.PI * 2) * 360.0;
    }

    public double limitar(double valorMinimo, double valorMaximo, double valor) {
        double valorMinimoRadianes = this.angARad(valorMinimo);
        double valorLimitado = valor;
        double valorMaximoRadianes = this.angARad(valorMaximo);
        if (valorLimitado > valorMaximoRadianes) {
            valorLimitado = valorMaximoRadianes;
        }
        if (valorLimitado < valorMinimoRadianes) {
            valorLimitado = valorMinimoRadianes;
        }
        return valorLimitado;
    }

    @Override
    public double[] dameDerivadas(double tiempo, double[] estados, double[] control) {
        double[] derivadas = new double[6];
        derivadas[0] = this.getStateValue(x2).doubleValue();
        derivadas[1] = this.getStateValue(x3).doubleValue();
        derivadas[3] = this.limitar(-5.0, 5.0, this.getStateValue(timon_obj).doubleValue() - this.getStateValue(x4).doubleValue());
        derivadas[2] = -(this.getStateValue(T1).doubleValue() + this.getStateValue(T2).doubleValue()) / (this.getStateValue(T1).doubleValue() * this.getStateValue(T2).doubleValue()) * this.getStateValue(x3).doubleValue() - 1.0 / (this.getStateValue(T1).doubleValue() * this.getStateValue(T2).doubleValue()) * this.getStateValue(x2).doubleValue() + this.getStateValue(K).doubleValue() * (this.getStateValue(T3).doubleValue() * derivadas[3] + this.getStateValue(x4).doubleValue());
        derivadas[4] = this.getStateValue(u).doubleValue() * Math.cos(this.getStateValue(x1).doubleValue()) - this.getStateValue(v).doubleValue() * Math.sin(this.getStateValue(x1).doubleValue());
        derivadas[5] = this.getStateValue(u).doubleValue() * Math.sin(this.getStateValue(x1).doubleValue()) + this.getStateValue(v).doubleValue() * Math.cos(this.getStateValue(x1).doubleValue());
        return derivadas;
    }

    public void imprimeVector(String nombre, double[] vector) {
        System.out.println("COMIENZO " + nombre);
        for (int cont = 0; cont < vector.length; ++cont) {
        }
        System.out.println("FIN" + nombre);
    }

    @Override
    public double[] dameEstadoActual() {
        double[] estado = new double[]{this.getStateValue(x1).doubleValue(), this.getStateValue(x2).doubleValue(), this.getStateValue(x3).doubleValue(), this.getStateValue(x4).doubleValue(), this.getStateValue(x).doubleValue(), this.getStateValue(y).doubleValue()};
        return estado;
    }

    @Override
    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        Vector<Double> posicion = new Vector<Double>(3, 0);
        posicion.add(this.getStateValue(x).doubleValue());
        posicion.add(this.getStateValue(y).doubleValue());
        Vector velocidad = new Vector(3, 0);
        Vector angulos = new Vector(3, 0);
        Vector<Number> estados = new Vector<Number>(6, 0);
        if (this.getStateValue(solicitudActualizados).intValue() == 1) {
            Vector todoActualizado = new Vector(5, 0);
            Vector<Double> posicionActualizada = new Vector<Double>(3, 0);
            Vector velocidadActualizada = new Vector(3, 0);
            Vector angulosActualizados = new Vector(3, 0);
            posicionActualizada.add(this.getStateValue(y).doubleValue());
            posicionActualizada.add(this.getStateValue(x).doubleValue());
            todoActualizado.add(posicionActualizada);
            msg.add(OutActualizados, todoActualizado);
        }
        Vector<Vector<Number>> todo = new Vector<Vector<Number>>(9, 0);
        estados.add(this.getStateValue(x).doubleValue());
        estados.add(this.getStateValue(y).doubleValue());
        estados.add(this.getStateValue(x1).doubleValue());
        estados.add(this.getStateValue(x2).doubleValue());
        estados.add(this.getStateValue(x3).doubleValue());
        estados.add(this.getStateValue(x4).doubleValue());
        estados.add(this.getStateValue(vx).doubleValue());
        estados.add(this.getStateValue(vy).doubleValue());
        estados.add(this.getStateValue(U).doubleValue());
        estados.add(Integer.parseInt(this.getName()));
        todo.add(estados);
        msg.add(OutTodo, todo);
        return msg;
    }

    @Override
    public void avanzaTiempo() {
        double tiempo = 1.0;
        this.setStateValue(x2, this.ecuacionDif.update(this.getStateValue(x4).doubleValue())[0][0] * tiempo);
        this.actualizaEstados(this.integrador.integra(this, tiempo, this.getStateValue(tactual).doubleValue()));
        this.setStateValue(tactual, this.getStateValue(tactual).doubleValue() + tiempo);
    }

    @Override
    public void deltcon(double e, Message x) {
        this.deltext(e, x);
        this.deltint();
    }

    @Override
    public void dibujar2D(GL gl) {
        this._modeloBarco.dibujar2D(this.getStateValue(x).floatValue(), this.getStateValue(y).floatValue(), gl);
    }

    @Override
    public void dibujar3D(GL gl) {
        this._modeloBarco = new ModeloBarco(gl, this._terreno);
        this._modeloBarco.posicionar(this.getStateValue(x).floatValue() / 1000.0f * 100.0f, -0.2f, this.getStateValue(y).floatValue() / 1000.0f * 100.0f, gl);
        this._modeloBarco.dibujar3D(gl);
    }

    @Override
    public void inicializar(GL gl) {
        this._modeloBarco = new ModeloBarco(gl, this._terreno);
    }

    @Override
    public PV3D obtenerPosicion() {
        PV3D posicion = new PV3D(this.getStateValue(x).floatValue(), 0.0f, this.getStateValue(y).floatValue());
        return posicion;
    }

    @Override
    public float obtenerRumbo() {
        return 0.0f;
    }

    @Override
    public int devolverTipoSeguible() {
        return 0;
    }
}

