/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.barcos;

import java.util.Vector;
import proyectoSI.matematico.IFuncion;
import proyectoSI.matematico.IIntegrador;
import proyectoSI.matematico.RungeKutta;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControladorBarco
extends AtomicStateImpl
implements IFuncion {
    private IIntegrador integrador = new RungeKutta();
    private Message _msg;
    public static final int cambioRumbo = 11;
    public static final String puertoIn = "puertoIn";
    public static final String puertoInAlgoritmo = "puertoInAlgoritmo";
    public static final String puertoInBarco = "puertoInBarco";
    public static final String puertoOut = "puertoOut";
    public static final String puertoConexionExterior = "puertoCE";
    public static final String x = "x";
    public static final String y = "y";
    public static final String x_objetivo = "x_objetivo";
    public static final String y_objetivo = "y_objetivo";
    public static final String vx = "vx";
    public static final String vy = "vy";
    public static final String U = "U";
    public static final String tiempoActual = "tiempoActual";
    private boolean pedir = false;
    public static final String ang_barco = "ang_barco";
    public static final String ang_barco2 = "ang_barco2";
    public static final String ang_objetivo = "ang_objetivo";
    private static final String phase = "phase";
    public static final String dt = "dt";
    private static final String racha = "racha";
    private static final String temporizador = "temporizador";
    public static final int PARADA = 0;
    public static final int RUNNING = 1;

    public ControladorBarco(String name) {
        super(name);
        this.addInport(puertoInAlgoritmo);
        this.addInport(puertoIn);
        this.addInport(puertoInBarco);
        this.addOutport(puertoOut);
        this.addOutport(puertoConexionExterior);
        this.addState(x);
        this.addState(y);
        this.addState(racha);
        this.addState(temporizador);
        this.setStateValue(racha, 0);
        this.addState(x_objetivo);
        this.addState(y_objetivo);
        this.addState(tiempoActual);
        this.addState(vx);
        this.addState(vy);
        this.addState(U);
        this.addState(ang_barco);
        this.addState(ang_barco2);
        this.addState(ang_objetivo);
        this.addState(phase);
        this.addState(dt);
        this.setStateValue(tiempoActual, 0);
        this.setStateValue(temporizador, 10);
        this.setStateValue(vx, 0);
        this.setStateValue(vy, 0);
        this.setStateValue(U, 7.7);
        this.setStateValue(ang_objetivo, 0);
        this.setStateValue(dt, 5);
        this.setStateValue(phase, 0);
        this.setSigma(5.0);
    }

    @Override
    public void deltext(double e, Message x) {
        for (Vector vector : x.getValuesOnPort(puertoInBarco)) {
            Vector vector2 = (Vector)vector.get(0);
            this.setStateValue(x, (Double)vector2.get(0));
            this.setStateValue(y, (Double)vector2.get(1));
            this.setStateValue(vx, (Double)vector2.get(6));
            this.setStateValue(vy, (Double)vector2.get(7));
            this.setStateValue(U, (Double)vector2.get(8));
            this.setStateValue(ang_barco2, (Double)vector2.get(2));
            if (this.getStateValue(phase).intValue() != 0) continue;
        }
        for (Vector vector : x.getValuesOnPort(puertoInAlgoritmo)) {
            if ((Integer)vector.get(0) != Integer.parseInt(this.getName())) continue;
            if (this.getStateValue(phase).intValue() == 0) {
                this.setStateValue(phase, 1);
                this.pedir = true;
            }
            if ((Integer)vector.get(1) == 11) {
                double dpoe = (Double)vector.get(2);
                double dpe = this.getStateValue(x).doubleValue();
                double dpon = (Double)vector.get(3);
                double dpn = this.getStateValue(y).doubleValue();
                double ve = this.getStateValue(vx).doubleValue();
                double vn = this.getStateValue(vy).doubleValue();
                double r1 = dpoe - this.getStateValue(x).doubleValue();
                double r12 = r1 * r1;
                double r2 = dpon - this.getStateValue(y).doubleValue();
                double r22 = r2 * r2;
                double num_tempo = Math.sqrt(r12 + r22);
                double den_tempo = Math.sqrt(ve * ve + vn * vn) * 5.0;
                double valor_temporizador = num_tempo / den_tempo;
                this.setStateValue(temporizador, valor_temporizador);
                Double Xi = Math.atan2(dpon - dpn, dpoe - dpe);
                this.setStateValue(ang_objetivo, Xi);
            }
            this.setStateValue(x_objetivo, (double)((Double)vector.get(2)));
            this.setStateValue(y_objetivo, (double)((Double)vector.get(3)));
            this.setSigma(5.0);
        }
        double d = Math.atan2(this.getStateValue(y_objetivo).doubleValue() - this.getStateValue(y).doubleValue(), this.getStateValue(x_objetivo).doubleValue() - this.getStateValue(x).doubleValue());
        this.setStateValue(ang_barco, this.getStateValue(ang_barco2).doubleValue());
    }

    @Override
    public void deltint() {
        this._msg = new MessageImpl();
        this.avanzaTiempo();
        this.setStateValue(temporizador, this.getStateValue(temporizador).doubleValue() - 1.0);
        if (this.pedir) {
            this.setStateValue(x_objetivo, this.getStateValue(x).doubleValue());
            this.setStateValue(y_objetivo, this.getStateValue(y).doubleValue());
        }
        if (this.pedir || this.getStateValue(temporizador).doubleValue() < 0.0) {
            this.pedir = false;
            this.setStateValue(temporizador, Double.MAX_VALUE);
            Vector<Integer> solicitud = new Vector<Integer>();
            solicitud.add(new Integer(4));
            solicitud.add(new Integer(Integer.parseInt(this.getName())));
            this._msg.add(puertoConexionExterior, solicitud);
        }
        this.setSigma(5.0);
    }

    private Vector<Double> transformarEjes(double xi, Vector<Double> punto) {
        Vector<Double> resultado = new Vector<Double>(2, 0);
        Vector<Double> t = new Vector<Double>(4, 0);
        t.add(new Double(Math.cos(xi)));
        t.add(new Double(Math.sin(xi)));
        t.add(new Double(-Math.sin(xi)));
        t.add(new Double(Math.cos(xi)));
        resultado.add(new Double((Double)t.get(0) * punto.get(0) + (Double)t.get(1) * punto.get(1)));
        resultado.add(new Double((Double)t.get(2) * punto.get(0) + (Double)t.get(3) * punto.get(1)));
        return resultado;
    }

    public void imprimeEstado() {
        System.out.println("x " + this.getStateValue(x).doubleValue() + "y " + this.getStateValue(y).doubleValue() + x_objetivo + this.getStateValue(x_objetivo).doubleValue() + "y_objetivo " + this.getStateValue(y_objetivo).doubleValue() + vx + this.getStateValue(vx).doubleValue() + vy + this.getStateValue(vy).doubleValue() + temporizador + this.getStateValue(temporizador).doubleValue());
    }

    private double calculaControl() {
        Vector<Double> aux = new Vector<Double>(2, 0);
        aux.add(new Double(this.getStateValue(x).doubleValue() - this.getStateValue(x_objetivo).doubleValue()));
        aux.add(new Double(this.getStateValue(y).doubleValue() - this.getStateValue(y_objetivo).doubleValue()));
        Vector<Double> pn = this.transformarEjes(this.getStateValue(ang_barco).doubleValue(), aux);
        aux = new Vector(2, 0);
        aux.add(this.getStateValue(vx).doubleValue());
        aux.add(this.getStateValue(vy).doubleValue());
        Vector<Double> vn = this.transformarEjes(this.getStateValue(ang_barco).doubleValue(), aux);
        double psi = Math.atan2(vn.get(1), vn.get(0));
        double y = pn.get(1);
        double wmin = 5.0E-5;
        double wn = 0.0113;
        double L = Math.sqrt(2.0) * this.getStateValue(U).doubleValue() / wn;
        double eta1 = Math.atan(y / L);
        double eta2 = psi;
        double w = 0.0;
        double eta = -(eta1 + eta2);
        w = Math.abs(eta) <= 1.5707963267948966 ? 2.0 * this.getStateValue(U).doubleValue() / L * Math.sin(eta) : Math.signum(eta) * 2.0 * this.getStateValue(U).doubleValue() / L;
        if (Math.abs(w) < wmin) {
            w = 0.0;
        }
        return w;
    }

    @Override
    public Message lambda() {
        if (this._msg == null) {
            this._msg = new MessageImpl();
        }
        Vector<Number> peticion = new Vector<Number>();
        peticion.add(new Integer(102));
        peticion.add(this.getStateValue(ang_objetivo).doubleValue());
        this._msg.add(puertoOut, peticion);
        return this._msg;
    }

    @Override
    public void deltcon(double e, Message x) {
        this.deltext(e, x);
        this.deltint();
    }

    @Override
    public void actualizaEstados(double[] estadosActuales) {
        this.setStateValue(ang_objetivo, estadosActuales[0]);
    }

    @Override
    public void avanzaTiempo() {
        this.actualizaEstados(this.integrador.integra(this, 1.0, this.getStateValue(tiempoActual).doubleValue()));
        this.setStateValue(tiempoActual, this.getStateValue(tiempoActual).doubleValue() + 1.0);
    }

    @Override
    public double[] dameControlActual() {
        return null;
    }

    @Override
    public double[] dameDerivadas(double tiempo, double[] estados, double[] control) {
        double[] derivadas = new double[]{this.calculaControl()};
        return derivadas;
    }

    @Override
    public double[] dameEstadoActual() {
        double[] estado = new double[]{this.getStateValue(ang_objetivo).doubleValue()};
        return estado;
    }
}

