/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico;

import javax.media.opengl.GL;
import proyectoSI.grafico.Cuadrilatero;
import proyectoSI.grafico.estructura.Color;
import proyectoSI.grafico.estructura.Objeto3D;
import proyectoSI.grafico.estructura.ObjetoCompuesto3D;
import proyectoSI.grafico.estructura.PV3D;
import proyectoSI.grafico.estructura.Tablero;
import proyectoSI.grafico.estructura.terreno.Terreno;

public class ModeloBarco
extends ObjetoCompuesto3D {
    private PV3D _pAnterior;
    private Terreno _terreno;

    public ModeloBarco(GL gl, Terreno terreno) {
        int nObjetos = 8;
        Objeto3D[] objetos = new Objeto3D[nObjetos];
        objetos[0] = new Tablero(0.1f, 30.0f, 10.0f, 2, 2, 2);
        objetos[0].setColor(new Color(1.0f, 1.0f, 1.0f));
        objetos[0].getTafin().rotar(30.0f, 0.0f, 0.0f, 1.0f, gl);
        objetos[0].getTafin().transladar(-((float)(Math.cos(0.523599) * 1.5)), (float)(Math.sin(0.523599) * 1.5), 0.0f, gl);
        objetos[1] = new Tablero(0.1f, 30.0f, 10.0f, 2, 2, 2);
        objetos[1].setColor(new Color(1.0f, 1.0f, 1.0f));
        objetos[1].getTafin().rotar(-30.0f, 0.0f, 0.0f, 1.0f, gl);
        objetos[1].getTafin().transladar((float)(Math.cos(0.523599) * 1.5), (float)(Math.sin(0.523599) * 1.5), 0.0f, gl);
        objetos[2] = new Tablero(13.0f, 30.0f, 0.1f, 2, 2, 2);
        objetos[2].setColor(new Color(0.75f, 0.75f, 0.75f));
        objetos[2].getTafin().transladar(-6.5f, 8.66f, 0.0f, gl);
        objetos[3] = new Tablero(3.0f, 30.0f, 0.1f, 2, 2, 2);
        objetos[3].setColor(new Color(1.0f, 1.0f, 1.0f));
        objetos[3].getTafin().transladar(-1.5f, 0.0f, 0.0f, gl);
        objetos[4] = new Cuadrilatero(3.0f, 13.0f, 10.0f, 0.1f);
        objetos[4].setColor(new Color(1.0f, 1.0f, 1.0f));
        objetos[4].getTafin().rotar(270.0f, 1.0f, 0.0f, 0.0f, gl);
        objetos[5] = new Cuadrilatero(3.0f, 13.0f, 10.0f, 0.1f);
        objetos[5].setColor(new Color(1.0f, 1.0f, 1.0f));
        objetos[5].getTafin().rotar(270.0f, 1.0f, 0.0f, 0.0f, gl);
        objetos[5].getTafin().transladar(0.0f, -30.0f, 0.0f, gl);
        objetos[6] = new Tablero(6.0f, 6.0f, 3.0f, 2, 2, 2);
        objetos[6].setColor(new Color(1.0f, 0.0f, 0.0f));
        objetos[6].getTafin().transladar(-3.0f, 11.76f, 6.0f, gl);
        objetos[7] = new Tablero(8.0f, 10.0f, 3.0f, 2, 2, 2);
        objetos[7].setColor(new Color(0.0f, 0.0f, 0.5f));
        objetos[7].getTafin().transladar(-4.0f, 8.76f, 4.0f, gl);
        this.setNObjetos(nObjetos);
        this.setObjetos(objetos);
        this._terreno = terreno;
    }

    public void roll(float ang, GL gl) {
        this.getTafin().giroAbsolutoZ(ang, gl);
    }

    public void yaw(float ang, GL gl) {
        this.getTafin().giroAbsolutoY(ang, gl);
    }

    public void pitch(float ang, GL gl) {
        this.getTafin().giroAbsolutoX(ang, gl);
    }

    public void posicionar(float x, float y, float z, GL gl) {
        this.getTafin().translacionAbsolutaXYZ(x, y, z, gl);
    }

    public void dibujar2D(float x, float y, GL gl) {
        gl.glPointSize(4.0f);
        gl.glBegin(0);
        if (this._pAnterior != null) {
            if (x >= 0.0f && x / 1000.0f < (float)this._terreno.getLongitud() && y / 1000.0f < (float)this._terreno.getAnchura() && y >= 0.0f) {
                int auxX = (int)x / 1000;
                int auxY = (int)y / 1000;
                float p00 = (float)((1 - (auxX - auxX)) * (1 - (auxY - auxY))) * this._terreno.getAltura(auxX, auxY);
                float p10 = (float)((auxX - auxX) * (1 - (auxY - auxY))) * this._terreno.getAltura(auxX + 1, auxY);
                float p01 = (float)((1 - (auxX - auxX)) * (auxY - auxY)) * this._terreno.getAltura(auxX, auxY + 1);
                float p11 = (float)((auxX - auxX) * (auxY - auxY)) * this._terreno.getAltura(auxX + 1, auxY + 1);
                float altura = p00 + p10 + p01 + p11;
                Color c = Terreno.colorDeMapa(altura);
                gl.glColor3f(c.getRed(), c.getGreen(), c.getBlue());
                gl.glVertex2f(this._pAnterior.getX() / 1000.0f, this._pAnterior.getY() / 1000.0f);
            } else {
                gl.glColor3f(0.0f, 0.0f, 0.0f);
                gl.glVertex2f(this._pAnterior.getX() / 1000.0f, this._pAnterior.getY() / 1000.0f);
            }
        }
        gl.glColor3f(0.0f, 1.0f, 0.0f);
        gl.glVertex2f(x / 1000.0f, y / 1000.0f);
        gl.glEnd();
        this._pAnterior = new PV3D(x, y, 0.0f);
    }
}

