/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico;

import java.util.Iterator;
import java.util.Vector;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class ThreadZoom
extends AtomicStateImpl {
    public static final String InZoom = "INZoom";
    public static final String OutZoom = "OUTZoom";
    private final String factor = "Factor";
    private final String xRight = "XRight";
    private final String xLeft = "XLeft";
    private final String yTop = "YTop";
    private final String yBot = "YBot";
    private final String pasos = "Pasos";
    private final String pasoActual = "PasoActual";
    private final String espera = "Espera";

    public ThreadZoom() {
        super("ThreadZoom");
        this.addInport(InZoom);
        this.addOutport(OutZoom);
        this.addState("Factor");
        this.addState("XRight");
        this.addState("XLeft");
        this.addState("YTop");
        this.addState("YBot");
        this.addState("Pasos");
        this.addState("PasoActual");
        this.addState("Espera");
    }

    public void deltext(double e, Message x) {
        Iterator<Object> iteradorIn = x.getValuesOnPort(InZoom).iterator();
        if (iteradorIn.hasNext()) {
            Vector datos = (Vector)iteradorIn.next();
            while (iteradorIn.hasNext()) {
                datos = (Vector)iteradorIn.next();
            }
            this.setStateValue("XLeft", (Float)datos.get(0));
            this.setStateValue("XRight", (Float)datos.get(1));
            this.setStateValue("YBot", (Float)datos.get(2));
            this.setStateValue("YTop", (Float)datos.get(3));
            this.setStateValue("Factor", (Float)datos.get(4));
            this.setStateValue("Pasos", (Integer)datos.get(5));
            this.setStateValue("PasoActual", new Integer(1));
            this.setStateValue("Espera", (Integer)datos.get(6));
            this.setSigma(this.getStateValue("Espera").doubleValue());
        }
    }

    public void deltint() {
        if (this.getStateValue("PasoActual").intValue() <= this.getStateValue("Pasos").intValue()) {
            this.setStateValue("PasoActual", new Integer(this.getStateValue("PasoActual").intValue() + 1));
            this.setSigma(this.getStateValue("Espera").doubleValue());
        } else {
            this.setSigma(Double.POSITIVE_INFINITY);
        }
    }

    public Message lambda() {
        float xRight = this.getStateValue(this.xRight).floatValue();
        float xLeft = this.getStateValue(this.xLeft).floatValue();
        float yTop = this.getStateValue(this.yTop).floatValue();
        float yBot = this.getStateValue(this.yBot).floatValue();
        int pasos = this.getStateValue(this.pasos).intValue();
        float factor = this.getStateValue(this.factor).floatValue();
        float ixRight = (xRight * factor - xRight) / (float)pasos;
        float ixLeft = (xLeft * factor - xLeft) / (float)pasos;
        float iyTop = (yTop * factor - yTop) / (float)pasos;
        float iyBot = (yBot * factor - yBot) / (float)pasos;
        int pasoActual = this.getStateValue(this.pasoActual).intValue();
        Vector<Float> vector = new Vector<Float>();
        vector.add(new Float(xLeft + ixLeft * (float)pasoActual));
        vector.add(new Float(xRight + ixRight * (float)pasoActual));
        vector.add(new Float(yBot + iyBot * (float)pasoActual));
        vector.add(new Float(yTop + iyTop * (float)pasoActual));
        MessageImpl msg = new MessageImpl();
        msg.add(OutZoom, vector);
        return msg;
    }
}

