/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import proyectoSI.grafico.ManagerGL2D;
import proyectoSI.grafico.ManagerVista;

public class Ventana2D
extends JFrame {
    private static final long serialVersionUID = 1L;
    private ManagerVista _manager;
    private ManagerGL2D _visual;

    public Ventana2D(ManagerVista manager) {
        this.setTitle("Interfaz de simulaci\ufffdn 2D");
        this._manager = manager;
    }

    public void inicializar() {
        this.setSize(800, 600);
        this.configurarBarraHerramientas();
        this.setVisible(false);
        this.setVisible(true);
    }

    private void configurarBarraHerramientas() {
        JToolBar toolBar = new JToolBar("Herramientas");
        this.configurarBotonesZoom(toolBar);
        toolBar.add(new JToolBar.Separator());
        this.configurarBotonesDesplazamiento(toolBar);
        toolBar.setRollover(true);
        this.add((Component)toolBar, "First");
    }

    private void configurarBotonesZoom(JToolBar toolBar) {
        JButton button = this.crearBoton("ZoomIn", "ZoomIn", "Zoom In", "Zoom In");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana2D.this.zoomIn();
            }
        });
        toolBar.add(button);
        button = this.crearBoton("ZoomOut", "ZoomOut", "Zoom Out", "Zoom Out");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana2D.this.zoomOut();
            }
        });
        toolBar.add(button);
    }

    private void configurarBotonesDesplazamiento(JToolBar toolBar) {
        JButton button = this.crearBoton("Izquierda", "desplazar", "Desplazar a la izquierda", "Izquierda");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana2D.this.desplazar(-10.0f, 0.0f);
            }
        });
        toolBar.add(button);
        button = this.crearBoton("Arriba", "desplazar", "Desplazar arriba", "Arriba");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana2D.this.desplazar(0.0f, 10.0f);
            }
        });
        toolBar.add(button);
        button = this.crearBoton("Abajo", "desplazar", "Desplazar abajo", "Abajo");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana2D.this.desplazar(0.0f, -10.0f);
            }
        });
        toolBar.add(button);
        button = this.crearBoton("Derecha", "desplazar", "Desplazar a la derecha", "Derecha");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana2D.this.desplazar(10.0f, 0.0f);
            }
        });
        toolBar.add(button);
    }

    private JButton crearBoton(String imageName, String actionCommand, String toolTipText, String altText) {
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        button.setIcon(new ImageIcon("./Imagenes/" + imageName + ".gif", altText));
        return button;
    }

    private void zoomIn() {
        this._manager.zoom2D(0.5f);
    }

    private void zoomOut() {
        this._manager.zoom2D(2.0f);
    }

    private void desplazar(float x, float y) {
        this._manager.desplazar2D(x, y);
    }

    public void ponerVisual(ManagerGL2D visual) {
        this._visual = visual;
    }
}

