/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico.estructura;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import proyectoSI.grafico.Seguible;
import proyectoSI.grafico.estructura.PV3D;

public class Camara {
    public static final int CENITAL = 0;
    public static final int FRONTAL = 1;
    public static final int LATERAL = 2;
    public static final int POSTERIOR = 3;
    private float _desX;
    private float _desY;
    private float _desZ;
    private boolean _anclada;
    private int _tipoCamara;
    private Seguible _seguible;
    float _pitch;
    float _yaw;
    PV3D _eye;
    PV3D _look;
    PV3D _up;
    PV3D _u;
    PV3D _v;
    PV3D _n;

    public Camara() {
        this._eye = new PV3D();
        this._look = new PV3D();
        this._up = new PV3D();
        this._u = new PV3D();
        this._v = new PV3D();
        this._n = new PV3D();
        this._pitch = 0.0f;
        this._yaw = 0.0f;
        this._anclada = false;
        this._seguible = null;
        this._tipoCamara = -1;
        this._desX = 0.0f;
        this._desY = 0.0f;
        this._desZ = 0.0f;
    }

    public Camara(PV3D eye, PV3D look, PV3D up) {
        this._eye = null;
        this._look = null;
        this._up = null;
        this._u = null;
        this._v = null;
        this._n = null;
        this._pitch = 0.0f;
        this._yaw = 0.0f;
        this._anclada = false;
        this._seguible = null;
        this._tipoCamara = -1;
        this._desX = 0.0f;
        this._desY = 0.0f;
        this._desZ = 0.0f;
        this.setView(eye, look, up);
    }

    public void set_eye(PV3D _eye) {
        this._eye = _eye;
    }

    public PV3D get_eye() {
        return this._eye;
    }

    public void set_look(PV3D _look) {
        this._look = _look;
    }

    public PV3D get_look() {
        return this._look;
    }

    public void set_up(PV3D _up) {
        this._up = _up;
    }

    public PV3D get_up() {
        return this._up;
    }

    public void set_u(PV3D _u) {
        this._u = _u;
    }

    public PV3D get_u() {
        return this._u;
    }

    public void set_v(PV3D _v) {
        this._v = _v;
    }

    public PV3D get_v() {
        return this._v;
    }

    public void set_n(PV3D _n) {
        this._n = _n;
    }

    public PV3D get_n() {
        return this._n;
    }

    public void roll(float ang) {
        float cs = Double.valueOf(Math.cos(Math.PI * (double)ang / 180.0)).floatValue();
        float sn = Double.valueOf(Math.sin(Math.PI * (double)ang / 180.0)).floatValue();
        PV3D viejoU = this._u.clonar();
        PV3D viejoV = this._v.clonar();
        this._u = new PV3D(cs * viejoU.getX() + sn * viejoV.getX(), cs * viejoU.getY() + sn * viejoV.getY(), cs * viejoU.getZ() + sn * viejoV.getZ(), 0);
        this._v = new PV3D(-sn * viejoU.getX() + cs * viejoV.getX(), -sn * viejoU.getY() + cs * viejoV.getY(), -sn * viejoU.getZ() + cs * viejoV.getZ(), 0);
    }

    public void yaw(float ang) {
        float cs = Double.valueOf(Math.cos(Math.PI * (double)ang / 180.0)).floatValue();
        float sn = Double.valueOf(Math.sin(Math.PI * (double)ang / 180.0)).floatValue();
        PV3D viejoN = this._n.clonar();
        PV3D viejoU = this._u.clonar();
        this._u = new PV3D(cs * viejoU.getX() + sn * viejoN.getX(), cs * viejoU.getY() + sn * viejoN.getY(), cs * viejoU.getZ() + sn * viejoN.getZ(), 0);
        this._n = new PV3D(-sn * viejoU.getX() + cs * viejoN.getX(), -sn * viejoU.getY() + cs * viejoN.getY(), -sn * viejoU.getZ() + cs * viejoN.getZ(), 0);
    }

    public void pitch(float ang) {
        float cs = Double.valueOf(Math.cos(Math.PI * (double)ang / 180.0)).floatValue();
        float sn = Double.valueOf(Math.sin(Math.PI * (double)ang / 180.0)).floatValue();
        PV3D viejoN = this._n.clonar();
        PV3D viejoV = this._v.clonar();
        this._v = new PV3D(cs * viejoV.getX() + sn * viejoN.getX(), cs * viejoV.getY() + sn * viejoN.getY(), cs * viejoV.getZ() + sn * viejoN.getZ(), 0);
        this._n = new PV3D(-sn * viejoV.getX() + cs * viejoN.getX(), -sn * viejoV.getY() + cs * viejoN.getY(), -sn * viejoV.getZ() + cs * viejoN.getZ(), 0);
        this._pitch += ang;
    }

    public void yawTo(float ang) {
        this.yaw(ang - this._yaw);
    }

    public void pitchTo(float ang) {
        this.pitch(ang - this._pitch);
    }

    public void desplazar(float desU, float desV, float desN) {
        System.out.println(">>> " + desV);
        this._eye.setX(this._eye.getX() + desU * this._u.getX() + desV * this._v.getX() + desN * this._n.getX());
        this._eye.setY(this._eye.getY() + desU * this._u.getY() + desV * this._v.getY() + desN * this._n.getY());
        this._eye.setZ(this._eye.getZ() + desU * this._u.getZ() + desV * this._v.getZ() + desN * this._n.getZ());
    }

    public void goTo(float x, float y, float z) {
        System.out.println(">>> " + y);
        this._eye.setX(x);
        this._eye.setY(y);
        this._eye.setZ(z);
    }

    public void setModelViewMatrix(GL gl) {
        float[] m = new float[]{this._u.getX(), this._v.getX(), this._n.getX(), 0.0f, this._u.getY(), this._v.getY(), this._n.getY(), 0.0f, this._u.getZ(), this._v.getZ(), this._n.getZ(), 0.0f, -this._eye.prodEscalar(this._u), -this._eye.prodEscalar(this._v), -this._eye.prodEscalar(this._n), 1.0f};
        gl.glMatrixMode(5888);
        gl.glLoadMatrixf(m, 0);
    }

    public void setView(PV3D eye, PV3D look, PV3D up) {
        this._eye = eye;
        this._look = look;
        this._up = up;
        this._n = new PV3D(this._eye.getX() - this._look.getX(), this._eye.getY() - this._look.getY(), this._eye.getZ() - this._look.getZ(), 0);
        this._n.normalizar();
        this._u = this._up.prodVectorial(this._n);
        this._u.normalizar();
        this._v = this._n.prodVectorial(this._u);
        this._v.normalizar();
    }

    public void fijarVistaOrtogonal(float xLeft, float xRight, float yBot, float yTop, float N, float F, GL gl) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho((double)xLeft, (double)xRight, (double)yBot, (double)yTop, (double)N, (double)F);
        this.setModelViewMatrix(gl);
    }

    public void fijarVistaPerspectiva(float angulo, float proporcion, float N, float F, GL gl) {
        GLU glu = new GLU();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluPerspective((double)angulo, (double)proporcion, (double)N, (double)F);
        this.setModelViewMatrix(gl);
    }

    public void fijarVistaOblicua(float xLeft, float xRight, float yBot, float yTop, float N, float F, PV3D d, GL gl) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho((double)xLeft, (double)xRight, (double)yBot, (double)yTop, (double)N, (double)F);
        if ((double)d.getZ() == 0.0) {
            return;
        }
        float[] m = new float[16];
        for (int i = 0; i < 16; ++i) {
            m[i] = i % 5 == 0 ? 1.0f : 0.0f;
        }
        m[8] = -d.getX() / d.getZ();
        m[9] = -d.getY() / d.getZ();
        gl.glMultMatrixf(m, 0);
        this.setModelViewMatrix(gl);
    }

    public void anclar(Seguible seguible, int tipoCamara) {
        this._tipoCamara = tipoCamara;
        switch (tipoCamara) {
            case 0: {
                if (seguible.devolverTipoSeguible() == 1) {
                    this._desY = 5000.0f;
                    this._desX = 10.0f;
                    this._desZ = 25.0f;
                    this.setView(this._eye, new PV3D(0.0f, -1.0f, 0.0f), new PV3D(0.0f, 0.0f, 1.0f));
                    break;
                }
                this._desY = 50.0f;
                this._desX = 0.0f;
                this._desZ = 50.0f;
                this.setView(this._eye, new PV3D(0.0f, -1.0f, 0.0f), new PV3D(0.0f, 0.0f, 1.0f));
                break;
            }
            case 1: {
                if (seguible.devolverTipoSeguible() == 1) {
                    this._desY = 0.0f;
                    this._desX = 0.0f;
                    this._desZ = 30000.0f;
                    this.setView(this._eye, new PV3D(0.0f, -1.0f, 0.0f), new PV3D(0.0f, 1.0f, 0.0f));
                    break;
                }
                this._desY = 10.0f;
                this._desX = 0.0f;
                this._desZ = 700.0f;
                this.setView(this._eye, new PV3D(0.0f, -1.0f, 0.0f), new PV3D(0.0f, 1.0f, 0.0f));
                break;
            }
            case 3: {
                if (seguible.devolverTipoSeguible() == 1) {
                    this._desY = 0.0f;
                    this._desX = 0.0f;
                    this._desZ = -30000.0f;
                    this.setView(this._eye, new PV3D(0.0f, 1.0f, 0.0f), new PV3D(0.0f, 1.0f, 0.0f));
                    break;
                }
                this._desY = 10.0f;
                this._desX = 0.0f;
                this._desZ = -1000.0f;
                this.setView(this._eye, new PV3D(0.0f, 1.0f, 0.0f), new PV3D(0.0f, 1.0f, 0.0f));
                break;
            }
            case 2: {
                if (seguible.devolverTipoSeguible() == 1) {
                    this._desY = 0.0f;
                    this._desX = 10000.0f;
                    this._desZ = 0.0f;
                    this.setView(this._eye, new PV3D(-1.0f, 0.0f, 0.0f), new PV3D(0.0f, 1.0f, 0.0f));
                    break;
                }
                this._desY = 10.0f;
                this._desX = 1000.0f;
                this._desZ = 0.0f;
                this.setView(this._eye, new PV3D(-1.0f, 0.0f, 0.0f), new PV3D(0.0f, 1.0f, 0.0f));
            }
        }
        this._seguible = seguible;
        this._anclada = true;
    }

    public void desanclar() {
        this._anclada = false;
    }

    public void actualizar(GL gl) {
        if (this._anclada) {
            System.out.println("desX " + this._desX);
            System.out.println("desY " + this._desY);
            System.out.println("desz " + this._desZ);
            PV3D posicion = this._seguible.obtenerPosicion();
            this._eye.setX((posicion.getX() + this._desX) / 10.0f);
            this._eye.setY(posicion.getY() + this._desY);
            this._eye.setZ((posicion.getZ() + this._desZ) / 10.0f);
        }
        this.setModelViewMatrix(gl);
    }

    public void dibujar2d(GL gl) {
        gl.glPointSize(4.0f);
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glBegin(0);
        gl.glVertex2f(this._eye.getX() / 100.0f, this._eye.getZ() / 100.0f);
        gl.glEnd();
    }
}

