/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico.estructura;

import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneradorTerreno {
    private int _tipoTerreno;
    private int _tipoActual;
    private int _longitudTablero;
    private float _numTurnosCambio;
    private float _alturaMaxima;
    private float _alturaMinima;
    private static final int TERRENOMONTA\u00d1OSO = 4;
    private static final int TERRENOINTERMEDIO1 = 3;
    private static final int TERRENOINTERMEDIO2 = 2;
    private static final int TERRENOMAR = 1;
    private ArrayList<ArrayList<Float>> terreno;

    public GeneradorTerreno(int tipo, int longitud, float altM, float altm) {
        this._tipoActual = tipo;
        this._tipoTerreno = tipo;
        this._longitudTablero = longitud;
        this._numTurnosCambio = 0.0f;
        this._alturaMaxima = altM;
        this._alturaMinima = altm;
        this.terreno = new ArrayList();
        for (int i = 0; i < this._longitudTablero; ++i) {
            ArrayList actual = new ArrayList();
            this.terreno.add(i, actual);
            for (int j = 0; j < this._longitudTablero; ++j) {
                this.terreno.get(i).add(j, Float.valueOf(-1.0f));
            }
        }
    }

    public void AlerarCasillasAdyacentes(int x, int y) {
        this._numTurnosCambio -= 1.0f;
        if (this._numTurnosCambio <= 0.0f) {
            this.calculaTipo();
            this._numTurnosCambio = 100.0f;
        }
        ArrayList<Float> cercania = new ArrayList<Float>();
        if (x > 0) {
            cercania.add(this.terreno.get(x - 1).get(y));
        }
        if (x + 1 < this.terreno.size()) {
            cercania.add(this.terreno.get(x + 1).get(y));
        }
        if (y > 0) {
            cercania.add(this.terreno.get(x).get(y - 1));
        }
        if (x > 0 && y > 0) {
            cercania.add(this.terreno.get(x - 1).get(y - 1));
        }
        if (y + 1 < this.terreno.get(this.terreno.size() - 1).size()) {
            cercania.add(this.terreno.get(x).get(y + 1));
        }
        if (x + 1 < this.terreno.size() && y + 1 < this.terreno.get(this.terreno.size() - 1).size()) {
            cercania.add(this.terreno.get(x + 1).get(y + 1));
        }
        if (x > 0 && y > 0) {
            cercania.add(this.terreno.get(x - 1).get(y - 1));
        }
        if (x > 0 && y + 1 < this.terreno.get(this.terreno.size() - 1).size()) {
            cercania.add(this.terreno.get(x - 1).get(y + 1));
        }
        if (x + 1 < this.terreno.size() && y > 0) {
            cercania.add(this.terreno.get(x + 1).get(y - 1));
        }
        float total = 0.0f;
        int num_validos = 0;
        Random randomizador = new Random();
        boolean asciende = randomizador.nextFloat() > this.convierteProb(this._tipoActual);
        for (int i = 0; i < cercania.size(); ++i) {
            if (((Float)cercania.get(i)).floatValue() == -1.0f) continue;
            total += ((Float)cercania.get(i)).floatValue();
            ++num_validos;
        }
        float valor_media = Float.valueOf(total / (float)num_validos).floatValue();
        float valor_teorico = this.variacion(valor_media, asciende);
        float valor_real = this.restriccion(valor_teorico);
        this.terreno.get(x).set(y, Float.valueOf(valor_real));
    }

    private void calculaTipo() {
        Random randomizador = new Random();
        float num = randomizador.nextFloat();
        if ((double)num < 0.5) {
            this._tipoActual = this._tipoTerreno;
        } else if ((double)num < 0.6875) {
            this._tipoActual = 1;
        } else if ((double)num < 0.75) {
            this._tipoActual = 3;
        } else if ((double)num < 0.875) {
            this._tipoActual = 2;
        } else if ((double)num < 1.0) {
            this._tipoActual = 4;
        }
    }

    private float restriccion(float valor_teorico) {
        float valor = valor_teorico;
        if (valor_teorico > this._alturaMaxima) {
            valor = this._alturaMaxima;
        }
        if (valor_teorico < this._alturaMinima) {
            valor = this._alturaMinima;
        }
        if (valor_teorico < 10.0f) {
            valor = 0.0f;
        }
        return valor;
    }

    private float variacion(float valor_media, boolean asciende) {
        Random randomizador = new Random();
        float porcv = Float.valueOf(randomizador.nextFloat()).floatValue();
        if (!asciende) {
            porcv = -porcv;
        }
        porcv = valor_media + porcv * 350.0f;
        return porcv;
    }

    private void modificacionInicial(int x, int y) {
        Float altura = new Float(0.1f);
        this.terreno.get(x).set(y, altura);
    }

    private float convierteProb(int terreno2) {
        return 1.0f / (float)terreno2;
    }

    public void imprimeMatriz() {
        for (int i = 0; i < this._longitudTablero; ++i) {
            for (int j = 0; j < this._longitudTablero; ++j) {
            }
        }
    }

    public void creaTablero() {
        this.modificacionInicial(1, 1);
        for (int cont = 1; cont < 30; ++cont) {
            this.a\u00f1adeMar(1);
        }
        this.a\u00f1adeMar(300);
        this.a\u00f1adeMar(300);
        for (int i = 0; i < this._longitudTablero; ++i) {
            for (int j = 0; j < this._longitudTablero; ++j) {
                this.AlerarCasillasAdyacentes(i, j);
            }
        }
        this.convierteMatriz(this._alturaMaxima, 1.0f);
    }

    private void a\u00f1adeMar(int numIteraciones) {
        int numRestantes = numIteraciones;
        Random randomizador = new Random();
        int px = randomizador.nextInt(this._longitudTablero);
        int py = randomizador.nextInt(this._longitudTablero);
        float grado_admitir = 0.001f;
        int num_iteraciones = 0;
        while (this.terreno.get(px).get(py).floatValue() > grado_admitir) {
            px = randomizador.nextInt(this._longitudTablero);
            py = randomizador.nextInt(this._longitudTablero);
            if (++num_iteraciones <= 100) continue;
            grado_admitir *= 2.0f;
            num_iteraciones = 0;
        }
        grado_admitir = 0.01f;
        num_iteraciones = 0;
        while (numRestantes > 0) {
            int direccion;
            if (++num_iteraciones > 8) {
                grado_admitir *= 2.0f;
                num_iteraciones = 0;
            }
            if (this.terreno.get(px).get(py).floatValue() != 0.0f) {
                this.terreno.get(px).set(py, Float.valueOf(0.0f));
                --numRestantes;
                grado_admitir = 0.01f;
            }
            if ((direccion = randomizador.nextInt(4)) == 0 && py < this._longitudTablero - 1 && this.terreno.get(px).get(py + 1).floatValue() < grado_admitir) {
                ++py;
            }
            if (direccion == 1 && py > 0 && this.terreno.get(px).get(py - 1).floatValue() < grado_admitir) {
                --py;
            }
            if (direccion == 2 && px > 0 && this.terreno.get(px - 1).get(py).floatValue() < grado_admitir) {
                --px;
            }
            if (direccion != 3 || px >= this._longitudTablero - 1 || !(this.terreno.get(px + 1).get(py).floatValue() < grado_admitir)) continue;
            ++px;
        }
    }

    private void convierteMatriz(float MaximoAnterior, float nuevoMaximo) {
        for (int i = 0; i < this.terreno.size(); ++i) {
            for (int j = 0; j < this.terreno.size(); ++j) {
                float ant = this.terreno.get(i).get(j).floatValue();
                ant = ant / MaximoAnterior * nuevoMaximo;
                this.terreno.get(i).set(j, Float.valueOf(ant));
            }
        }
    }

    public ArrayList<ArrayList<Float>> dameTerreno() {
        return this.terreno;
    }
}

