/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico.estructura;

import javax.media.opengl.GL;
import proyectoSI.grafico.estructura.Cara;
import proyectoSI.grafico.estructura.Objeto3D;
import proyectoSI.grafico.estructura.PV3D;
import proyectoSI.grafico.estructura.VerticeNormal;

public class Malla
extends Objeto3D {
    private int _nVertices;
    private int _nNormales;
    private int _nCaras;
    private Cara[] _caras;
    private PV3D[] _normales;
    private PV3D[] _vertices;

    public Malla() {
        this._nVertices = 0;
        this._nNormales = 0;
        this._nCaras = 0;
        this._caras = null;
        this._normales = null;
        this._vertices = null;
    }

    public Malla(int nVertices, int nNormales, int nCaras, Cara[] caras, PV3D[] normales, PV3D[] vertices) {
        this._nVertices = nVertices;
        this._nNormales = nNormales;
        this._nCaras = nCaras;
        this._caras = caras;
        this._normales = normales;
        this._vertices = vertices;
    }

    public void setNVertices(int nVertices) {
        this._nVertices = nVertices;
    }

    public void setNNormales(int nNormales) {
        this._nNormales = nNormales;
    }

    public void setNCaras(int nCaras) {
        this._nCaras = nCaras;
    }

    public void setCaras(Cara[] caras) {
        this._caras = caras;
    }

    public void setNormales(PV3D[] normales) {
        this._normales = normales;
    }

    public void setVertices(PV3D[] vertices) {
        this._vertices = vertices;
    }

    public void dibujar3D(GL gl) {
        gl.glPushMatrix();
        gl.glMultMatrixf(this.getTafin().getMatriz(), 0);
        gl.glColor3f(this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue());
        for (int i = 0; i < this._nCaras; ++i) {
            gl.glBegin(9);
            for (int j = 0; j < this._caras[i].getNumVertices(); ++j) {
                int iV = this._caras[i].getVerticeNormal()[j].getVertice();
                int iN = this._caras[i].getVerticeNormal()[j].getNormal();
                gl.glNormal3f(this._normales[iN].getX(), this._normales[iN].getY(), this._normales[iN].getZ());
                gl.glVertex3f(this._vertices[iV].getX(), this._vertices[iV].getY(), this._vertices[iV].getZ());
            }
            gl.glEnd();
        }
        gl.glPopMatrix();
    }

    public static Malla construirPared(PV3D ii, PV3D id, PV3D si, PV3D sd) {
        PV3D[] vertices = new PV3D[4];
        PV3D[] normales = new PV3D[1];
        Cara[] caras = new Cara[1];
        vertices[0] = id;
        vertices[1] = sd;
        vertices[2] = si;
        vertices[3] = ii;
        Cara c = new Cara(4, new VerticeNormal[4]);
        c.getVerticeNormal()[0] = new VerticeNormal(0, 0);
        c.getVerticeNormal()[1] = new VerticeNormal(1, 0);
        c.getVerticeNormal()[2] = new VerticeNormal(2, 0);
        c.getVerticeNormal()[3] = new VerticeNormal(3, 0);
        caras[0] = c;
        Malla pared = new Malla(4, 1, 1, caras, normales, vertices);
        pared.calcularNormalesNewell();
        return pared;
    }

    public void calcularNormalesNewell() {
        for (int i = 0; i < this._nNormales; ++i) {
            float nx = 0.0f;
            float ny = 0.0f;
            float nz = 0.0f;
            for (int j = 0; j < this._caras[i].getNumVertices(); ++j) {
                PV3D actual = this._vertices[this._caras[i].getVerticeNormal()[j].getVertice()];
                int suc = j == this._caras[i].getNumVertices() - 1 ? 0 : j + 1;
                PV3D sucesor = this._vertices[this._caras[i].getVerticeNormal()[suc].getVertice()];
                nx += (actual.getY() - sucesor.getY()) * (actual.getZ() + sucesor.getZ());
                ny += (actual.getZ() - sucesor.getZ()) * (actual.getX() + sucesor.getX());
                nz += (actual.getX() - sucesor.getX()) * (actual.getY() + sucesor.getY());
            }
            this._normales[i] = new PV3D(nx, ny, nz);
        }
    }

    public void invertirNormales() {
        for (int i = 0; i < this._nNormales; ++i) {
            this._normales[i].setX(-this._normales[i].getX());
            this._normales[i].setY(-this._normales[i].getY());
            this._normales[i].setZ(-this._normales[i].getZ());
        }
    }
}

