/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico.estructura;

public class PV3D {
    private float _x;
    private float _y;
    private float _z;
    private int _pv;

    public PV3D() {
        this._x = 0.0f;
        this._y = 0.0f;
        this._z = 0.0f;
        this._pv = 1;
    }

    public PV3D(float _x, float _y, float _z) {
        this._x = _x;
        this._y = _y;
        this._z = _z;
        this._pv = 1;
    }

    public PV3D(float _x, float _y, float _z, int _pv) {
        this._x = _x;
        this._y = _y;
        this._z = _z;
        this._pv = _pv;
    }

    public float getX() {
        return this._x;
    }

    public void setX(float _x) {
        this._x = _x;
    }

    public float getY() {
        return this._y;
    }

    public void setY(float _y) {
        this._y = _y;
    }

    public float getZ() {
        return this._z;
    }

    public void setZ(float _z) {
        this._z = _z;
    }

    public int getPV() {
        return this._pv;
    }

    public void setPV(int _pv) {
        this._pv = _pv;
    }

    public void normalizar() {
        float modulo = this.modulo();
        if (modulo != 0.0f) {
            this._x /= modulo;
            this._y /= modulo;
            this._z /= modulo;
        }
    }

    public PV3D clonar() {
        return new PV3D(this._x, this._y, this._z, this._pv);
    }

    public float modulo() {
        return Double.valueOf(Math.sqrt(this._x * this._x + this._y * this._y + this._z * this._z)).floatValue();
    }

    public float prodEscalar(PV3D vector) {
        return this._x * vector.getX() + this._y * vector.getY() + this._z * vector.getZ();
    }

    public PV3D prodVectorial(PV3D vector) {
        float x = this._y * vector.getZ() - this._z * vector.getY();
        float y = -(this._x * vector.getZ() - this._z * vector.getX());
        float z = this._x * vector.getY() - this._y * vector.getX();
        return new PV3D(x, y, z, 0);
    }
}

