/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico.estructura;

import proyectoSI.grafico.estructura.Cara;
import proyectoSI.grafico.estructura.Malla;
import proyectoSI.grafico.estructura.PV3D;
import proyectoSI.grafico.estructura.VerticeNormal;

public class Tablero
extends Malla {
    private float _largo;
    private float _ancho;
    private float _grueso;
    private int _nlargo;
    private int _nancho;
    private int _ngrueso;

    public Tablero(float largo, float ancho, float grueso, int nlargo, int nancho, int ngrueso) {
        int z;
        int j;
        int i;
        this._largo = largo;
        this._ancho = ancho;
        this._grueso = grueso;
        this._nlargo = nlargo;
        this._nancho = nancho;
        this._ngrueso = ngrueso;
        float incLargo = largo / (float)nlargo;
        float incAncho = ancho / (float)nancho;
        float incGrueso = grueso / (float)ngrueso;
        int verX = nlargo + 1;
        int verY = ngrueso + 1;
        int verZ = nancho + 1;
        int verYZ = verY * verZ;
        int nVert = verX * verY * verZ;
        int nNorm = nlargo * ngrueso * 2 + nlargo * nancho * 2 + ngrueso * nancho * 2;
        PV3D[] vert = new PV3D[nVert];
        PV3D[] norm = new PV3D[nNorm];
        Cara[] car = new Cara[nNorm];
        for (i = 0; i < nlargo + 1; ++i) {
            for (j = 0; j < ngrueso + 1; ++j) {
                for (int z2 = 0; z2 < nancho + 1; ++z2) {
                    vert[i * (nancho + 1) * (ngrueso + 1) + j * (nancho + 1) + z2] = new PV3D(incLargo * (float)i, incGrueso * (float)j, incAncho * (float)z2, 1);
                }
            }
        }
        for (i = 0; i < nlargo; ++i) {
            for (j = 0; j < ngrueso; ++j) {
                Cara c = new Cara(4, new VerticeNormal[4]);
                c.getVerticeNormal()[0] = new VerticeNormal(j * verZ + i * verYZ, i * ngrueso + j);
                c.getVerticeNormal()[1] = new VerticeNormal((j + 1) * verZ + i * verYZ, i * ngrueso + j);
                c.getVerticeNormal()[2] = new VerticeNormal((j + 1) * verZ + (i + 1) * verYZ, i * ngrueso + j);
                c.getVerticeNormal()[3] = new VerticeNormal(j * verZ + (i + 1) * verYZ, i * ngrueso + j);
                car[i * ngrueso + j] = c;
                c = new Cara(4, new VerticeNormal[4]);
                c.getVerticeNormal()[0] = new VerticeNormal(j * verZ + i * verYZ + nancho, i * ngrueso + j + ngrueso * nlargo);
                c.getVerticeNormal()[1] = new VerticeNormal(j * verZ + (i + 1) * verYZ + nancho, i * ngrueso + j + ngrueso * nlargo);
                c.getVerticeNormal()[2] = new VerticeNormal((j + 1) * verZ + (i + 1) * verYZ + nancho, i * ngrueso + j + ngrueso * nlargo);
                c.getVerticeNormal()[3] = new VerticeNormal((j + 1) * verZ + i * verYZ + nancho, i * ngrueso + j + ngrueso * nlargo);
                car[i * ngrueso + j + ngrueso * nlargo] = c;
            }
        }
        for (int j2 = 0; j2 < ngrueso; ++j2) {
            for (z = 0; z < nancho; ++z) {
                Cara c = new Cara(4, new VerticeNormal[4]);
                c.getVerticeNormal()[0] = new VerticeNormal(j2 * verZ + z, j2 * nancho + z + nlargo * ngrueso * 2);
                c.getVerticeNormal()[1] = new VerticeNormal(j2 * verZ + z + 1, j2 * nancho + z + nlargo * ngrueso * 2);
                c.getVerticeNormal()[2] = new VerticeNormal((j2 + 1) * verZ + z + 1, j2 * nancho + z + nlargo * ngrueso * 2);
                c.getVerticeNormal()[3] = new VerticeNormal((j2 + 1) * verZ + z, j2 * nancho + z + nlargo * ngrueso * 2);
                car[j2 * nancho + z + nlargo * ngrueso * 2] = c;
                c = new Cara(4, new VerticeNormal[4]);
                c.getVerticeNormal()[0] = new VerticeNormal(j2 * verZ + z + nlargo * verYZ, j2 * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho);
                c.getVerticeNormal()[1] = new VerticeNormal((j2 + 1) * verZ + z + nlargo * verYZ, j2 * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho);
                c.getVerticeNormal()[2] = new VerticeNormal((j2 + 1) * verZ + z + 1 + nlargo * verYZ, j2 * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho);
                c.getVerticeNormal()[3] = new VerticeNormal(j2 * verZ + z + 1 + nlargo * verYZ, j2 * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho);
                car[j2 * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho] = c;
            }
        }
        for (i = 0; i < nlargo; ++i) {
            for (z = 0; z < nancho; ++z) {
                Cara c = new Cara(4, new VerticeNormal[4]);
                c.getVerticeNormal()[0] = new VerticeNormal(i * verYZ + z, i * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho * 2);
                c.getVerticeNormal()[1] = new VerticeNormal((i + 1) * verYZ + z, i * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho * 2);
                c.getVerticeNormal()[2] = new VerticeNormal((i + 1) * verYZ + z + 1, i * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho * 2);
                c.getVerticeNormal()[3] = new VerticeNormal(i * verYZ + z + 1, i * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho * 2);
                car[i * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho * 2] = c;
                c = new Cara(4, new VerticeNormal[4]);
                c.getVerticeNormal()[0] = new VerticeNormal(i * verYZ + z + verZ * ngrueso, i * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho * 2 + nlargo * nancho);
                c.getVerticeNormal()[1] = new VerticeNormal(i * verYZ + z + 1 + verZ * ngrueso, i * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho * 2 + nlargo * nancho);
                c.getVerticeNormal()[2] = new VerticeNormal((i + 1) * verYZ + z + 1 + verZ * ngrueso, i * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho * 2 + nlargo * nancho);
                c.getVerticeNormal()[3] = new VerticeNormal((i + 1) * verYZ + z + verZ * ngrueso, i * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho * 2 + nlargo * nancho);
                car[i * nancho + z + nlargo * ngrueso * 2 + ngrueso * nancho * 2 + nlargo * nancho] = c;
            }
        }
        this.setCaras(car);
        this.setNCaras(nNorm);
        this.setNNormales(nNorm);
        this.setNormales(norm);
        this.setNVertices(nVert);
        this.setVertices(vert);
        this.calcularNormalesNewell();
    }
}

