/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.modelo;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import proyectoSI.modelo.CoupledSimulacion;
import proyectoSI.simulacion.ListaPosicion;
import proyectoSI.simulacion.Punto;

public class GoogleEarth {
    private static final int BUFFER_SIZE = 36;

    public static void crearFicheroPrincipal(int refresco, String ruta, String ficheroRefresco) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element kml = doc.createElement("kml");
            kml.setAttribute("xmlns", "http://earth.google.com/kml/2.2");
            Element document = doc.createElement("Document");
            kml.appendChild(document);
            Element nombre = doc.createElement("name");
            nombre.setTextContent("Simulaci\u00f3n xDEVS");
            document.appendChild(nombre);
            Element descripcion = doc.createElement("description");
            descripcion.setTextContent("Visualizaci\u00f3n de la simulaci\u00f3n DEVS en tiempo real");
            document.appendChild(descripcion);
            Element networklink = doc.createElement("NetworkLink");
            nombre = doc.createElement("name");
            nombre.setTextContent("V\u00ednculo al fichero actualizado");
            networklink.appendChild(nombre);
            Element open = doc.createElement("open");
            open.setTextContent("1");
            networklink.appendChild(open);
            Element url = doc.createElement("Url");
            Element href = doc.createElement("href");
            href.setTextContent(ficheroRefresco);
            url.appendChild(href);
            Element refreshMode = doc.createElement("refreshMode");
            refreshMode.setTextContent("onInterval");
            url.appendChild(refreshMode);
            Element refreshInterval = doc.createElement("refreshInterval");
            refreshInterval.setTextContent(Integer.valueOf(refresco / 1000).toString());
            url.appendChild(refreshInterval);
            networklink.appendChild(url);
            document.appendChild(networklink);
            doc.appendChild(kml);
            OutputFormat format = new OutputFormat("xml", "UTF-8", true);
            XMLSerializer serializer = new XMLSerializer(format);
            FileWriter xmlFile = new FileWriter(new File(ruta));
            serializer.setOutputCharStream(xmlFile);
            serializer.serialize(doc);
            xmlFile.flush();
            xmlFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void crearDocumentoRefresco(String ruta, ListaPosicion lista, CoupledSimulacion simulacion, double lonIzq, double latInf) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element kml = doc.createElement("kml");
            kml.setAttribute("xmlns", "http://earth.google.com/kml/2.2");
            Element document = doc.createElement("Document");
            kml.appendChild(document);
            Element nombre = doc.createElement("name");
            nombre.setTextContent("Simulaci\ufffdn xDEVS");
            document.appendChild(nombre);
            Element descripcion = doc.createElement("description");
            descripcion.setTextContent("Datos de la simulaci\ufffdn DEVS en tiempo real");
            document.appendChild(descripcion);
            String nombreE = null;
            String descripcionE = null;
            String icono = null;
            for (int i = 0; i < lista.dameLista().size(); ++i) {
                Punto punto = lista.dameLista().get(i).getPunto();
                double[] lonlat = GoogleEarth.transformarXYLatLon(punto.getN(), punto.getE(), latInf, lonIzq);
                switch (lista.dameLista().get(i).getTipoVehiculo()) {
                    case 1: {
                        nombreE = "Avi\u00f3n";
                        descripcionE = "Avi\u00f3n " + lista.dameLista().get(i).getNombre();
                        icono = "http://maps.google.com/mapfiles/kml/shapes/airports.png";
                        break;
                    }
                    case 2: {
                        nombreE = "Barco";
                        descripcionE = "Barco " + lista.dameLista().get(i).getNombre();
                        icono = "http://maps.google.com/mapfiles/kml/shapes/sailing.png";
                        break;
                    }
                    case 3: {
                        nombreE = "Naufrago";
                        descripcionE = "Naufrago " + lista.dameLista().get(i).getNombre();
                        icono = "http://maps.google.com/mapfiles/kml/shapes/swimming.png";
                    }
                }
                document.appendChild(GoogleEarth.crearPlacemark(doc, nombreE, descripcionE, icono, lonlat[0], lonlat[1], punto.getH(), lista.dameLista().get(i).getTipoVehiculo(), lista.dameLista().get(i).getNombre(), simulacion));
            }
            doc.appendChild(kml);
            OutputFormat format = new OutputFormat("xml", "UTF-8", true);
            XMLSerializer serializer = new XMLSerializer(format);
            FileWriter xmlFile = new FileWriter(new File(ruta));
            serializer.setOutputCharStream(xmlFile);
            serializer.serialize(doc);
            xmlFile.flush();
            xmlFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Element crearPlacemark(Document doc, String nombre, String descripcion, String icono, double latitud, double longitud, double altura, int tipo, int numeroVehiculo, CoupledSimulacion simulacion) {
        float h = 0.0f;
        float r = 0.0f;
        float t = 0.0f;
        float scaleX = 10.0f;
        float scaleY = 10.0f;
        float scaleZ = 10.0f;
        String modelo = "";
        switch (tipo) {
            case 1: {
                h = 270.0f - simulacion._aviones.get(numeroVehiculo).getAvion().obtenerRumbo();
                modelo = "./modelos/Plane.dae";
                Element placemark = doc.createElement("Placemark");
                Element name = doc.createElement("name");
                name.setTextContent(nombre);
                Element description = doc.createElement("description");
                description.setTextContent(descripcion);
                Element point = doc.createElement("Point");
                Element coordinates = doc.createElement("coordinates");
                coordinates.setTextContent(longitud + ", " + latitud + ", " + altura);
                point.appendChild(coordinates);
                Element icon = doc.createElement("Icon");
                Element href = doc.createElement("href");
                href.setTextContent(icono);
                icon.appendChild(href);
                placemark.appendChild(name);
                placemark.appendChild(description);
                placemark.appendChild(point);
                placemark.appendChild(icon);
                Element model = doc.createElement("Model");
                Element altitudeMode = doc.createElement("altitudeMode");
                altitudeMode.setTextContent("clampToGround");
                model.appendChild(altitudeMode);
                Element location = doc.createElement("Location");
                Element longitude = doc.createElement("longitude");
                longitude.setTextContent(Double.valueOf(longitud).toString());
                location.appendChild(longitude);
                Element latitude = doc.createElement("latitude");
                latitude.setTextContent(Double.valueOf(latitud).toString());
                location.appendChild(latitude);
                Element altitude = doc.createElement("altitude");
                location.appendChild(altitude);
                model.appendChild(location);
                Element orientation = doc.createElement("Orientation");
                Element heading = doc.createElement("heading");
                heading.setTextContent(Float.valueOf(h).toString());
                orientation.appendChild(heading);
                Element tilt = doc.createElement("tilt");
                tilt.setTextContent(Float.valueOf(t).toString());
                orientation.appendChild(tilt);
                Element roll = doc.createElement("roll");
                roll.setTextContent(Float.valueOf(r).toString());
                orientation.appendChild(roll);
                model.appendChild(orientation);
                Element scale = doc.createElement("Scale");
                Element x = doc.createElement("x");
                x.setTextContent(Float.valueOf(scaleX).toString());
                scale.appendChild(x);
                Element y = doc.createElement("y");
                y.setTextContent(Float.valueOf(scaleY).toString());
                scale.appendChild(y);
                Element z = doc.createElement("z");
                z.setTextContent(Float.valueOf(scaleZ).toString());
                scale.appendChild(z);
                model.appendChild(scale);
                Element link = doc.createElement("Link");
                href = doc.createElement("href");
                href.setTextContent(modelo);
                link.appendChild(href);
                model.appendChild(link);
                placemark.appendChild(model);
                return placemark;
            }
            case 2: {
                h = 270.0f - simulacion._barcos.get(numeroVehiculo -= simulacion._aviones.size()).getBarco().obtenerRumbo();
                modelo = "./modelos/barco.dae";
                Element placemark = doc.createElement("Placemark");
                Element name = doc.createElement("name");
                name.setTextContent(nombre);
                Element description = doc.createElement("description");
                description.setTextContent(descripcion);
                Element point = doc.createElement("Point");
                Element coordinates = doc.createElement("coordinates");
                coordinates.setTextContent(longitud + ", " + latitud + ", " + altura);
                point.appendChild(coordinates);
                Element icon = doc.createElement("Icon");
                Element href = doc.createElement("href");
                href.setTextContent(icono);
                icon.appendChild(href);
                placemark.appendChild(name);
                placemark.appendChild(description);
                placemark.appendChild(point);
                placemark.appendChild(icon);
                Element model = doc.createElement("Model");
                Element altitudeMode = doc.createElement("altitudeMode");
                altitudeMode.setTextContent("clampToGround");
                model.appendChild(altitudeMode);
                Element location = doc.createElement("Location");
                Element longitude = doc.createElement("longitude");
                longitude.setTextContent(Double.valueOf(longitud).toString());
                location.appendChild(longitude);
                Element latitude = doc.createElement("latitude");
                latitude.setTextContent(Double.valueOf(latitud).toString());
                location.appendChild(latitude);
                Element altitude = doc.createElement("altitude");
                location.appendChild(altitude);
                model.appendChild(location);
                Element orientation = doc.createElement("Orientation");
                Element heading = doc.createElement("heading");
                heading.setTextContent(Float.valueOf(h).toString());
                orientation.appendChild(heading);
                Element tilt = doc.createElement("tilt");
                tilt.setTextContent(Float.valueOf(t).toString());
                orientation.appendChild(tilt);
                Element roll = doc.createElement("roll");
                roll.setTextContent(Float.valueOf(r).toString());
                orientation.appendChild(roll);
                model.appendChild(orientation);
                Element scale = doc.createElement("Scale");
                Element x = doc.createElement("x");
                x.setTextContent(Float.valueOf(scaleX).toString());
                scale.appendChild(x);
                Element y = doc.createElement("y");
                y.setTextContent(Float.valueOf(scaleY).toString());
                scale.appendChild(y);
                Element z = doc.createElement("z");
                z.setTextContent(Float.valueOf(scaleZ).toString());
                scale.appendChild(z);
                model.appendChild(scale);
                Element link = doc.createElement("Link");
                href = doc.createElement("href");
                href.setTextContent(modelo);
                link.appendChild(href);
                model.appendChild(link);
                placemark.appendChild(model);
                return placemark;
            }
            case 3: {
                modelo = "";
                Element placemark = doc.createElement("Placemark");
                Element name = doc.createElement("name");
                name.setTextContent(nombre);
                Element description = doc.createElement("description");
                description.setTextContent(descripcion);
                Element point = doc.createElement("Point");
                Element coordinates = doc.createElement("coordinates");
                coordinates.setTextContent(longitud + ", " + latitud + ", " + altura);
                point.appendChild(coordinates);
                Element icon = doc.createElement("Icon");
                Element href = doc.createElement("href");
                href.setTextContent(icono);
                icon.appendChild(href);
                placemark.appendChild(name);
                placemark.appendChild(description);
                placemark.appendChild(point);
                placemark.appendChild(icon);
                return placemark;
            }
        }
        return null;
    }

    public static double[] transformarXYLatLon(double x, double y, double latInf, double lonIzq) {
        double lat_orig = latInf;
        double lon_orig = lonIzq;
        lat_orig = lat_orig * Math.PI / 180.0;
        double R = 6378.0;
        double ro = R * (1.0 / Math.tan(lat_orig));
        double theta = Math.atan((x /= 1000.0) / (ro - (y /= 1000.0)));
        double lambda = theta / Math.sin(lat_orig);
        double longitud = lambda * 180.0 / Math.PI;
        double rp = (ro - y) / Math.cos(theta);
        double latitud = Math.asin(1.0 / Math.sin(lat_orig) - rp * Math.cos(lat_orig) / R) * 180.0 / Math.PI;
        double[] resultado = new double[2];
        resultado[1] = latitud;
        resultado[0] = longitud += lon_orig;
        return resultado;
    }

    public static void crearFicheroKMZ(String ruta, ListaPosicion lista, CoupledSimulacion simulacion, double latInf, double lonIzq) {
        try {
            int count;
            GoogleEarth.crearDocumentoRefresco("./resources/fichero.kml", lista, simulacion, latInf, lonIzq);
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(ruta);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[36];
            FileInputStream fi = new FileInputStream("./resources/fichero.kml");
            origin = new BufferedInputStream(fi, 36);
            ZipEntry entry = new ZipEntry("fichero.kml");
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 36)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
            fi = new FileInputStream("./resources/Plane.dae");
            origin = new BufferedInputStream(fi, 36);
            entry = new ZipEntry("/modelos/plane.dae");
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 36)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
            fi = new FileInputStream("./Imagenes/texture0.jpg");
            origin = new BufferedInputStream(fi, 36);
            entry = new ZipEntry("/imagenes/texture0.jpg");
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 36)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
            fi = new FileInputStream("./Imagenes/texture1.jpg");
            origin = new BufferedInputStream(fi, 36);
            entry = new ZipEntry("/imagenes/texture1.jpg");
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 36)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
            fi = new FileInputStream("./Imagenes/texture2.jpg");
            origin = new BufferedInputStream(fi, 36);
            entry = new ZipEntry("/imagenes/texture2.jpg");
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 36)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
            fi = new FileInputStream("./Imagenes/texture3.jpg");
            origin = new BufferedInputStream(fi, 36);
            entry = new ZipEntry("/imagenes/texture3.jpg");
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 36)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
            fi = new FileInputStream("./resources/barco.dae");
            origin = new BufferedInputStream(fi, 36);
            entry = new ZipEntry("/modelos/barco.dae");
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 36)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
            fi = new FileInputStream("./resources/textures.txt");
            origin = new BufferedInputStream(fi, 36);
            entry = new ZipEntry("textures.txt");
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 36)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
            out.close();
            File residuo = new File("./resources/fichero.kml");
            residuo.delete();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        GoogleEarth.crearFicheroPrincipal(1, "./Principal.kml", "./refresco.kml");
    }
}

