/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.simulacion;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import proyectoSI.Mux.DatoMux;
import proyectoSI.genetic.Genetic;
import proyectoSI.incidencias.ProbabilidadNaufrago;
import proyectoSI.incidencias.ProbabilidadNaufragoCasillas;
import proyectoSI.matematico.FuncionProbabilidadAbstracta;
import proyectoSI.matematico.MaximaVerosimilitud;
import proyectoSI.simulacion.Algoritmo;
import proyectoSI.simulacion.Aprendizaje;
import proyectoSI.simulacion.DatosTipoPosicion;
import proyectoSI.simulacion.ListaEnviar;
import proyectoSI.simulacion.ListaPosicion;
import proyectoSI.simulacion.ParEnviar;
import proyectoSI.simulacion.Punto;
import proyectoSI.simulacion.Rescate;
import proyectoSI.simulacion.Ruta;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class Controlador
extends AtomicStateImpl {
    private boolean rescatanAviones;
    FuncionProbabilidadAbstracta probabilidadAngulo;
    FuncionProbabilidadAbstracta probabilidadVelocidad;
    FuncionProbabilidadAbstracta probabilidadAnguloReal;
    FuncionProbabilidadAbstracta probabilidadVelocidadReal;
    ListaEnviar listaEnviar;
    public static int num_encontrados = 0;
    public static final int CreaNaufragos = 1;
    public static final int CreaAviones = 2;
    public static final int CreaBarcos = 3;
    public static final int ActualizaPosicion = 4;
    public static final String tiempo = "tiempo";
    public static final String estado = "estado";
    public static final String numAviones = "numAviones";
    public static final String numBarcos = "numBarcos";
    public static int crea = 1;
    public static int creaAviones = 2;
    public static int creaBarcos = 3;
    public static int inicia = 4;
    public static int daRumbo = 5;
    public static int espera = 6;
    private int avion_creado = 0;
    private int barco_creado = 0;
    private ArrayList<Rescate> rescates;
    private ArrayList<Aprendizaje> evolucion;
    private int num_naufragos = 0;
    private boolean escribir_historial = false;
    public static final String InAviones = "INA";
    public static final String InReloj = "INR";
    public static final String InControladorAviones = "INCA";
    public static final String InControladorBarcos = "INCB";
    public static final String InBarcos = "INB";
    public static final String InTerreno = "INT";
    public static final String InNaufragos = "INN";
    public static final String OutAviones = "OUTA";
    public static final String salidaGE = "salidaGoogle";
    public static final String OutControladorAviones = "OUTCA";
    public static final String OutControladorBarcos = "OUTCB";
    public static final String OutBarcos = "OUTB";
    public static final String OutNaufragos = "OUTN";
    ListaPosicion posiciones;
    public Algoritmo algoritmo;
    private ProbabilidadNaufrago _probabilidad_naufrago;
    private ProbabilidadNaufragoCasillas _probabilidad_naufrago_casillas;
    private Genetic _genetico;
    private double tiempoSimulacion;
    private boolean ficheroCerrado = false;
    private boolean guardarFichero;
    private double velocidad_avion;
    double[][] terreno;
    int tama\u00f1o_matriz_terreno;
    public static final String posn_ini = "posn_ini";
    public static final String pose_ini = "pose_ini";
    public boolean _xmlOSer = false;
    Punto pinicial = new Punto(0.0, 0.0, 0.0);
    private String nombreEjecucion;
    double posicion_n_avion;
    double posicion_e_avion;
    double distanciaAvion;
    double posicion_n_barco;
    double posicion_e_barco;
    double distanciaBarco;
    public double tiempo_ini = 0.0;

    public Controlador(String name, double tiempoIni, int numaviones, int numbarcos, int numnaufragos, boolean guardarXML, String nombreEjecucion, boolean XmlOSer, Double velocidadAvion, Double posicionNAvion, Double posicionEAvion, Double distanciaCuadradoAvion, Double posicionNBarco, Double posicionEBarco, Double distanciaCuadradoBarco, boolean rescatanaviones) {
        super(name);
        this.rescatanAviones = rescatanaviones;
        this.velocidad_avion = velocidadAvion;
        this.posicion_n_avion = posicionNAvion;
        this.posicion_e_avion = posicionEAvion;
        this.distanciaAvion = distanciaCuadradoAvion;
        this.posicion_n_barco = posicionNBarco;
        this.posicion_e_barco = posicionEBarco;
        this.distanciaBarco = distanciaCuadradoBarco;
        this._xmlOSer = XmlOSer;
        this.guardarFichero = guardarXML;
        this.rescates = new ArrayList();
        this.evolucion = new ArrayList();
        this.tiempo_ini = tiempoIni;
        this.num_naufragos = numnaufragos;
        this.probabilidadAngulo = new MaximaVerosimilitud(1.0, 1.0, 0.0);
        this.probabilidadVelocidad = new MaximaVerosimilitud(3.0, 3.0, 0.0);
        this.probabilidadAnguloReal = new MaximaVerosimilitud(1.0, 1.0, 0.0);
        this.probabilidadVelocidadReal = new MaximaVerosimilitud(3.0, 3.0, 0.0);
        this.algoritmo = new Genetic(0, 10);
        this.nombreEjecucion = nombreEjecucion;
        try {
            if (this._xmlOSer) {
                this._probabilidad_naufrago.leerFichero(this.nombreEjecucion);
            } else {
                FileInputStream fis = null;
                ObjectInputStream in = null;
                try {
                    fis = new FileInputStream("probabilidad2.nau");
                    in = new ObjectInputStream(fis);
                    this._probabilidad_naufrago_casillas = (ProbabilidadNaufragoCasillas)in.readObject();
                    this.tiempoSimulacion = this._probabilidad_naufrago.dameTiempoFinal();
                    in.close();
                    System.out.println("fichero leido");
                }
                catch (IOException ex) {
                    this._probabilidad_naufrago_casillas = new ProbabilidadNaufragoCasillas(0.0, 36000.0, 60.0, 1000.0, 1000.0);
                    this.tiempoSimulacion = this._probabilidad_naufrago_casillas.dameTiempoFinal();
                    System.out.println("fichero creado");
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                    this._probabilidad_naufrago_casillas = new ProbabilidadNaufragoCasillas(0.0, 36000.0, 60.0, 1000.0, 1000.0);
                    this.tiempoSimulacion = this._probabilidad_naufrago_casillas.dameTiempoFinal();
                    System.out.println("fichero creado");
                }
            }
        }
        catch (Exception e) {
            System.err.println("fichero" + nombreEjecucion + " no creado");
            this._probabilidad_naufrago = new ProbabilidadNaufrago(0.0, 36000.0, 360.0, 50000.0, 200000.0, 4000.0, 50000.0, 200000.0, 4000.0);
            this.tiempoSimulacion = this._probabilidad_naufrago.dameTiempoFinal();
        }
        this.addInport(InReloj);
        this.addInport(InAviones);
        this.addInport(InControladorAviones);
        this.addInport(InControladorBarcos);
        this.addInport(InBarcos);
        this.addInport(InTerreno);
        this.addInport(InNaufragos);
        this.addOutport(OutAviones);
        this.addOutport(OutControladorAviones);
        this.addOutport(OutControladorBarcos);
        this.addOutport(salidaGE);
        this.addOutport(OutBarcos);
        this.addOutport(OutNaufragos);
        this.addState(tiempo);
        this.addState(numAviones);
        this.addState(numBarcos);
        this.setStateValue(numAviones, numaviones);
        this.setStateValue(numBarcos, numbarcos);
        this.setStateValue(tiempo, tiempoIni);
        this.addState(estado);
        this.addState(posn_ini);
        this.addState(pose_ini);
        this.listaEnviar = new ListaEnviar();
        this.setStateValue(estado, crea);
        this.posiciones = new ListaPosicion();
        this.setSigma(0.1);
    }

    public int barcoMasCercano(Punto punto) {
        ArrayList<DatosTipoPosicion> posiciones_barcos = this.posiciones.filtraTipo(2);
        int i = -1;
        double dist_min = Double.MAX_VALUE;
        double distancia = 0.0;
        for (int cont = 0; cont < posiciones_barcos.size(); ++cont) {
            distancia = this.distancia(posiciones_barcos.get((int)cont).punto, punto);
            if (!(distancia < dist_min)) continue;
            dist_min = distancia;
            i = cont;
        }
        return i;
    }

    public double distancia(Punto p1, Punto p2) {
        double de = Math.pow(p1.getE() - p2.getE(), 2.0);
        double dn = Math.pow(p1.getN() - p2.getN(), 2.0);
        return Math.sqrt(dn + de);
    }

    public void deltext(double arg0, Message arg1) {
        DatoMux dato;
        double distancia;
        if (this.getStateValue(tiempo).intValue() % 600 < 100 && this.escribir_historial) {
            Aprendizaje actual = new Aprendizaje(this.getStateValue(tiempo).intValue(), this.probabilidadVelocidad.dameMedia(), this.probabilidadAngulo.dameMedia(), this.probabilidadVelocidad.dameVarianza(), this.probabilidadAngulo.dameVarianza());
            actual.ponDatosReales(this.probabilidadVelocidadReal.dameMedia(), this.probabilidadAnguloReal.dameMedia(), this.probabilidadVelocidadReal.dameVarianza(), this.probabilidadAnguloReal.dameVarianza());
            this.evolucion.add(actual);
            this.escribir_historial = false;
        }
        if (this.getStateValue(tiempo).intValue() % 600 > 100) {
            this.escribir_historial = true;
        }
        Iterator<Object> iteradorAvion = arg1.getValuesOnPort(InAviones).iterator();
        Object var5_4 = null;
        Vector lista = null;
        while (iteradorAvion.hasNext()) {
            Vector vector = (Vector)iteradorAvion.next();
            lista = (Vector)vector.get(0);
            for (int cont = 0; cont < lista.size(); ++cont) {
                DatoMux dato2 = (DatoMux)lista.get(cont);
                Vector solicitud = (Vector)dato2.dameDato();
                Vector posicion = (Vector)solicitud.get(0);
                double e = (Double)posicion.get(0);
                double n = (Double)posicion.get(1);
                double h = (Double)posicion.get(2);
                Punto punto = new Punto(n, e, h);
                DatosTipoPosicion datosp = new DatosTipoPosicion((Integer)solicitud.get(6), 1, punto);
                this.posiciones.a\u00f1adePosicion(datosp);
                int pos = this.posiciones.buscaPosicion(datosp);
                if ((double)this.getStateValue(tiempo).intValue() > this.tiempo_ini) {
                    if (this.posiciones.dameLista().get((int)pos).ruta == null) {
                        this.probabilidadAngulo.NuevoValor(true, this.probabilidadAnguloReal.dameMedia());
                        this.probabilidadVelocidad.NuevoValor(true, this.probabilidadVelocidadReal.dameMedia());
                    }
                    if (this.posiciones.dameLista().get((int)pos).ruta == null || this.posiciones.dameLista().get((int)pos).ruta.dameRestantes() < 1) {
                        Ruta rutaActual = this.algoritmo.dameRuta(1, punto, this.pinicial, this.getStateValue(tiempo).intValue(), this.probabilidadAnguloReal, this.probabilidadVelocidadReal, this._probabilidad_naufrago_casillas);
                        this.posiciones.dameLista().get(pos).ponRuta(rutaActual, true);
                    }
                }
                ArrayList<DatosTipoPosicion> listaNaufragos = this.posiciones.filtraTipo(3);
                double velocidad = 0.0;
                distancia = 0.0;
                double angulo = 0.0;
                int num_encontrados_ant = num_encontrados;
                for (int cont2 = 0; cont2 < listaNaufragos.size(); ++cont2) {
                    if (!(Math.abs(punto.getE() - listaNaufragos.get((int)cont2).punto.getE()) < 1000.0) || !(Math.abs(punto.getN() - listaNaufragos.get((int)cont2).punto.getN()) < 1000.0)) continue;
                    ++num_encontrados;
                    angulo = Math.atan2(-this.pinicial.getN() + punto.getN(), -this.pinicial.getE() + punto.getE());
                    distancia = this.distancia(this.pinicial, punto);
                    velocidad = distancia / this.getStateValue(tiempo).doubleValue();
                    this.probabilidadAngulo.NuevoValor(true, angulo);
                    this.probabilidadVelocidad.NuevoValor(true, velocidad);
                    this.rescates.add(new Rescate((Integer)solicitud.get(6), this.getStateValue(tiempo).intValue()));
                    int nombreNaufrago = listaNaufragos.get((int)cont2).nombre;
                    Vector<Integer> encontrado = new Vector<Integer>();
                    encontrado.add(2);
                    encontrado.add(nombreNaufrago);
                    this.posiciones.eliminaPosicion(nombreNaufrago, 3);
                    if (!this.rescatanAviones) continue;
                    this.listaEnviar.a\u00f1adePar(new ParEnviar(OutNaufragos, encontrado));
                }
                if (this.getStateValue(tiempo).doubleValue() % 20.0 == 0.0 && (Integer)solicitud.get(6) != 0) continue;
            }
        }
        for (Vector vector : arg1.getValuesOnPort(InBarcos)) {
            lista = (Vector)vector.get(0);
            for (int cont = 0; cont < lista.size(); ++cont) {
                dato = (DatoMux)lista.get(cont);
                Vector solicitud = (Vector)dato.dameDato();
                Vector posicion = (Vector)solicitud.get(0);
                double e = (Double)posicion.get(1);
                double n = (Double)posicion.get(0);
                Punto punto = new Punto(n, e, 0.0);
                DatosTipoPosicion datosp = new DatosTipoPosicion((Integer)posicion.get(9), 2, punto);
                this.posiciones.a\u00f1adePosicion(datosp);
                int pos = this.posiciones.buscaPosicion(datosp);
                if ((double)this.getStateValue(tiempo).intValue() > this.tiempo_ini) {
                    if (this.posiciones.dameLista().get((int)pos).ruta == null) {
                        this.probabilidadAngulo.NuevoValor(true, this.probabilidadAnguloReal.dameMedia());
                        this.probabilidadVelocidad.NuevoValor(true, this.probabilidadVelocidadReal.dameMedia());
                    }
                    if (this.posiciones.dameLista().get((int)pos).ruta == null || this.posiciones.dameLista().get((int)pos).ruta.dameRestantes() < 1) {
                        Ruta rutaActual = this.algoritmo.dameRuta(2, punto, this.pinicial, this.getStateValue(tiempo).intValue(), this.probabilidadAngulo, this.probabilidadVelocidad, this._probabilidad_naufrago_casillas);
                        this.posiciones.dameLista().get(pos).ponRuta(rutaActual, true);
                    }
                }
                ArrayList<DatosTipoPosicion> listaNaufragos = this.posiciones.filtraTipo(3);
                double velocidad = 0.0;
                double distancia2 = 0.0;
                double angulo = 0.0;
                int num_encontrados_ant = num_encontrados;
                for (int cont2 = 0; cont2 < listaNaufragos.size(); ++cont2) {
                    if (!(Math.abs(punto.getE() - listaNaufragos.get((int)cont2).punto.getE()) < 1000.0) || !(Math.abs(punto.getN() - listaNaufragos.get((int)cont2).punto.getN()) < 1000.0)) continue;
                    this.rescates.add(new Rescate((Integer)posicion.get(9), this.getStateValue(tiempo).intValue()));
                    int nombreNaufrago = listaNaufragos.get((int)cont2).nombre;
                    Vector<Integer> encontrado = new Vector<Integer>();
                    encontrado.add(2);
                    encontrado.add(nombreNaufrago);
                    this.posiciones.eliminaPosicion(nombreNaufrago, 3);
                    this.listaEnviar.a\u00f1adePar(new ParEnviar(OutNaufragos, encontrado));
                    ++num_encontrados;
                    angulo = Math.atan2(this.pinicial.getN() - punto.getN(), this.pinicial.getE() - punto.getE());
                    distancia2 = this.distancia(this.pinicial, punto);
                    velocidad = distancia2 / this.getStateValue(tiempo).doubleValue();
                    this.probabilidadAngulo.NuevoValor(true, angulo);
                    this.probabilidadVelocidad.NuevoValor(true, velocidad);
                }
            }
        }
        for (Vector vector : arg1.getValuesOnPort(InControladorAviones)) {
            lista = (Vector)vector.get(0);
            dato = null;
            for (int cont = 0; cont < lista.size(); ++cont) {
                dato = (DatoMux)lista.get(cont);
                this.listaEnviar.a\u00f1adePar(this.enviaPunto((Integer)((Vector)dato.dameDato()).get(1), 1, OutControladorAviones));
            }
        }
        for (Vector vector : arg1.getValuesOnPort(InControladorBarcos)) {
            lista = (Vector)vector.get(0);
            for (int cont = 0; cont < lista.size(); ++cont) {
                DatoMux dato3 = (DatoMux)lista.get(cont);
                ParEnviar enviar = this.enviaPunto((Integer)((Vector)dato3.dameDato()).get(1), 2, OutControladorBarcos);
                this.listaEnviar.a\u00f1adePar(enviar);
            }
        }
        for (Vector vector : arg1.getValuesOnPort(InNaufragos)) {
            lista = (Vector)vector.get(0);
            for (int cont = 0; cont < lista.size(); ++cont) {
                DatoMux dato4 = (DatoMux)lista.get(cont);
                Vector solicitud = (Vector)dato4.dameDato();
                double e = (Double)solicitud.get(1);
                double n = (Double)solicitud.get(0);
                double h = 0.0;
                Punto punto = new Punto(n, e, h);
                this.setStateValue(tiempo, (Double)solicitud.get(2));
                double angulo = Math.atan2(this.pinicial.getN() - punto.getN(), this.pinicial.getE() - punto.getE());
                distancia = this.distancia(this.pinicial, punto);
                double velocidad = distancia / this.getStateValue(tiempo).doubleValue();
                if (this.getStateValue(tiempo).intValue() > 100 && velocidad != Double.NaN && velocidad != Double.POSITIVE_INFINITY && velocidad != Double.NEGATIVE_INFINITY) {
                    this.probabilidadAnguloReal.NuevoValor(true, angulo);
                    this.probabilidadVelocidadReal.NuevoValor(true, velocidad);
                }
                DatosTipoPosicion datosp = new DatosTipoPosicion((Integer)solicitud.get(3), 3, punto);
                if (this.guardarFichero) {
                    if ((Double)solicitud.get(2) > this.tiempoSimulacion && !this.ficheroCerrado) {
                        if (this._xmlOSer) {
                            System.out.println("fichero xml cerrado");
                            this._probabilidad_naufrago.escribirFichero(this.nombreEjecucion);
                            this.ficheroCerrado = true;
                        } else {
                            FileOutputStream fos = null;
                            ObjectOutputStream out = null;
                            try {
                                fos = new FileOutputStream("probabilidad2.nau");
                                out = new ObjectOutputStream(fos);
                                out.writeObject(this._probabilidad_naufrago_casillas);
                                out.close();
                                this.ficheroCerrado = true;
                                System.out.println("fichero nau cerrado");
                            }
                            catch (IOException ex) {
                                System.err.println("fichero no cerrado");
                            }
                        }
                    }
                    if (!this.ficheroCerrado) {
                        if (this._xmlOSer) {
                            this._probabilidad_naufrago.llegaNaufrago(n, e, (Double)solicitud.get(2));
                        } else {
                            this._probabilidad_naufrago_casillas.llegaNaufrago(n, e, (Double)solicitud.get(2));
                        }
                    }
                }
                this.posiciones.a\u00f1adePosicion(datosp);
            }
        }
        this.listaEnviar.a\u00f1adePar(new ParEnviar(salidaGE, this.posiciones));
        this.setSigma(0.0);
    }

    private ParEnviar enviaPunto(Integer numero, int tipoVehiculo, String puerto) {
        DatosTipoPosicion posicionBuscar = new DatosTipoPosicion(numero, tipoVehiculo, null);
        int posicion = this.posiciones.buscaPosicion(posicionBuscar);
        posicionBuscar = this.posiciones.lista.get(posicion);
        Punto siguiente = null;
        double n = Double.MAX_VALUE;
        double e = Double.MAX_VALUE;
        double h = 100.0;
        if (posicionBuscar != null) {
            e = posicionBuscar.getPunto().getE();
            n = posicionBuscar.getPunto().getN();
            if (posicionBuscar.ruta != null) {
                Punto actual = posicionBuscar.punto;
                Punto punto = posicionBuscar.ruta.damePuntoActual();
                posicionBuscar.ruta.avanzaPunto();
                e = punto.getE();
                n = punto.getN();
            }
        }
        h = posicionBuscar.punto.getH();
        siguiente = new Punto(n, e, h);
        Vector<Number> solicitud = new Vector<Number>();
        if (posicionBuscar.tipoVehiculo == 1) {
            solicitud.add(new Integer(1100));
            solicitud.add(new Double(siguiente.getE()));
            solicitud.add(new Double(siguiente.getN()));
            solicitud.add(new Double(siguiente.getH()));
            solicitud.add(numero);
        }
        if (posicionBuscar.tipoVehiculo == 2) {
            solicitud.add(numero);
            solicitud.add(new Integer(11));
            solicitud.add(new Double(siguiente.getN()));
            solicitud.add(new Double(siguiente.getE()));
            solicitud.add(new Double(siguiente.getH()));
        }
        ParEnviar enviar = new ParEnviar(puerto, solicitud);
        return enviar;
    }

    public void deltint() {
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    public Message lambda() {
        Vector<Number> todo;
        MessageImpl msg = new MessageImpl();
        if (this.getStateValue(estado).doubleValue() == (double)crea) {
            todo = new Vector<Number>();
            todo.add(0, 1);
            double norte = 125000.0;
            double este = 150000.0;
            todo.add(1, norte);
            this.setStateValue(posn_ini, norte);
            todo.add(2, este);
            this.setStateValue(pose_ini, este);
            todo.add(3, 0.0);
            this.pinicial = new Punto(norte, este, 0.0);
            msg.add(OutNaufragos, todo);
            this.setStateValue(estado, creaAviones);
        } else if (this.getStateValue(estado).doubleValue() == (double)creaAviones) {
            todo = new Vector();
            todo.add(0, 331);
            Random randomizador = new Random();
            todo.add(1, new Double(randomizador.nextDouble() * this.distanciaAvion) + this.posicion_e_avion);
            todo.add(2, new Double(randomizador.nextDouble() * this.distanciaAvion) + this.posicion_n_avion);
            todo.add(3, new Double(1000.0));
            todo.add(4, new Double(this.velocidad_avion));
            todo.add(5, new Double(70.0));
            todo.add(6, new Double(0.0));
            todo.add(7, new Integer(this.avion_creado));
            ++this.avion_creado;
            msg.add(OutAviones, todo);
            if ((double)this.avion_creado == this.getStateValue(numAviones).doubleValue()) {
                this.setStateValue(estado, 3);
            }
        } else if (this.getStateValue(estado).doubleValue() == 3.0) {
            todo = new Vector();
            todo.add(0, 1);
            Random randomizador = new Random();
            todo.add(1, new Double(randomizador.nextDouble() * this.distanciaBarco) + this.posicion_e_barco);
            todo.add(2, new Double(randomizador.nextDouble() * this.distanciaBarco) + this.posicion_n_barco);
            todo.add(3, new Double(100.0));
            todo.add(4, new Double(100.0));
            todo.add(5, new Integer(this.getStateValue(numAviones).intValue() + this.barco_creado));
            ++this.barco_creado;
            msg.add(OutBarcos, todo);
            if (this.barco_creado == this.getStateValue(numBarcos).intValue()) {
                this.setStateValue(estado, inicia);
            }
        } else if (this.getStateValue(estado).doubleValue() == (double)inicia) {
            todo = new Vector();
            todo.add(0, 336);
            todo.add(1, new Double(0.1));
            msg.add(OutAviones, todo);
            this.setStateValue(estado, daRumbo);
        }
        for (int cont = 0; cont < this.listaEnviar.dameLista().size(); ++cont) {
            msg.add(this.listaEnviar.dameLista().get(cont).damePuerto(), this.listaEnviar.dameLista().get(cont).dameMensaje());
        }
        this.listaEnviar = new ListaEnviar();
        return msg;
    }

    public int NumNaufragosRescatados() {
        return this.rescates.size();
    }

    public int NumNaufragosSinRescatar() {
        return this.num_naufragos - this.rescates.size();
    }

    public void dEvolucionRescates() {
    }

    public void dEvolucionMediaVarianzaV() {
    }

    public void dEvolucionMediaVarianzaA() {
    }
}

