/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.ArrayList;
import java.util.Iterator;
import test.Job;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class Transducer
extends AtomicImpl {
    public static final String arrived = "arrived";
    public static final String solved = "solved";
    public static final String out = "out";
    protected ArrayList<Job> jobsArrived;
    protected ArrayList<Job> jobsSolved;
    protected double observationTime;
    protected double total_ta;
    protected double clock;

    public Transducer() {
        super("Transducer");
        this.addInport(arrived);
        this.addInport(solved);
        this.addOutport(out);
        this.jobsArrived = new ArrayList();
        this.jobsSolved = new ArrayList();
        this.observationTime = 10.0;
        this.setSigma(this.observationTime);
        this.total_ta = 0.0;
        this.clock = 0.0;
    }

    public Transducer(String name, double observationTime) {
        super(name);
        this.addInport(arrived);
        this.addInport(solved);
        this.addOutport(out);
        this.jobsArrived = new ArrayList();
        this.jobsSolved = new ArrayList();
        this.observationTime = observationTime;
        this.setSigma(observationTime);
        this.total_ta = 0.0;
        this.clock = 0.0;
    }

    public void deltint() {
        double throughput;
        double avg_ta_time;
        this.clock += this.getSigma();
        if (!this.jobsSolved.isEmpty()) {
            avg_ta_time = this.total_ta / (double)this.jobsSolved.size();
            throughput = this.clock > 0.0 ? (double)this.jobsSolved.size() / this.clock : 0.0;
        } else {
            avg_ta_time = 0.0;
            throughput = 0.0;
        }
        System.out.println("End time: " + this.clock);
        System.out.println("jobs arrived : " + this.jobsArrived.size());
        System.out.println("jobs solved : " + this.jobsSolved.size());
        System.out.println("AVERAGE TA = " + avg_ta_time);
        System.out.println("THROUGHPUT = " + throughput);
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    public void deltext(double e, Message x) {
        this.setSigma(this.getSigma() - e);
        this.clock += e;
        Iterator<Object> itr = null;
        for (Job job : x.getValuesOnPort(arrived)) {
            System.out.println("Start job " + job.getName() + " @ t = " + this.clock);
            job.setTime(this.clock);
            this.jobsArrived.add(job);
        }
        for (Job job : x.getValuesOnPort(solved)) {
            this.total_ta += this.clock - job.getTime();
            System.out.println("Finish job " + job.getName() + " @ t = " + this.clock);
            job.setTime(this.clock);
            this.jobsSolved.add(job);
        }
    }

    public Message lambda() {
        Job job = new Job("null");
        MessageImpl msg = new MessageImpl();
        msg.add(out, job);
        return msg;
    }
}

